/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation;

import java.awt.Component;
import java.awt.Dimension;
import kandid.calculation.PixelCalculation;
import kandid.colorator.ColorF32;
import kandid.colorator.Colorator;
import kandid.soup.ChromosomeType;
import kandid.util.Util;

public abstract class RefinementCalculation
extends PixelCalculation
implements Cloneable {
    protected int depth;
    protected double xwMin;
    protected double xwMax;
    protected double ywMin;
    protected double ywMax;
    protected int xp;
    protected int yp;
    protected double xw;
    protected double yw;
    protected int xpDelta;
    protected int ypDelta;
    protected double xwDelta;
    protected double ywDelta;
    protected int actDepth;
    protected int xSteps;
    protected int ySteps;
    protected boolean more;
    protected boolean ready;

    @Override
    public void setChromosome(ChromosomeType chromosome, Colorator colorator) {
        super.setChromosome(chromosome, colorator);
    }

    @Override
    public void activateCanvas(Component viewComponent, Dimension canvasSize, boolean zoomMode) {
        super.activateCanvas(viewComponent, canvasSize, zoomMode);
        this.ready = false;
        this.actDepth = this.depth;
        this.setDeltas();
    }

    protected boolean enterDepth() {
        if (this.actDepth > 0) {
            --this.actDepth;
            if (this.actDepth == 0) {
                this.setFineDeltas();
            } else {
                this.setDeltas();
            }
            this.more = true;
            return true;
        }
        this.ready = true;
        return false;
    }

    private void setDeltas() {
        this.xpDelta = Util.powerOf2(this.actDepth);
        this.ypDelta = Util.powerOf2(this.actDepth);
        this.xSteps = this.canvasSize.width / this.xpDelta;
        this.ySteps = this.canvasSize.height / this.ypDelta;
        this.xwDelta = (this.xwMax - this.xwMin) / (double)this.xSteps;
        this.ywDelta = (this.ywMax - this.ywMin) / (double)this.ySteps;
        this.xp = this.xpDelta / 2;
        this.yp = this.xpDelta / 2;
        this.xw = this.xwMin + this.xwDelta / 2.0;
        this.yw = this.ywMin + this.ywDelta / 2.0;
    }

    private void setFineDeltas() {
        this.xpDelta = 1;
        this.ypDelta = 1;
        this.xSteps = this.canvasSize.width;
        this.ySteps = this.canvasSize.height;
        this.xwDelta = (this.xwMax - this.xwMin) / (double)this.xSteps;
        this.ywDelta = (this.ywMax - this.ywMin) / (double)this.ySteps;
        this.xp = 0;
        this.yp = 0;
        this.xw = this.xwMin;
        this.yw = this.ywMin;
    }

    protected void setPixel(ColorF32 colorF32) {
        try {
            int rgb8 = ColorF32.toRGB8(colorF32);
            if (this.actDepth >= 1) {
                int ypp = 0;
                while (ypp < this.ypDelta) {
                    int xpp = 0;
                    while (xpp < this.xpDelta) {
                        this.bufAwtImg.setRGB(this.xp + xpp, this.yp + ypp, rgb8);
                        ++xpp;
                    }
                    ++ypp;
                }
            } else {
                this.bufAwtImg.setRGB(this.xp, this.yp, rgb8);
                ColorF32.copy(colorF32, this.bufColorF32Img[this.yp][this.xp]);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected void nextLocation() {
        if (this.actDepth == 0) {
            if (this.xp + 1 < this.canvasSize.width) {
                ++this.xp;
                this.xw += this.xwDelta;
            } else {
                this.xp = 0;
                this.xw = this.xwMin;
                if (this.yp + 1 < this.canvasSize.height) {
                    ++this.yp;
                    this.yw += this.ywDelta;
                } else {
                    this.more = false;
                }
            }
        } else if (this.xp + this.xpDelta + this.xpDelta < this.canvasSize.width) {
            this.xp += this.xpDelta;
            this.xw += this.xwDelta;
        } else {
            this.xp = this.xpDelta / 2;
            this.xw = this.xwMin + this.xwDelta / 2.0;
            if (this.yp + this.ypDelta + this.ypDelta < this.canvasSize.height) {
                this.yp += this.ypDelta;
                this.yw += this.ywDelta;
            } else {
                this.more = false;
            }
        }
    }

    @Override
    public boolean getReady() {
        return this.aborted || this.ready;
    }

    @Override
    public int getPercent() {
        if (this.canvasSize != null && this.actDepth == 0) {
            return 100 * this.yp / this.canvasSize.height;
        }
        return 0;
    }

    @Override
    protected String paramString() {
        return " xp=" + this.xp + " yp=" + this.yp + " xw=" + this.xw + " yw=" + this.yw + " xpDelta=" + this.xpDelta + " ypDelta=" + this.ypDelta + " xwDelta=" + this.xwDelta + " ywDelta=" + this.ywDelta + " actDepth=" + this.actDepth + " xSteps=" + this.xSteps + " ySteps=" + this.ySteps;
    }
}

