/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation;

import java.awt.Component;
import java.awt.Dimension;
import kandid.Fitness;
import kandid.calculation.Deviation;
import kandid.colorator.ColorF32;
import kandid.colorator.Colorator;
import kandid.soup.ChromosomeType;
import kandid.util.Debug;

public abstract class Calculation
implements Cloneable {
    public static final int cmdSetBest = 1;
    public static final int cmdResetBest = 2;
    public static final int cmdSetAbort = 3;
    public static final int cmdResetAbort = 4;
    public static final int cmdSetParent1 = 5;
    public static final int cmdResetParent1 = 6;
    public static final int cmdSetParent2 = 7;
    public static final int cmdResetParent2 = 8;
    public static final int cmdResetParent = 9;
    private static int instance_id = 0;
    public ChromosomeType chromosome;
    public Colorator colorator;
    protected Fitness fitness = new Fitness();
    public Dimension canvasSize;
    protected Component viewComponent;
    protected boolean aborted;
    protected String imageFormat = "png";

    public Calculation() {
        ++instance_id;
    }

    public void setChromosome(ChromosomeType chromosome, Colorator colorator) {
        this.chromosome = chromosome;
        this.colorator = colorator;
    }

    public Dimension getPreferredSize() {
        return null;
    }

    public void activateCanvas(Component viewComponent, Dimension canvasSize, boolean zoomMode) {
        this.viewComponent = viewComponent;
        this.canvasSize = canvasSize;
    }

    public abstract void calculate(Deviation var1, boolean var2, String var3);

    public abstract int getPercent();

    public abstract boolean getReady();

    public void command(int cmd) {
        this.fitness.command(cmd);
    }

    public Fitness getFitness() {
        return this.fitness;
    }

    public void setFitness(Fitness fitness) {
        this.fitness = fitness;
    }

    public boolean reject(ChromosomeType chromosome) {
        return false;
    }

    protected String paramString() {
        return " width=" + this.canvasSize.width + " height=" + this.canvasSize.height + " " + this.chromosome.getClass().getName() + " " + this.colorator.getClass().getName() + " =fitness" + String.valueOf(this.fitness);
    }

    public String toString() {
        return this.getClass().getName() + " instance_id " + instance_id + " [" + this.paramString() + "]";
    }

    public ColorF32[] getPalette() {
        return null;
    }

    public Object clone() {
        Calculation calc = null;
        try {
            calc = (Calculation)super.clone();
        }
        catch (CloneNotSupportedException exc) {
            Debug.stackTrace(exc);
        }
        return calc;
    }

    public abstract boolean hasWhiteBackground();

    public boolean getDeferred() {
        return false;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setImageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
    }

    public Component getViewComponent() {
        return this.viewComponent;
    }
}

