/*
 * Decompiled with CFR 0.152.
 */
package kandid;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import kandid.util.Debug;

public class PopulationPreview {
    public static final int populationPreviweWidth = 430;

    public static JList createPreviewList(JList list, ArrayList filelist) {
        ImageListModel ilm = new ImageListModel(filelist);
        list.setModel(ilm);
        list.setCellRenderer(new ImageCellRenderer());
        list.setSelectedIndex(0);
        list.setVisibleRowCount(4);
        ListSelectionModel lsm = list.getSelectionModel();
        lsm.setSelectionMode(0);
        return list;
    }

    static class ImageCellRenderer
    implements ListCellRenderer {
        private JLabel renderer = new JLabel();

        public ImageCellRenderer() {
            this.renderer.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                this.renderer.setText("");
                this.renderer.setIcon(null);
            } else {
                Hashtable hashtable = (Hashtable)value;
                this.renderer.setIcon((Icon)hashtable.get("icon"));
            }
            this.renderer.setBackground(isSelected ? Color.ORANGE : SystemColor.WHITE);
            this.renderer.setForeground(isSelected ? SystemColor.textHighlightText : SystemColor.textText);
            return this.renderer;
        }
    }

    static class ImageListModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = 1L;

        public ImageListModel(ArrayList filelist) {
            int i = 0;
            while (i < filelist.size()) {
                Hashtable<String, Object> result = new Hashtable<String, Object>();
                int fnPos = ((String)filelist.get(i)).lastIndexOf(47);
                if (fnPos >= 0) {
                    String label = ((String)filelist.get(i)).substring(fnPos + 1);
                    result.put("label", label);
                } else {
                    result.put("label", filelist.get(i));
                }
                result.put("filename", filelist.get(i));
                BufferedImage imageIcon = null;
                try {
                    File imageInFile = new File((String)filelist.get(i) + ".png");
                    if (imageInFile.exists()) {
                        imageIcon = ImageIO.read(imageInFile);
                    }
                }
                catch (IOException exc) {
                    Debug.stackTrace(exc);
                }
                PreviewIcon icon = new PreviewIcon((String)result.get("label"), imageIcon);
                result.put("icon", icon);
                this.addElement(result);
                ++i;
            }
        }
    }

    static class PreviewIcon
    implements Icon {
        private BufferedImage imageIcon;
        private String label;
        private static final AlphaComposite acFill = AlphaComposite.getInstance(3, 0.75f);
        private static final AlphaComposite acText = AlphaComposite.getInstance(2, 1.0f);

        public PreviewIcon(String label, BufferedImage imageIcon) {
            this.label = label;
            this.imageIcon = imageIcon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            if (this.imageIcon != null) {
                int yp;
                int xp = (this.getIconWidth() - this.imageIcon.getWidth()) / 2;
                if (xp < 1) {
                    xp = 1;
                }
                if ((yp = (this.getIconHeight() - this.imageIcon.getHeight()) / 2) < 1) {
                    yp = 1;
                }
                g2d.drawImage(this.imageIcon, xp, yp, Color.BLACK, null);
            }
            g2d.setComposite(acFill);
            g2d.setColor(Color.WHITE);
            g2d.fillRect(2, this.getIconHeight() - 17, this.getIconWidth() - 4, 14);
            g2d.setComposite(acText);
            g2d.setColor(SystemColor.infoText);
            g2d.drawString(this.label, 4, this.getIconHeight() - 6);
            g2d.setColor(Color.BLACK);
            g2d.drawLine(0, this.getIconHeight() - 1, this.getIconWidth(), this.getIconHeight() - 1);
        }

        @Override
        public int getIconWidth() {
            return 436;
        }

        @Override
        public int getIconHeight() {
            return 328;
        }
    }
}

