/*
 * Decompiled with CFR 0.152.
 */
package kandid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import kandid.Console;
import kandid.IconLoader;
import kandid.OrganismPanel;
import kandid.PopulationController;
import kandid.pond.ui.IlPool;
import kandid.preference.ui.IlPreference;
import kandid.util.Debug;
import kandid.util.IlCopyleft;

public class PopulationFrame
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    OrganismPanel[] organismPanel;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel populationPanel = new JPanel();
    JToolBar toolBar = new JToolBar();
    JButton randomButton = new JButton();
    JButton duplicateButton = new JButton();
    JButton undoButton = new JButton();
    JButton storeButton = new JButton();
    JButton cloneButton = new JButton();
    JButton environmentButton = new JButton();
    JButton sexualReproductionButton = new JButton();
    JToggleButton logToggleButton = new JToggleButton();
    JToggleButton poolToggleButton = new JToggleButton();
    JButton preferencesButton = new JButton();
    JButton copyleftButton = new JButton();
    JCheckBox inheritFormCheckBox = new JCheckBox();
    JCheckBox inheritColorCheckBox = new JCheckBox();
    PopulationController populationController = new PopulationController();

    public PopulationFrame() {
        try {
            this.jbInit();
            this.addWindowListener(this);
            this.setDefaultCloseOperation(0);
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.randomButton.setMargin(new Insets(0, 0, 0, 0));
        this.randomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopulationFrame.this.randomButton_actionPerformed(e);
            }
        });
        this.randomButton.setIcon(IconLoader.randomImageIcon);
        this.randomButton.setToolTipText("generate random next generation");
        this.duplicateButton.setMargin(new Insets(0, 0, 0, 0));
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopulationFrame.this.duplicateButton_actionPerformed(e);
            }
        });
        this.duplicateButton.setIcon(IconLoader.duplicateImageIcon);
        this.duplicateButton.setToolTipText("duplicate population");
        this.undoButton.setMargin(new Insets(0, 0, 0, 0));
        this.undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopulationFrame.this.undoButton_actionPerformed(e);
            }
        });
        this.undoButton.setIcon(IconLoader.undoImageIcon);
        this.undoButton.setToolTipText("undo last generation step");
        this.storeButton.setMargin(new Insets(0, 0, 0, 0));
        this.storeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopulationFrame.this.storeButton_actionPerformed(e);
            }
        });
        this.storeButton.setIcon(IconLoader.storeImageIcon);
        this.storeButton.setToolTipText("store population");
        this.cloneButton.setMargin(new Insets(0, 0, 0, 0));
        this.cloneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopulationFrame.this.cloneButton_actionPerformed(e);
            }
        });
        this.cloneButton.setIcon(IconLoader.cloneImageIcon);
        this.cloneButton.setToolTipText("generate next generation with clones");
        this.environmentButton.setMargin(new Insets(0, 0, 0, 0));
        this.environmentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopulationFrame.this.environmentButton_actionPerformed(e);
            }
        });
        this.environmentButton.setIcon(IconLoader.environmentImageIcon);
        this.environmentButton.setToolTipText("edit environment");
        this.sexualReproductionButton.setIcon(IconLoader.createImageIcon);
        this.sexualReproductionButton.setMargin(new Insets(0, 0, 0, 0));
        this.sexualReproductionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopulationFrame.this.sexualReproductionButton_actionPerformed(e);
            }
        });
        this.sexualReproductionButton.setToolTipText("generate next generation with sexual reproduction");
        this.logToggleButton.setIcon(IconLoader.logImageIcon);
        this.logToggleButton.setMargin(new Insets(0, 0, 0, 0));
        this.logToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopulationFrame.this.logToggleButton_actionPerformed(e);
            }
        });
        this.logToggleButton.setToolTipText("display logbook");
        this.poolToggleButton.setIcon(IconLoader.poolImageIcon);
        this.poolToggleButton.setMargin(new Insets(0, 0, 0, 0));
        this.poolToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopulationFrame.this.poolToggleButton_actionPerformed(e);
            }
        });
        this.poolToggleButton.setToolTipText("display gen pool");
        this.preferencesButton.setIcon(IconLoader.preferencesImageIcon);
        this.preferencesButton.setMargin(new Insets(0, 0, 0, 0));
        this.preferencesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopulationFrame.this.preferencesButton_actionPerformed(e);
            }
        });
        this.preferencesButton.setToolTipText("edit preferences");
        this.copyleftButton.setIcon(IconLoader.copyleftImageIcon);
        this.copyleftButton.setMargin(new Insets(0, 0, 0, 0));
        this.copyleftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopulationFrame.this.copyleftButton_actionPerformed(e);
            }
        });
        this.copyleftButton.setToolTipText("copyright");
        this.inheritFormCheckBox.setText("");
        this.inheritFormCheckBox.setToolTipText("inherit form");
        this.inheritFormCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopulationFrame.this.inheritFormCheckBox_actionPerformed(e);
            }
        });
        this.inheritFormCheckBox.setFont(new Font("Dialog", 0, 9));
        this.inheritColorCheckBox.setText("");
        this.inheritColorCheckBox.setToolTipText("inherit color");
        this.inheritColorCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopulationFrame.this.inheritColorCheckBox_actionPerformed(e);
            }
        });
        this.inheritColorCheckBox.setFont(new Font("Dialog", 0, 9));
        this.toolBar.setOrientation(1);
        this.getContentPane().add((Component)this.populationPanel, "Center");
        this.getContentPane().add((Component)this.toolBar, "West");
        this.toolBar.add((Component)this.sexualReproductionButton, null);
        this.toolBar.add((Component)this.cloneButton, null);
        this.toolBar.add((Component)this.randomButton, null);
        this.toolBar.add(new JToolBar.Separator());
        this.toolBar.add(this.inheritFormCheckBox);
        JLabel formLabel = new JLabel("form");
        formLabel.setFont(new Font("Dialog", 0, 10));
        this.toolBar.add(formLabel);
        this.toolBar.add(new JToolBar.Separator());
        this.toolBar.add(this.inheritColorCheckBox);
        JLabel colorLabel = new JLabel("color");
        colorLabel.setFont(new Font("Dialog", 0, 10));
        this.toolBar.add(colorLabel);
        this.toolBar.add(new JToolBar.Separator());
        this.toolBar.add((Component)this.undoButton, null);
        this.toolBar.add(new JToolBar.Separator());
        this.toolBar.add((Component)this.environmentButton, null);
        this.toolBar.add(new JToolBar.Separator());
        this.toolBar.add((Component)this.duplicateButton, null);
        this.toolBar.add((Component)this.storeButton, null);
        this.toolBar.add(new JToolBar.Separator());
        this.toolBar.add((Component)this.logToggleButton, null);
        this.toolBar.add(new JToolBar.Separator());
        this.toolBar.add((Component)this.poolToggleButton, null);
        this.toolBar.add((Component)this.preferencesButton, null);
        this.toolBar.add(new JToolBar.Separator());
        this.toolBar.add((Component)this.copyleftButton, null);
    }

    public void setInheritCalculation(boolean inheritCalculation, boolean simpleColorator) {
        if (simpleColorator) {
            this.inheritFormCheckBox.setSelected(true);
            this.inheritFormCheckBox.setEnabled(false);
        } else {
            this.inheritFormCheckBox.setSelected(inheritCalculation);
            this.inheritFormCheckBox.setEnabled(true);
        }
    }

    public void setInheritColorator(boolean inheritColorator, boolean simpleColorator) {
        if (simpleColorator) {
            this.inheritColorCheckBox.setSelected(true);
            this.inheritColorCheckBox.setEnabled(false);
        } else {
            this.inheritColorCheckBox.setSelected(inheritColorator);
            this.inheritColorCheckBox.setEnabled(true);
        }
    }

    public void prepare(String typeName, String calculationName, String coloratorName, int nRows, int nCols) {
        this.populationController.prepare(typeName, calculationName, coloratorName, nRows, nCols, this);
    }

    public void prepare(String typeName, String populationName) {
        this.populationController.prepare(typeName, populationName, this);
    }

    public void start(boolean createNew) {
        if (createNew) {
            this.populationController.randomReproduction(createNew);
        } else {
            this.populationController.start(createNew);
        }
    }

    public void stop() {
        this.populationController.stop();
    }

    private void inheritFormCheckBox_actionPerformed(ActionEvent e) {
        try {
            this.populationController.getPopulation().setInheritCalculation(this.inheritFormCheckBox.isSelected());
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
    }

    private void inheritColorCheckBox_actionPerformed(ActionEvent e) {
        try {
            this.populationController.getPopulation().setInheritColorator(this.inheritColorCheckBox.isSelected());
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
    }

    void sexualReproductionButton_actionPerformed(ActionEvent e) {
        try {
            this.populationController.sexualReproduction();
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
    }

    void cloneButton_actionPerformed(ActionEvent e) {
        try {
            this.populationController.cloneReproduction();
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
    }

    void environmentButton_actionPerformed(ActionEvent e) {
        try {
            this.populationController.editEnvironment();
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
    }

    void storeButton_actionPerformed(ActionEvent e) {
        try {
            this.populationController.store();
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
    }

    void undoButton_actionPerformed(ActionEvent e) {
        try {
            this.populationController.undo();
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
    }

    void randomButton_actionPerformed(ActionEvent e) {
        try {
            this.populationController.randomReproduction(false);
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
    }

    void duplicateButton_actionPerformed(ActionEvent e) {
        try {
            PopulationFrame populationFrame = new PopulationFrame();
            populationFrame.populationController.prepare(this.populationController, populationFrame);
            populationFrame.pack();
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            populationFrame.setLocation((d.width - populationFrame.getSize().width) / 2, (d.height - populationFrame.getSize().height) / 2);
            populationFrame.setVisible(true);
            populationFrame.start(false);
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
    }

    void logToggleButton_actionPerformed(ActionEvent e) {
        try {
            Console.setVisible(this.logToggleButton.isSelected());
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
    }

    void poolToggleButton_actionPerformed(ActionEvent e) {
        try {
            IlPool.getInstance().setVisible(this.poolToggleButton.isSelected());
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
    }

    void preferencesButton_actionPerformed(ActionEvent e) {
        IlPreference.showInstance(0, this);
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }

    void copyleftButton_actionPerformed(ActionEvent e) {
        IlCopyleft.showInstance();
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        Object[] options = new Object[]{"Store population", "Discard population", "Cancel"};
        int co = JOptionPane.showOptionDialog(this, "Population will be closed.", "Kandid", 1, 3, null, options, options[0]);
        switch (co) {
            case 0: {
                this.storeButton_actionPerformed(null);
                this.populationController.quit();
                this.dispose();
                break;
            }
            case 1: {
                this.populationController.quit();
                this.dispose();
                break;
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void windowActivated(WindowEvent evt) {
        this.populationController.windowActivated();
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }
}

