/*
 * Decompiled with CFR 0.152.
 */
package kandid;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Stack;
import javax.imageio.ImageIO;
import kandid.Console;
import kandid.Environment;
import kandid.EnvironmentEditor;
import kandid.Fitness;
import kandid.Gateway;
import kandid.OrganismPanel;
import kandid.PopulationFrame;
import kandid.ViewEngine;
import kandid.calculation.Calculation;
import kandid.colorator.Colorator;
import kandid.colorator.ColoratorFactory;
import kandid.extensions.ExportState;
import kandid.extensions.KandidFilenameFilter;
import kandid.extensions.LRUImageCache;
import kandid.pond.ui.IlPool;
import kandid.soup.ChromosomeType;
import kandid.soup.ColoratorType;
import kandid.soup.ImageType;
import kandid.soup.PopulationType;
import kandid.soup.util.ChromosomeStamp;
import kandid.soup.util.SoupFactory;
import kandid.util.CentralRandomizer;
import kandid.util.Debug;

public class PopulationController {
    private String populationFilename;
    private int waitReady = -1;
    private ChromosomeStamp calculationStamp;
    private ChromosomeStamp coloratorStamp;
    private OrganismPanel[] organismPanels;
    private int nRows;
    private int nCols;
    private int nMax;
    private PopulationFrame populationFrame;
    private GridLayout gridLayout = new GridLayout();
    private Environment environment = new Environment();
    private int sizeUndo;
    private Stack undoStack = new Stack();
    private String calculationName;
    private String coloratorName;
    private SoupFactory soupFactory = SoupFactory.getSoupFactory();
    private PopulationType population;
    private static final int maxRetries = 32;
    protected Color background;
    protected boolean scrollbar;

    public void prepare(String typeName, String calculationName, String coloratorName, int nRows, int nCols, PopulationFrame poolFrame) {
        try {
            this.calculationName = calculationName;
            this.coloratorName = coloratorName;
            this.populationFrame = poolFrame;
            this.nRows = nRows;
            this.nCols = nCols;
            this.nMax = nRows * nCols;
            this.calculationStamp = new ChromosomeStamp(typeName);
            this.coloratorStamp = new ChromosomeStamp(ColoratorFactory.getShortName(coloratorName));
            this.population = this.soupFactory.createPopulation(typeName);
            int nx = 0;
            while (nx < this.nMax) {
                this.soupFactory.createImage(this.population, nx, typeName, calculationName, coloratorName);
                this.soupFactory.createRandomChromosome(this.population, nx, this.calculationStamp);
                this.soupFactory.createRandomColorator(this.population, nx, coloratorName, this.coloratorStamp);
                ++nx;
            }
            this.initGUI(calculationName);
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
    }

    public void prepare(String typeName, String populationFilename, PopulationFrame populationFrame) {
        this.populationFrame = populationFrame;
        this.populationFilename = populationFilename;
        this.population = (PopulationType)this.soupFactory.unmarshalFromFile(populationFilename);
        this.calculationStamp = new ChromosomeStamp(typeName);
        this.calculationStamp.setPopulationIDfromName(populationFilename);
        this.coloratorStamp = new ChromosomeStamp(ColoratorFactory.getShortName(this.soupFactory.getColoratorName(this.population, 0)));
        this.coloratorStamp.setPopulationIDfromName(populationFilename);
        this.nMax = this.soupFactory.getSize(this.population);
        switch (this.nMax) {
            case 12: {
                this.nCols = 4;
                this.nRows = 3;
                break;
            }
            case 24: {
                this.nCols = 6;
                this.nRows = 4;
                break;
            }
            case 40: {
                this.nCols = 8;
                this.nRows = 5;
                break;
            }
            default: {
                this.nCols = 10;
                this.nRows = 7;
                this.nMax = 70;
            }
        }
        int nx = 0;
        while (nx < this.nMax) {
            this.calculationName = this.soupFactory.getCalculationName(this.population, nx);
            this.coloratorName = this.soupFactory.getColoratorName(this.population, nx);
            ColoratorType coloratorType = this.soupFactory.getColorator(this.population, nx);
            Colorator coloratorWorker = null;
            coloratorWorker = this.coloratorName != null ? ColoratorFactory.createColoratorWorker(this.coloratorName, coloratorType) : ColoratorFactory.createColoratorWorker(coloratorType.getColoratorName(), coloratorType);
            ++nx;
        }
        this.initGUI(this.calculationName);
        this.waitReady = this.nMax;
    }

    public void prepare(PopulationController oldPopulationController, PopulationFrame oldPopulationFrame) {
        this.calculationName = oldPopulationController.calculationName;
        this.coloratorName = oldPopulationController.coloratorName;
        this.populationFrame = oldPopulationFrame;
        this.nRows = oldPopulationController.nRows;
        this.nCols = oldPopulationController.nCols;
        PopulationType oldPopulation = oldPopulationController.population;
        this.initModel(SoupFactory.getTypeName(oldPopulation), this.calculationName, this.coloratorName);
        this.population.setInheritCalculation(oldPopulation.isInheritCalculation());
        this.population.setInheritColorator(oldPopulation.isInheritColorator());
        this.initGUI(this.calculationName);
        int nx = 0;
        while (nx < this.nMax) {
            Calculation calculation = oldPopulationController.organismPanels[nx].getCalculation();
            ChromosomeType oldCalculationChromosome = this.soupFactory.getChromosome(oldPopulation, nx);
            ChromosomeType newCalculationChromosome = this.soupFactory.clone(oldCalculationChromosome, false, this.calculationStamp.getPopulationIdent());
            this.soupFactory.setChromosome(this.population, nx, newCalculationChromosome);
            ColoratorType oldColorator = this.soupFactory.getColorator(oldPopulation, nx);
            ColoratorType newColorator = this.soupFactory.clone(oldColorator, false, this.coloratorStamp.getPopulationIdent());
            this.soupFactory.setColorator(this.population, nx, newColorator);
            this.soupFactory.setRating(this.population, nx, (Fitness)calculation.getFitness().clone());
            LRUImageCache.getLRUImageCache().duplicate(oldCalculationChromosome.getIdent(), newCalculationChromosome.getIdent());
            this.cloneAuthorship(oldPopulation, nx, nx);
            ++nx;
        }
    }

    private void cloneAuthorship(PopulationType oldPopulation, int sourceIndex, int destinationIndex) {
        ImageType oldImage = this.soupFactory.getImage(oldPopulation, sourceIndex);
        ImageType newImage = this.soupFactory.getImage(this.population, destinationIndex);
        newImage.setAuthor(oldImage.getAuthor());
        newImage.setPublishDate(oldImage.getPublishDate());
        newImage.setAnnotation(oldImage.getAnnotation());
    }

    private void initModel(String typeName, String calculationName, String coloratorName) {
        this.nMax = this.nRows * this.nCols;
        this.calculationStamp = new ChromosomeStamp(typeName);
        this.coloratorStamp = new ChromosomeStamp(ColoratorFactory.getShortName(coloratorName));
        this.population = this.soupFactory.createPopulation(typeName);
        int nx = 0;
        while (nx < this.nMax) {
            this.soupFactory.createImage(this.population, nx, typeName, calculationName, coloratorName);
            ++nx;
        }
    }

    private void initGUI(String calculationName) {
        this.hintGUI(calculationName);
        this.gridLayout.setColumns(this.nCols);
        this.gridLayout.setRows(this.nRows);
        this.populationFrame.populationPanel.setLayout(this.gridLayout);
        this.organismPanels = new OrganismPanel[this.nMax];
        int nx = 0;
        while (nx < this.nMax) {
            OrganismPanel organismPanel = new OrganismPanel(false, this.nRows, this.nCols, this.scrollbar, this, nx);
            organismPanel.adjustPanelSize();
            this.organismPanels[nx] = organismPanel;
            this.populationFrame.populationPanel.add((Component)organismPanel, null);
            ++nx;
        }
        this.populationFrame.setTitle("PopulationType: " + this.getTitle());
        boolean simpleColorator = ColoratorFactory.isSimpleColorator(this.soupFactory.getColoratorName(this.population, 0));
        this.populationFrame.setInheritCalculation(this.population.isInheritCalculation(), simpleColorator);
        this.populationFrame.setInheritColorator(this.population.isInheritColorator(), simpleColorator);
    }

    private void hintGUI(String calculationName) {
        this.background = calculationName.indexOf("kandid.calculation.bridge.") == 0 ? Color.BLACK : null;
        this.scrollbar = calculationName.indexOf("kandid.calculation.lca.") == 0;
    }

    private void start(boolean createNew, int index) {
        Fitness fitness = null;
        if (createNew) {
            fitness = new Fitness();
            fitness.abort = true;
        } else {
            fitness = this.soupFactory.mapRating(this.population, index);
        }
        this.organismPanels[index].start(this.population, index, fitness);
    }

    public void start(boolean createNew) {
        int nx = 0;
        while (nx < this.nMax) {
            this.start(createNew, nx);
            ++nx;
        }
        this.toggleButtons();
    }

    private void stop(int index) {
        this.organismPanels[index].stop();
    }

    public void stop() {
        int nx = 0;
        while (nx < this.nMax) {
            this.stop(nx);
            ++nx;
        }
    }

    public void quit() {
        int nx = 0;
        while (nx < this.nMax) {
            this.stop(nx);
            ++nx;
        }
    }

    public void apply(int index) {
        this.stop(index);
        this.start(false, index);
    }

    public void store() {
        int nx = 0;
        while (nx < this.nMax) {
            Fitness fitness = this.organismPanels[nx].getCalculation().getFitness();
            this.soupFactory.setRating(this.population, nx, fitness);
            ++nx;
        }
        this.populationFilename = this.getTitle() + "_";
        ExportState exportState = new ExportState();
        exportState.setFullname(this.populationFilename);
        new File(exportState.getPath("filebase")).mkdirs();
        this.populationFilename = exportState.getPath("filebase") + this.populationFilename + this.getUniqStoreID(exportState.getPath("filebase")) + ".kpop";
        this.soupFactory.marshalToFile(this.population, this.populationFilename);
        this.storePreview(this.populationFilename, "png");
        int nx2 = 0;
        while (nx2 < this.nMax) {
            ChromosomeType calculationChromosome = this.soupFactory.getChromosome(this.population, nx2);
            LRUImageCache.getLRUImageCache().touch(calculationChromosome.getIdent(), this.organismPanels[nx2].getViewEngine().getDim());
            ++nx2;
        }
    }

    private void storePreview(String filename, String imagetype) {
        try {
            int populationPreviewDimension = 430 / this.nCols;
            BufferedImage populationPreviewImg = new BufferedImage(this.nCols * populationPreviewDimension, this.nRows * populationPreviewDimension, 1);
            int nx = 0;
            int rx = 0;
            while (rx < this.nRows) {
                int cx = 0;
                while (cx < this.nCols) {
                    ViewEngine viewEngine = this.organismPanels[nx].getViewEngine();
                    Dimension calculatedDim = viewEngine.getGateway().getCalculation().getPreferredSize();
                    if (calculatedDim == null) {
                        calculatedDim = viewEngine.getDim();
                    }
                    Image calculatedImage = viewEngine.getGateway().getImage();
                    Graphics2D g2d = populationPreviewImg.createGraphics();
                    AffineTransform scale = new AffineTransform();
                    scale.setToIdentity();
                    scale.translate(cx * populationPreviewDimension, rx * populationPreviewDimension);
                    scale.scale((double)populationPreviewDimension / calculatedDim.getWidth(), (double)populationPreviewDimension / calculatedDim.getHeight());
                    g2d.drawImage(calculatedImage, scale, null);
                    ++nx;
                    ++cx;
                }
                ++rx;
            }
            File imageOutFile = new File(filename + "." + imagetype);
            ImageIO.write((RenderedImage)populationPreviewImg, imagetype, imageOutFile);
        }
        catch (IOException exc) {
            Debug.stackTrace(exc);
        }
    }

    private String getUniqStoreID(String path) {
        File currDir = new File(path);
        Object[] fileList = currDir.list(new KandidFilenameFilter(SoupFactory.getTypeName(this.population), ".kpop"));
        if (fileList != null && fileList.length > 0) {
            Arrays.sort(fileList);
            Object lastEntry = fileList[fileList.length - 1];
            int begin = ((String)lastEntry).lastIndexOf(95);
            int end = ((String)lastEntry).lastIndexOf(46);
            String sCount = ((String)lastEntry).substring(begin + 1, end);
            int count = Integer.parseInt(sCount);
            return "" + (count + 1);
        }
        return "1";
    }

    private void command(int cmd, int to) {
        this.organismPanels[to].command(cmd);
    }

    private void commandAll(int cmd, int from) {
        int nx = 0;
        while (nx < this.nMax) {
            if (nx != from) {
                this.organismPanels[nx].command(cmd);
            }
            ++nx;
        }
    }

    private int findPartner(int me) {
        int partner = -1;
        int[] partnerList = new int[this.nMax];
        int pi = 0;
        Fitness myf = this.organismPanels[me].getCalculation().getFitness();
        if (myf.best) {
            int nx = 0;
            while (nx < this.nMax) {
                if (nx != me) {
                    Fitness pf = this.organismPanels[nx].getCalculation().getFitness();
                    if (!pf.abort) {
                        partnerList[pi] = nx;
                        ++pi;
                    }
                }
                ++nx;
            }
        } else if (myf.parent1) {
            int nx = 0;
            while (nx < this.nMax) {
                if (nx != me) {
                    Fitness pf = this.organismPanels[nx].getCalculation().getFitness();
                    if (pf.parent2) {
                        partnerList[0] = nx;
                        pi = 1;
                        break;
                    }
                }
                ++nx;
            }
        }
        switch (pi) {
            case 0: {
                break;
            }
            case 1: {
                partner = partnerList[0];
                break;
            }
            default: {
                partner = partnerList[CentralRandomizer.getInt(pi - 1)];
            }
        }
        return partner;
    }

    public void sexualReproduction() {
        int first = -1;
        int second = -1;
        int nx = 0;
        while (nx < this.nMax) {
            Fitness ff = this.organismPanels[nx].getCalculation().getFitness();
            if (ff.best || ff.parent1) {
                first = nx;
                break;
            }
            ++nx;
        }
        if (first >= 0) {
            Fitness pf;
            this.undoPush();
            nx = 0;
            while (nx < this.nMax) {
                pf = this.organismPanels[nx].getCalculation().getFitness();
                if (pf.abort) {
                    try {
                        this.organismPanels[nx].getCalculation().setAborted(true);
                    }
                    catch (Throwable exc) {
                        Debug.stackTrace(exc);
                    }
                }
                ++nx;
            }
            nx = 0;
            while (nx < this.nMax) {
                second = this.findPartner(first);
                if (first >= 0 && first != second) {
                    pf = this.organismPanels[nx].getCalculation().getFitness();
                    if (pf.abort) {
                        try {
                            ChromosomeType calculationChromosome1 = this.soupFactory.getChromosome(this.population, first);
                            ChromosomeType calculationChromosome2 = this.soupFactory.getChromosome(this.population, second);
                            int retryCount = 0;
                            while (retryCount < 32) {
                                boolean successful;
                                ++retryCount;
                                int mutationCounter = 0;
                                ChromosomeType calculationChromosome = null;
                                if (this.population.isInheritCalculation()) {
                                    calculationChromosome = this.soupFactory.merge(calculationChromosome1, calculationChromosome2, this.environment);
                                    mutationCounter += this.soupFactory.mutate(calculationChromosome, this.environment);
                                } else {
                                    calculationChromosome = this.soupFactory.getChromosome(this.population, nx);
                                }
                                calculationChromosome.setIdent(ChromosomeStamp.forceNextChromosomeId(calculationChromosome.getIdent()));
                                this.soupFactory.setChromosome(this.population, nx, calculationChromosome);
                                ColoratorType colorator1 = this.soupFactory.getColorator(this.population, first);
                                if (colorator1 != null) {
                                    ChromosomeType coloratorChromosome = null;
                                    if (this.population.isInheritColorator()) {
                                        ChromosomeType coloratorChromosome1 = this.soupFactory.getColorTable(colorator1);
                                        ColoratorType colorator2 = this.soupFactory.getColorator(this.population, second);
                                        ChromosomeType coloratorChromosome2 = this.soupFactory.getColorTable(colorator2);
                                        coloratorChromosome = this.soupFactory.merge(coloratorChromosome1, coloratorChromosome2, this.environment);
                                        mutationCounter += this.soupFactory.mutate(coloratorChromosome, this.environment);
                                    } else {
                                        coloratorChromosome = this.soupFactory.getColorTable(this.soupFactory.getColorator(this.population, nx));
                                    }
                                    ColoratorType newColorator = this.soupFactory.clone(colorator1, true, null);
                                    this.soupFactory.setColorTable(newColorator, coloratorChromosome);
                                    this.soupFactory.setColorator(this.population, nx, newColorator);
                                }
                                boolean bl = successful = !this.organismPanels[nx].getCalculation().reject(calculationChromosome);
                                if (!successful && retryCount < 32) continue;
                                this.start(true, nx);
                                this.organismPanels[nx].toggleButtons();
                                Console.append("sexual reproduction " + calculationChromosome.getIdent() + " : " + mutationCounter + " mutations and " + this.environment.getSwitchCounter() + " crossing over, parents " + calculationChromosome1.getIdent() + " and " + calculationChromosome2.getIdent() + ", " + retryCount + " reties, " + (successful ? "successful" : "failed"));
                                break;
                            }
                        }
                        catch (Throwable exc) {
                            Debug.stackTrace(exc);
                        }
                    }
                }
                ++nx;
            }
        }
        this.toggleButtons();
        this.waitReady = -1;
    }

    public void cloneReproduction() {
        int first = this.findBest();
        if (first >= 0) {
            Fitness pf;
            this.undoPush();
            ChromosomeType calculationChromosome1 = this.soupFactory.getChromosome(this.population, first);
            int nx = 0;
            while (nx < this.nMax) {
                pf = this.organismPanels[nx].getCalculation().getFitness();
                if (pf.abort) {
                    try {
                        this.organismPanels[nx].getCalculation().setAborted(true);
                    }
                    catch (Throwable exc) {
                        Debug.stackTrace(exc);
                    }
                }
                ++nx;
            }
            nx = 0;
            while (nx < this.nMax) {
                pf = this.organismPanels[nx].getCalculation().getFitness();
                if (pf.abort) {
                    try {
                        ChromosomeType calculationChromosome = null;
                        calculationChromosome = this.population.isInheritCalculation() ? this.soupFactory.clone(calculationChromosome1, true, null) : this.soupFactory.getChromosome(this.population, nx);
                        calculationChromosome.setIdent(ChromosomeStamp.forceNextChromosomeId(calculationChromosome.getIdent()));
                        this.soupFactory.setChromosome(this.population, nx, calculationChromosome);
                        ColoratorType colorator1 = this.soupFactory.getColorator(this.population, first);
                        if (colorator1 != null) {
                            ChromosomeType coloratorChromosome = null;
                            coloratorChromosome = this.population.isInheritColorator() ? this.soupFactory.clone(this.soupFactory.getColorTable(colorator1), true, null) : this.soupFactory.getColorTable(this.soupFactory.getColorator(this.population, nx));
                            ColoratorType newColorator = this.soupFactory.clone(colorator1, true, null);
                            this.soupFactory.setColorTable(newColorator, coloratorChromosome);
                            this.soupFactory.setColorTable(newColorator, coloratorChromosome);
                            this.soupFactory.setColorator(this.population, nx, newColorator);
                        }
                        this.cloneAuthorship(this.population, nx, nx);
                        this.start(true, nx);
                        this.command(3, nx);
                        this.organismPanels[nx].toggleButtons();
                        Console.append("clone " + calculationChromosome.getIdent() + " : parent " + calculationChromosome1.getIdent());
                    }
                    catch (Throwable exc) {
                        Debug.stackTrace(exc);
                    }
                }
                ++nx;
            }
            this.toggleButtons();
        }
        this.waitReady = -1;
    }

    public void randomReproduction(boolean createNew) {
        if (!createNew) {
            this.undoPush();
        }
        int nx = 0;
        while (nx < this.nMax) {
            if (this.isPanelFree(createNew, nx)) {
                try {
                    Calculation calc = this.organismPanels[nx].getCalculation();
                    if (calc != null) {
                        calc.setAborted(true);
                    }
                }
                catch (Throwable exc) {
                    Debug.stackTrace(exc);
                }
            }
            ++nx;
        }
        nx = 0;
        while (nx < this.nMax) {
            if (this.isPanelFree(createNew, nx)) {
                int retryCount = 0;
                while (retryCount < 32) {
                    boolean fail;
                    ++retryCount;
                    ChromosomeType calculationChromosome = null;
                    calculationChromosome = this.population.isInheritCalculation() ? this.soupFactory.createRandomChromosome(this.population, nx, this.calculationStamp) : this.soupFactory.getChromosome(this.population, nx);
                    calculationChromosome.setIdent(ChromosomeStamp.forceNextChromosomeId(calculationChromosome.getIdent()));
                    this.soupFactory.setChromosome(this.population, nx, calculationChromosome);
                    ColoratorType colorator1 = this.soupFactory.getColorator(this.population, nx);
                    if (colorator1 != null) {
                        ColoratorType colorator = null;
                        colorator = this.population.isInheritColorator() ? this.soupFactory.createRandomColorator(this.population, nx, colorator1.getColoratorName(), this.coloratorStamp) : this.soupFactory.getColorator(this.population, nx);
                        this.soupFactory.setColorator(this.population, nx, colorator);
                    }
                    if ((fail = new Gateway().createCalculation(this.calculationName).reject(calculationChromosome)) && retryCount < 32) continue;
                    this.start(true, nx);
                    this.organismPanels[nx].toggleButtons();
                    Console.append("new random " + calculationChromosome.getIdent() + ", " + retryCount + " reties, " + (fail ? "failed" : "successful"));
                    break;
                }
            }
            ++nx;
        }
        this.toggleButtons();
        this.waitReady = -1;
    }

    private boolean isPanelFree(boolean createNew, int nx) {
        boolean isPanelFree = false;
        if (createNew) {
            isPanelFree = true;
        } else {
            Fitness pf = this.organismPanels[nx].getCalculation().getFitness();
            isPanelFree = pf.abort;
        }
        return isPanelFree;
    }

    public int findBest() {
        int first = -1;
        int nx = 0;
        while (nx < this.nMax) {
            Fitness ff = this.organismPanels[nx].getCalculation().getFitness();
            if (ff.best) {
                first = nx;
                break;
            }
            ++nx;
        }
        return first;
    }

    public int getFreeLocations() {
        int abortCount = 0;
        int nx = 0;
        while (nx < this.nMax) {
            Fitness pf = this.organismPanels[nx].getCalculation().getFitness();
            if (pf.abort) {
                ++abortCount;
            }
            ++nx;
        }
        return abortCount;
    }

    public int getUnmarkedLocations() {
        int nomarkCount = 0;
        int nx = 0;
        while (nx < this.nMax) {
            Fitness pf = this.organismPanels[nx].getCalculation().getFitness();
            if (!(pf.abort || pf.best || pf.parent1 || pf.parent1)) {
                ++nomarkCount;
            }
            ++nx;
        }
        return nomarkCount;
    }

    public boolean hasParents() {
        int bestCount = 0;
        int parent1Count = 0;
        int parent2Count = 0;
        int nx = 0;
        while (nx < this.nMax) {
            Fitness pf = this.organismPanels[nx].getCalculation().getFitness();
            if (pf.best) {
                ++bestCount;
            }
            if (pf.parent1) {
                ++parent1Count;
            }
            if (pf.parent2) {
                ++parent2Count;
            }
            ++nx;
        }
        return bestCount >= true || parent1Count >= 1 && parent2Count >= true;
    }

    public boolean hasBest() {
        int bestCount = 0;
        int nx = 0;
        while (nx < this.nMax) {
            Fitness pf = this.organismPanels[nx].getCalculation().getFitness();
            if (pf.best) {
                ++bestCount;
            }
            ++nx;
        }
        return bestCount >= 1;
    }

    public boolean canCreate() {
        return this.getFreeLocations() > 0 && this.hasParents() && this.getUnmarkedLocations() > 0;
    }

    public boolean canClone() {
        return this.getFreeLocations() > 0 && this.hasBest();
    }

    private void toggleButtons() {
        this.populationFrame.sexualReproductionButton.setEnabled(this.canCreate());
        this.populationFrame.cloneButton.setEnabled(this.canClone());
        this.populationFrame.randomButton.setEnabled(this.getFreeLocations() > 0);
        this.populationFrame.undoButton.setEnabled(this.undoStack.size() >= 2);
        int nx = 0;
        while (nx < this.nMax) {
            this.organismPanels[nx].toggleButtons();
            ++nx;
        }
    }

    public void dispatchBest(int caller, boolean isSelected) {
        if (isSelected) {
            this.commandAll(9, caller);
            this.command(1, caller);
        } else {
            this.command(2, caller);
        }
        this.toggleButtons();
    }

    public void dispatchParent1(int caller, boolean isSelected) {
        if (isSelected) {
            this.commandAll(2, caller);
            this.commandAll(6, caller);
            this.command(5, caller);
        } else {
            this.command(6, caller);
        }
        this.toggleButtons();
    }

    public void dispatchParent2(int caller, boolean isSelected) {
        if (isSelected) {
            this.commandAll(2, caller);
            this.commandAll(8, caller);
            this.command(7, caller);
        } else {
            this.command(8, caller);
        }
        this.toggleButtons();
    }

    public void dispatchAbort(int caller, boolean isSelected) {
        if (isSelected) {
            this.command(3, caller);
        } else {
            this.command(4, caller);
        }
        this.toggleButtons();
    }

    public void undo() {
        if (this.undoStack.size() >= 2) {
            this.undoPop();
        }
        this.toggleButtons();
    }

    private void undoPush() {
        int nx;
        if (this.sizeUndo >= 10) {
            nx = 0;
            while (nx < this.nMax) {
                this.undoStack.removeElementAt(0);
                this.undoStack.removeElementAt(0);
                ++nx;
            }
            --this.sizeUndo;
        }
        nx = 0;
        while (nx < this.nMax) {
            ChromosomeType chromosome = this.soupFactory.getChromosome(this.population, nx);
            this.undoStack.push(this.soupFactory.clone(chromosome, false, null));
            ColoratorType colorator = this.soupFactory.getColorator(this.population, nx);
            this.undoStack.push(this.soupFactory.clone(colorator, false, null));
            Object fitness = this.organismPanels[nx].getCalculation().getFitness().clone();
            this.undoStack.push(fitness);
            ++nx;
        }
        ++this.sizeUndo;
    }

    private void undoPop() {
        int nx = this.nMax;
        while (nx > 0) {
            Fitness fitness = (Fitness)this.undoStack.pop();
            this.organismPanels[--nx].getCalculation().setFitness(fitness);
            this.soupFactory.setRating(this.population, nx, fitness);
            ColoratorType colorator = (ColoratorType)this.undoStack.pop();
            this.soupFactory.setColorator(this.population, nx, colorator);
            ChromosomeType chromosome = (ChromosomeType)this.undoStack.pop();
            this.soupFactory.setChromosome(this.population, nx, chromosome);
            this.organismPanels[nx].start(this.population, nx, fitness);
        }
        --this.sizeUndo;
    }

    public void editEnvironment() {
        EnvironmentEditor dlg = new EnvironmentEditor((Frame)this.populationFrame, true);
        dlg.setEnvironment(this.environment);
        dlg.setLocationRelativeTo(this.populationFrame);
        dlg.setVisible(true);
        this.environment = dlg.getEnvironment();
        Console.append("mutation rate " + this.environment.getMutationRate() + ", crossing over rate " + this.environment.getMergeRate());
    }

    public PopulationType getPopulation() {
        return this.population;
    }

    public String getTitle(int index) {
        String shortColoratorName = ColoratorFactory.getShortName(this.soupFactory.getColoratorName(this.population, index));
        String ident = this.soupFactory.getChromosome(this.population, index).getIdent();
        int pos = ident.lastIndexOf(95);
        if (pos >= 0) {
            ident = ident.substring(pos);
        }
        return this.calculationStamp.getTypePopulationIdent(shortColoratorName) + ident;
    }

    public String getTitle() {
        String shortColoratorName = ColoratorFactory.getShortName(this.soupFactory.getColoratorName(this.population, 0));
        return this.calculationStamp.getTypePopulationIdent(shortColoratorName);
    }

    public void notifyReady(int nx) {
        if (this.waitReady >= 0) {
            --this.waitReady;
            if (this.waitReady == 0) {
                this.storePreview(this.populationFilename, "png");
            }
        }
    }

    public void windowActivated() {
        IlPool.getInstance().navigateToType(this.calculationName, this.coloratorName);
    }
}

