/*
 * Decompiled with CFR 0.152.
 */
package kandid;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.TransferHandler;
import kandid.ChromosomeEditor;
import kandid.DataSink;
import kandid.Fitness;
import kandid.Gateway;
import kandid.IconLoader;
import kandid.ImageTransferHandler;
import kandid.PopulationController;
import kandid.ViewEngine;
import kandid.ZoomFrame;
import kandid.calculation.Calculation;
import kandid.colorator.Colorator;
import kandid.colorator.ColoratorFactory;
import kandid.extensions.ExportWizard;
import kandid.extensions.LRUImageCache;
import kandid.soup.ChromosomeType;
import kandid.soup.ColoratorType;
import kandid.soup.PopulationType;
import kandid.soup.util.SoupFactory;
import kandid.util.Debug;

public class OrganismPanel
extends JPanel
implements DataSink {
    private static final long serialVersionUID = 1L;
    private ViewEngine viewEngine;
    private SoupFactory soupFactory;
    private PopulationController populationController;
    private int populationID;
    private Thread percentAnimation;
    private ChromosomeEditor chromosomeEditor;
    BorderLayout borderLayout1 = new BorderLayout();
    JComponent imageComponent;
    JPanel organismPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel headlinePanel = new JPanel();
    JLabel percentageLabel = new JLabel();
    JButton stopButton = new JButton();
    JToggleButton bestButton = new JToggleButton();
    JToggleButton abortButton = new JToggleButton();
    JToggleButton parent1Button = new JToggleButton();
    JToggleButton parent2Button = new JToggleButton();
    JButton zoomButton = new JButton();
    JButton exportButton = new JButton();
    JButton editButton = new JButton();
    JPanel cntrlPanel = new JPanel();
    FlowLayout cntrlFlowLayout = new FlowLayout();
    FlowLayout headlineFlowLayout = new FlowLayout();
    Font smallFont = new Font("Dialog", 0, 8);

    public OrganismPanel(boolean zoomMode, int nRows, int nCols, boolean enableScrollbar, PopulationController populationController, int populationID) {
        super(true);
        this.populationController = populationController;
        this.populationID = populationID;
        this.viewEngine = new ViewEngine(zoomMode ? 1024 : 0, nRows, nCols, this, null);
        this.soupFactory = SoupFactory.getSoupFactory();
        try {
            if (zoomMode && enableScrollbar) {
                this.imageComponent = new JPanel();
                this.imageComponent.setLayout(new BorderLayout());
                JScrollPane jScrollPane = new JScrollPane(this.viewEngine);
                this.imageComponent.add((Component)jScrollPane, "Center");
            } else if (zoomMode) {
                this.imageComponent = this.viewEngine;
            } else {
                this.imageComponent = this.viewEngine;
                DragMouseAdapter listener = new DragMouseAdapter();
                this.viewEngine.addMouseListener(listener);
                this.viewEngine.setTransferHandler(new ImageTransferHandler(false));
            }
            this.imageComponent.setDoubleBuffered(true);
            this.jbInit();
            if (zoomMode || populationController == null) {
                this.bestButton.setEnabled(false);
                this.abortButton.setEnabled(false);
                this.parent1Button.setEnabled(false);
                this.parent2Button.setEnabled(false);
                this.zoomButton.setEnabled(false);
                this.editButton.setEnabled(false);
            }
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
    }

    public void adjustPanelSize() {
        Dimension ivDim = this.viewEngine.getPreferredSize();
        Dimension dim = new Dimension(ivDim.width < 125 ? 125 : ivDim.width, ivDim.height + 17);
        this.setPreferredSize(dim);
        this.setMaximumSize(dim);
        this.setMinimumSize(dim);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.organismPanel.setLayout(this.borderLayout2);
        this.percentageLabel.setText("");
        this.stopButton.setMargin(new Insets(0, 0, 0, 0));
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrganismPanel.this.stopButton_actionPerformed(e);
            }
        });
        this.stopButton.setActionCommand("stopButton");
        this.stopButton.setIcon(IconLoader.stopImageIcon);
        this.stopButton.setToolTipText("stop calculation");
        this.stopButton.setFont(this.smallFont);
        this.bestButton.setMargin(new Insets(0, 0, 0, 0));
        this.bestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrganismPanel.this.bestButton_actionPerformed(e);
            }
        });
        this.bestButton.setActionCommand("bestButton");
        this.bestButton.setIcon(IconLoader.bestImageIcon);
        this.bestButton.setToolTipText("mark this as best picture");
        this.bestButton.setSelectedIcon(IconLoader.bestSelectedImageIcon);
        this.abortButton.setMargin(new Insets(0, 0, 0, 0));
        this.abortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrganismPanel.this.abortButton_actionPerformed(e);
            }
        });
        this.abortButton.setActionCommand("abortButton");
        this.abortButton.setIcon(IconLoader.abortImageIcon);
        this.abortButton.setToolTipText("mark this picture for deletion");
        this.abortButton.setSelectedIcon(IconLoader.abortSelectedImageIcon);
        this.parent1Button.setMargin(new Insets(0, 0, 0, 0));
        this.parent1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrganismPanel.this.parent1Button_actionPerformed(e);
            }
        });
        this.parent1Button.setActionCommand("parent1Button");
        this.parent1Button.setIcon(IconLoader.parent1ImageIcon);
        this.parent1Button.setSelectedIcon(IconLoader.parent1SelectedImageIcon);
        this.parent1Button.setToolTipText("mark this picture as first parent");
        this.parent2Button.setMargin(new Insets(0, 0, 0, 0));
        this.parent2Button.setIcon(IconLoader.parent2ImageIcon);
        this.parent2Button.setSelectedIcon(IconLoader.parent2SelectedImageIcon);
        this.parent2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrganismPanel.this.parent2Button_actionPerformed(e);
            }
        });
        this.parent2Button.setToolTipText("mark this picture to be the other parent");
        this.zoomButton.setMargin(new Insets(0, 0, 0, 0));
        this.zoomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrganismPanel.this.zoomButton_actionPerformed(e);
            }
        });
        this.zoomButton.setActionCommand("zoomButton");
        this.zoomButton.setIcon(IconLoader.zoomImageIcon);
        this.zoomButton.setToolTipText("zoom picture");
        this.exportButton.setMargin(new Insets(0, 0, 0, 0));
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrganismPanel.this.exportButton_actionPerformed(e);
            }
        });
        this.exportButton.setActionCommand("exportButton");
        this.exportButton.setIcon(IconLoader.exportImageIcon);
        this.exportButton.setToolTipText("export picture");
        this.editButton.setMargin(new Insets(0, 0, 0, 0));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrganismPanel.this.editButton_actionPerformed(e);
            }
        });
        this.editButton.setActionCommand("editButton");
        this.editButton.setIcon(IconLoader.editImageIcon);
        this.editButton.setToolTipText("edit chromosome");
        this.cntrlPanel.setLayout(this.cntrlFlowLayout);
        this.cntrlFlowLayout.setAlignment(2);
        this.cntrlFlowLayout.setHgap(1);
        this.cntrlFlowLayout.setVgap(1);
        this.headlinePanel.setLayout(this.headlineFlowLayout);
        this.headlineFlowLayout.setAlignment(0);
        this.headlineFlowLayout.setHgap(1);
        this.headlineFlowLayout.setVgap(1);
        this.add((Component)this.imageComponent, "Center");
        this.add((Component)this.organismPanel, "North");
        this.organismPanel.add((Component)this.headlinePanel, "West");
        this.headlinePanel.add((Component)this.stopButton, null);
        this.headlinePanel.add((Component)this.percentageLabel, null);
        this.organismPanel.add((Component)this.cntrlPanel, "East");
        this.cntrlPanel.add((Component)this.zoomButton, null);
        this.cntrlPanel.add((Component)this.editButton, null);
        this.cntrlPanel.add((Component)this.exportButton, null);
        this.cntrlPanel.add((Component)this.parent1Button, null);
        this.cntrlPanel.add((Component)this.parent2Button, null);
        this.cntrlPanel.add((Component)this.abortButton, null);
        this.cntrlPanel.add((Component)this.bestButton, null);
    }

    protected void stopButton_actionPerformed(ActionEvent e) {
        Calculation calc = this.getCalculation();
        calc.setAborted(true);
    }

    void bestButton_actionPerformed(ActionEvent e) {
        if (this.populationController != null) {
            this.populationController.dispatchBest(this.populationID, this.bestButton.isSelected());
        }
    }

    void abortButton_actionPerformed(ActionEvent e) {
        if (this.populationController != null) {
            this.populationController.dispatchAbort(this.populationID, this.abortButton.isSelected());
        }
    }

    void parent1Button_actionPerformed(ActionEvent e) {
        if (this.populationController != null) {
            this.populationController.dispatchParent1(this.populationID, this.parent1Button.isSelected());
        }
    }

    void parent2Button_actionPerformed(ActionEvent e) {
        if (this.populationController != null) {
            this.populationController.dispatchParent2(this.populationID, this.parent2Button.isSelected());
        }
    }

    void exportButton_actionPerformed(ActionEvent e) {
        ExportWizard exportFrame = new ExportWizard(this.populationController.getPopulation(), this.populationID, this.getCalculation(), this.populationController.getTitle(this.populationID));
        exportFrame.setTitle("Export: " + this.populationController.getTitle(this.populationID));
        exportFrame.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        exportFrame.setLocation((d.width - exportFrame.getSize().width) / 2, (d.height - exportFrame.getSize().height) / 2);
        exportFrame.pack();
        exportFrame.setVisible(true);
    }

    void editButton_actionPerformed(ActionEvent e) {
        if (this.chromosomeEditor == null) {
            PopulationType population = this.populationController.getPopulation();
            ChromosomeType chromosome = this.soupFactory.getChromosome(population, this.populationID);
            ColoratorType colorator = this.soupFactory.getColorator(population, this.populationID);
            this.chromosomeEditor = new ChromosomeEditor(this, "Edit: " + this.populationController.getTitle(this.populationID));
            this.soupFactory.fillEditor(chromosome, colorator, this.chromosomeEditor.getTree());
            this.chromosomeEditor.setSize(300, 500);
            this.chromosomeEditor.setVisible(true);
        } else {
            this.chromosomeEditor.toFront();
        }
    }

    void zoomButton_actionPerformed(ActionEvent e) {
        Calculation calc = this.getCalculation();
        PopulationType population = this.populationController.getPopulation();
        ZoomFrame zoomFrame = new ZoomFrame(this.populationController);
        zoomFrame.setTitle("Zoom: " + this.populationController.getTitle(this.populationID));
        zoomFrame.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        zoomFrame.setLocation((d.width - zoomFrame.getSize().width) / 2, (d.height - zoomFrame.getSize().height) / 2);
        zoomFrame.setVisible(true);
        zoomFrame.prepare(population, this.populationID, calc);
    }

    private void start(ChromosomeType chromosome, Calculation calculation, Colorator colorator, Fitness fitness) {
        this.percentageLabel.setText("");
        this.stopButton.setEnabled(true);
        this.stopButton.setVisible(true);
        try {
            this.viewEngine.prepare(chromosome, calculation, colorator);
            this.viewEngine.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        calculation.setFitness(fitness);
        this.toggleButtons();
    }

    public void start(PopulationType population, int nx, Fitness fitness) {
        try {
            this.populationID = nx;
            ChromosomeType chromosome = this.soupFactory.getChromosome(population, nx);
            Calculation calculation = new Gateway().createCalculation(this.soupFactory.getCalculationName(population, nx));
            ColoratorType coloratorType = this.soupFactory.getColorator(population, nx);
            String coloratorName = this.soupFactory.getColoratorName(population, nx);
            Colorator colorator = ColoratorFactory.createColoratorWorker(coloratorName, coloratorType);
            this.start(chromosome, calculation, colorator, fitness);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
    }

    public void startAnimation() {
        if (this.percentAnimation == null) {
            this.percentAnimation = new Animation();
            this.percentAnimation.start();
        }
    }

    public void restartAnimation() {
        if (this.percentAnimation != null) {
            this.percentAnimation.interrupt();
            this.percentAnimation = null;
        }
        this.startAnimation();
    }

    public void stop() {
        if (this.chromosomeEditor != null) {
            this.chromosomeEditor.dispose();
            this.chromosomeEditor = null;
        }
        this.stopButton.setEnabled(false);
        this.stopButton.setVisible(false);
        this.viewEngine.stop();
    }

    public void stopAnimation() {
        this.percentAnimation = null;
    }

    public Calculation getCalculation() {
        return this.viewEngine.getCalculation();
    }

    public void command(int cmd) {
        this.viewEngine.command(cmd);
    }

    public void toggleButtons() {
        Fitness fitness = this.viewEngine.getCalculation().getFitness();
        this.bestButton.setSelected(fitness.best);
        this.abortButton.setSelected(fitness.abort);
        this.parent1Button.setSelected(fitness.parent1);
        this.parent2Button.setSelected(fitness.parent2);
    }

    @Override
    public void quit() {
        this.chromosomeEditor = null;
    }

    @Override
    public void apply() {
        PopulationType population = this.populationController.getPopulation();
        ChromosomeType chromosome = this.soupFactory.getChromosome(population, this.populationID);
        LRUImageCache.getLRUImageCache().removeAll(chromosome.getIdent());
        this.populationController.apply(this.populationID);
    }

    public PopulationController getPopulationController() {
        return this.populationController;
    }

    public int getPopulationID() {
        return this.populationID;
    }

    public ViewEngine getViewEngine() {
        return this.viewEngine;
    }

    public void hideStopButton() {
        this.stopButton.setEnabled(false);
        this.stopButton.setVisible(false);
    }

    private class Animation
    extends Thread {
        private Animation() {
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            me.setPriority(6);
            OrganismPanel.this.percentageLabel.setForeground(Color.red);
            OrganismPanel.this.stopButton.setForeground(Color.red);
            while (!OrganismPanel.this.viewEngine.getCalculation().getReady() && OrganismPanel.this.percentAnimation == me) {
                try {
                    int percent = OrganismPanel.this.viewEngine.getCalculation().getPercent();
                    if (percent >= 0) {
                        OrganismPanel.this.percentageLabel.setText("" + OrganismPanel.this.viewEngine.getCalculation().getPercent());
                    } else {
                        OrganismPanel.this.percentageLabel.setText("");
                    }
                    OrganismPanel.this.headlinePanel.repaint();
                    Thread.sleep(600L);
                }
                catch (InterruptedException exc) {
                    OrganismPanel.this.percentAnimation = null;
                }
                catch (Exception exc) {
                    Debug.stackTrace(exc);
                }
            }
            OrganismPanel.this.percentageLabel.setText("");
            OrganismPanel.this.hideStopButton();
            OrganismPanel.this.percentAnimation = null;
        }
    }

    private class DragMouseAdapter
    extends MouseAdapter {
        private DragMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JComponent c = (JComponent)e.getSource();
            TransferHandler handler = c.getTransferHandler();
            handler.exportAsDrag(c, e, 1);
        }
    }
}

