/*
 * Decompiled with CFR 0.152.
 */
package kandid;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import junit.framework.Test;
import junit.textui.TestRunner;
import kandid.IconLoader;
import kandid.IntroWizard;
import kandid.PrimaryTests;
import kandid.util.Debug;

public class Kandid
implements WindowListener {
    public static final String localImageFolder = "filebase";
    public static final String incomingImageFolder = "incoming";
    public static String scratchFolder = "/dev/shm/kandid/scratch";
    public static String cacheFolder = "/dev/shm/kandid/cache";
    public static final String release = "1.2.0";
    public static final String preferencesFileName = "./kandid.preferences";
    public static Kandid kandid;
    private IntroWizard wizardPanel;
    private static JFrame frame;

    public Kandid() throws Exception {
        System.out.println("Kandid, a framework for genetic art. release 1.2.0");
        System.out.println("Copyright (C) 2002 - 2026 Thomas Jourdan");
        System.out.println();
        System.out.println("This program is free software: you can redistribute it and/or modify");
        System.out.println("it under the terms of the GNU General Public License as published by");
        System.out.println("the Free Software Foundation, either version 3 of the License, or");
        System.out.println("(at your option) any later version.");
        System.out.println();
        System.out.println("This program is distributed in the hope that it will be useful,");
        System.out.println("but WITHOUT ANY WARRANTY; without even the implied warranty of");
        System.out.println("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the");
        System.out.println("GNU General Public License for more details.");
        System.out.println();
        System.out.println("You should have received a copy of the GNU General Public License");
        System.out.println("along with this program.  If not, see <https://www.gnu.org/licenses/>.");
        System.out.println();
        System.out.println("\nUsed libraties:\n\nPNGJ: PNG image IO Java library\nCopyright 2009-2012 Hern\u00e1n J. Gonz\u00e1lez\nApache License Version 2.0, January 2004\n\nvecmath-1.5.2\nThe GNU General Public License (GPL) Version 2, June 1991\n\nJava\u2122 Architecture for XML Binding (JAXB)\nCopyright (c) Oracle\nCOMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL)Version 1.1\n\nactivation-1.1.1\nSun Microsystems, Inc\nGNU General Public License Version 2\n\nistack commons runtime\nCopyright (c) 2017 Oracle and/or its affiliates\n");
        System.out.println();
        System.out.println(Debug.info());
        kandid = this;
        this.wizardPanel = new IntroWizard();
    }

    public static Kandid getInstance() {
        return kandid;
    }

    public static JFrame getFrame() {
        return frame;
    }

    public void init() {
        try {
            IconLoader.load();
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
        try {
            this.jbInit();
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
    }

    public ImageIcon createImageIcon(String filename, String description) {
        String path = "/img/" + filename;
        return new ImageIcon(this.getClass().getResource(path), description);
    }

    private void jbInit() throws Exception {
        frame.setSize(new Dimension(505, 400));
        frame.getContentPane().add((Component)this.wizardPanel, "Center");
    }

    public static void main(String[] args) {
        if (args.length >= 1 && args[0].equals("-junit")) {
            TestRunner.run((Test)PrimaryTests.suite());
        } else {
            try {
                File dir;
                File filebaseDir;
                scratchFolder = "./scratch";
                cacheFolder = "./cache";
                File incomingDir = new File(incomingImageFolder);
                if (!incomingDir.exists()) {
                    incomingDir.mkdirs();
                }
                if (!(filebaseDir = new File(localImageFolder)).exists()) {
                    filebaseDir.mkdirs();
                }
                if ((dir = new File("/tmp")).exists() && dir.canWrite()) {
                    scratchFolder = "/tmp/kandid/scratch";
                    cacheFolder = "/tmp/kandid/cache";
                }
            }
            catch (Exception exc) {
                Debug.stackTrace(exc);
            }
            try {
                Kandid application = new Kandid();
                frame = new JFrame();
                frame.addWindowListener(application);
                frame.setDefaultCloseOperation(0);
                frame.setTitle("Kandid, a framework for genetic art.        1.2.0");
                application.init();
                frame.pack();
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                frame.setLocation((d.width - Kandid.frame.getSize().width) / 2, (d.height - Kandid.frame.getSize().height) / 2);
                frame.setVisible(true);
            }
            catch (Exception exc) {
                Debug.stackTrace(exc);
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        int co = JOptionPane.showConfirmDialog(frame, "All populations and images will be closed.\nAre you sure?", "Kandid", 0, 3);
        switch (co) {
            case 0: {
                System.exit(0);
                break;
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }
}

