/*
 * Decompiled with CFR 0.152.
 */
package kandid;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import kandid.Kandid;
import kandid.PopulationFrame;
import kandid.PopulationPreview;
import kandid.catalog.CalculationType;
import kandid.catalog.CatalogType;
import kandid.catalog.ModelType;
import kandid.extensions.FileList;
import kandid.util.Debug;

public class IntroWizard
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ImageIcon openImageIcon;
    private static ImageIcon rewindImageIcon;
    private CatalogType catalog;
    private String typeName = "";
    private String calculationName = "";
    private String coloratorName = "";
    private int nofColorators = 0;
    private int nRows = 3;
    private int nCols = 4;
    private JButton[][] typeButton;
    private JPanel controlPanel;
    private JButton rewindButton;
    private JPanel choicePanel;
    private JPanel card1Panel;
    private JPanel headline1Panel;
    private JPanel step1Panel;
    private JPanel card4Panel;
    private JPanel headline4Panel;
    private JPanel step4Panel;
    private JButton newButton;
    private JButton existingButton;
    private JPanel card2Panel;
    private JPanel headline2Panel;
    private JPanel step2Panel;
    private JButton bwButton;
    private JButton grayButton;
    private JButton rgbButton;
    private JButton lutButton;
    private JButton gradButton;
    private JButton hsbButton;
    private JButton transLutButton;
    private JPanel card3Panel;
    private JPanel headline3Panel;
    private JPanel step3Panel;
    private JButton pop10x7Button;
    private JButton pop4x3Button;
    private JButton pop6x4Button;
    private JButton pop8x5Button;
    private JPanel card5Panel;
    private JPanel headline5Panel;
    private JPanel step5Panel;
    private JButton loadButton;
    private JScrollPane jScrollPane1;
    private JList loadList;
    private JCheckBox newFilterCheckBox;

    public IntroWizard() throws JAXBException {
        this.initComponents();
        JAXBContext jc = JAXBContext.newInstance((String)"kandid.catalog");
        Unmarshaller u = jc.createUnmarshaller();
        JAXBElement uo = (JAXBElement)u.unmarshal(this.getClass().getResourceAsStream("/kandid/catalog/catalog.xml"));
        this.catalog = (CatalogType)uo.getValue();
        int gridRows = this.catalog.getGridRows();
        int gridCols = this.catalog.getGridCols();
        List<CalculationType> calculationList = this.catalog.getCalculation();
        this.typeButton = new JButton[gridRows][gridCols];
        GridBagConstraints gridBagConstraintsH1 = new GridBagConstraints();
        gridBagConstraintsH1.anchor = 13;
        gridBagConstraintsH1.gridx = 0;
        gridBagConstraintsH1.gridy = 0;
        gridBagConstraintsH1.gridwidth = 4;
        this.step1Panel.add((Component)new JLabel(new ImageIcon(this.getClass().getResource("/img/hline.png"))), gridBagConstraintsH1);
        GridBagConstraints gridBagConstraintsH2 = new GridBagConstraints();
        gridBagConstraintsH2.anchor = 13;
        gridBagConstraintsH2.gridx = 0;
        gridBagConstraintsH2.gridy = 5;
        gridBagConstraintsH2.gridwidth = 4;
        this.step1Panel.add((Component)new JLabel(new ImageIcon(this.getClass().getResource("/img/hline.png"))), gridBagConstraintsH2);
        GridBagConstraints gridBagConstraintsH3 = new GridBagConstraints();
        gridBagConstraintsH3.anchor = 13;
        gridBagConstraintsH3.gridx = 0;
        gridBagConstraintsH3.gridy = 8;
        gridBagConstraintsH3.gridwidth = 4;
        this.step1Panel.add((Component)new JLabel(new ImageIcon(this.getClass().getResource("/img/hline.png"))), gridBagConstraintsH3);
        GridBagConstraints gridBagConstraintsL1 = new GridBagConstraints();
        gridBagConstraintsL1.anchor = 12;
        gridBagConstraintsL1.gridx = 0;
        gridBagConstraintsL1.gridy = 1;
        gridBagConstraintsL1.gridheight = 4;
        this.step1Panel.add((Component)new JLabel(new ImageIcon(this.getClass().getResource("/img/evolvParameter.png"))), gridBagConstraintsL1);
        GridBagConstraints gridBagConstraintsL2 = new GridBagConstraints();
        gridBagConstraintsL2.anchor = 12;
        gridBagConstraintsL2.gridx = 0;
        gridBagConstraintsL2.gridy = 6;
        gridBagConstraintsL2.gridheight = 2;
        this.step1Panel.add((Component)new JLabel(new ImageIcon(this.getClass().getResource("/img/evolvCode.png"))), gridBagConstraintsL2);
        GridBagConstraints gridBagConstraintsL3 = new GridBagConstraints();
        gridBagConstraintsL3.anchor = 12;
        gridBagConstraintsL3.gridx = 0;
        gridBagConstraintsL3.gridy = 9;
        gridBagConstraintsL3.gridheight = 2;
        this.step1Panel.add((Component)new JLabel(new ImageIcon(this.getClass().getResource("/img/evolvExternals.png"))), gridBagConstraintsL3);
        for (CalculationType type : calculationList) {
            int xPos = type.getIcon().getGridX();
            int yPos = type.getIcon().getGridY();
            this.typeButton[yPos][xPos] = new JButton();
            this.typeButton[yPos][xPos].setActionCommand(type.getName());
            this.typeButton[yPos][xPos].setToolTipText(type.getTooltip());
            this.typeButton[yPos][xPos].setIcon(new ImageIcon(this.getClass().getResource(type.getIcon().getUrl())));
            this.typeButton[yPos][xPos].addActionListener(new TypeSelect());
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = xPos + 1;
            gridBagConstraints1.gridy = yPos < 4 ? yPos + 1 : (yPos < 6 ? yPos + 2 : yPos + 3);
            gridBagConstraints1.gridheight = 1;
            gridBagConstraints1.gridwidth = 1;
            this.step1Panel.add((Component)this.typeButton[yPos][xPos], gridBagConstraints1);
        }
    }

    private void initComponents() {
        this.controlPanel = new JPanel();
        this.rewindButton = new JButton();
        this.choicePanel = new JPanel();
        this.card1Panel = new JPanel();
        this.headline1Panel = new JPanel();
        this.step1Panel = new JPanel();
        this.card4Panel = new JPanel();
        this.headline4Panel = new JPanel();
        this.step4Panel = new JPanel();
        this.newButton = new JButton();
        this.existingButton = new JButton();
        this.card2Panel = new JPanel();
        this.headline2Panel = new JPanel();
        this.step2Panel = new JPanel();
        this.bwButton = new JButton();
        this.grayButton = new JButton();
        this.rgbButton = new JButton();
        this.lutButton = new JButton();
        this.gradButton = new JButton();
        this.hsbButton = new JButton();
        this.transLutButton = new JButton();
        this.card3Panel = new JPanel();
        this.headline3Panel = new JPanel();
        this.step3Panel = new JPanel();
        this.pop10x7Button = new JButton();
        this.pop4x3Button = new JButton();
        this.pop6x4Button = new JButton();
        this.pop8x5Button = new JButton();
        this.card5Panel = new JPanel();
        this.headline5Panel = new JPanel();
        this.step5Panel = new JPanel();
        this.loadButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.loadList = new JList();
        this.newFilterCheckBox = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.controlPanel.setLayout(new BorderLayout());
        if (rewindImageIcon == null) {
            rewindImageIcon = Kandid.getInstance().createImageIcon("rewind.png", null);
        }
        this.rewindButton.setIcon(rewindImageIcon);
        this.rewindButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroWizard.this.backButtonActionPerformed(evt);
            }
        });
        this.controlPanel.add((Component)this.rewindButton, "East");
        this.add((Component)this.controlPanel, "South");
        this.choicePanel.setLayout(new CardLayout());
        this.card1Panel.setLayout(new BorderLayout());
        this.headline1Panel.add(new JLabel(new ImageIcon(this.getClass().getResource("/img/step1.png"))));
        this.card1Panel.add((Component)this.headline1Panel, "North");
        this.step1Panel.setLayout(new GridBagLayout());
        this.card1Panel.add((Component)this.step1Panel, "Center");
        this.choicePanel.add((Component)this.card1Panel, "card1");
        this.card4Panel.setLayout(new BorderLayout());
        this.headline4Panel.add(new JLabel(new ImageIcon(this.getClass().getResource("/img/step2.png"))));
        this.card4Panel.add((Component)this.headline4Panel, "North");
        this.step4Panel.setLayout(new GridBagLayout());
        this.newButton.setText("<html>New Population</html>");
        this.newButton.setToolTipText("start with a new population");
        this.newButton.setMaximumSize(new Dimension(98, 74));
        this.newButton.setMinimumSize(new Dimension(98, 74));
        this.newButton.setPreferredSize(new Dimension(98, 74));
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroWizard.this.newButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        this.step4Panel.add((Component)this.newButton, gridBagConstraints2);
        this.existingButton.setText("<html>Open existing population</html>");
        this.existingButton.setToolTipText("load existing population");
        this.existingButton.setMaximumSize(new Dimension(98, 74));
        this.existingButton.setMinimumSize(new Dimension(98, 74));
        this.existingButton.setPreferredSize(new Dimension(98, 74));
        this.existingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroWizard.this.existingButtonActionPerformed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        this.step4Panel.add((Component)this.existingButton, gridBagConstraints2);
        this.card4Panel.add((Component)this.step4Panel, "Center");
        this.choicePanel.add((Component)this.card4Panel, "card4");
        this.card2Panel.setLayout(new BorderLayout());
        this.headline2Panel.add(new JLabel(new ImageIcon(this.getClass().getResource("/img/step3.png"))));
        this.card2Panel.add((Component)this.headline2Panel, "North");
        this.step2Panel.setLayout(new GridBagLayout());
        this.bwButton.setIcon(new ImageIcon(this.getClass().getResource("/img/bwColorator.png")));
        this.bwButton.setToolTipText("black and white");
        this.bwButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroWizard.this.bwButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
        this.step2Panel.add((Component)this.bwButton, gridBagConstraints3);
        this.grayButton.setIcon(new ImageIcon(this.getClass().getResource("/img/grayColorator.png")));
        this.grayButton.setToolTipText("gray scale");
        this.grayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroWizard.this.grayButtonActionPerformed(evt);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
        this.step2Panel.add((Component)this.grayButton, gridBagConstraints3);
        this.rgbButton.setIcon(new ImageIcon(this.getClass().getResource("/img/rgbColorator.png")));
        this.rgbButton.setToolTipText("red, green, blue");
        this.rgbButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroWizard.this.rgbButtonActionPerformed(evt);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
        this.step2Panel.add((Component)this.rgbButton, gridBagConstraints3);
        this.lutButton.setIcon(new ImageIcon(this.getClass().getResource("/img/lutColorator.png")));
        this.lutButton.setToolTipText("look up table");
        this.lutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroWizard.this.lutButtonActionPerformed(evt);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
        this.step2Panel.add((Component)this.lutButton, gridBagConstraints3);
        this.gradButton.setIcon(new ImageIcon(this.getClass().getResource("/img/gradientColorator.png")));
        this.gradButton.setToolTipText("color gradient");
        this.gradButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroWizard.this.gradButtonActionPerformed(evt);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
        this.step2Panel.add((Component)this.gradButton, gridBagConstraints3);
        this.hsbButton.setIcon(new ImageIcon(this.getClass().getResource("/img/hsbColorator.png")));
        this.hsbButton.setToolTipText("hue, saturation, brightness");
        this.hsbButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroWizard.this.hsbButtonActionPerformed(evt);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
        this.step2Panel.add((Component)this.hsbButton, gridBagConstraints3);
        this.card2Panel.add((Component)this.step2Panel, "Center");
        this.transLutButton.setIcon(new ImageIcon(this.getClass().getResource("/img/transparentLutColorator.png")));
        this.transLutButton.setToolTipText("look up table, transparent");
        this.transLutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroWizard.this.transLutButtonActionPerformed(evt);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
        this.step2Panel.add((Component)this.transLutButton, gridBagConstraints3);
        this.card2Panel.add((Component)this.step2Panel, "Center");
        this.choicePanel.add((Component)this.card2Panel, "card2");
        this.card3Panel.setLayout(new BorderLayout());
        this.headline3Panel.add(new JLabel(new ImageIcon(this.getClass().getResource("/img/step4.png"))));
        this.card3Panel.add((Component)this.headline3Panel, "North");
        this.step3Panel.setLayout(new GridBagLayout());
        this.pop10x7Button.setIcon(new ImageIcon(this.getClass().getResource("/img/square.png")));
        this.pop10x7Button.setText("<html><center><b>10x7</b></center></html>");
        this.pop10x7Button.setToolTipText("population with 70 images, needs 1280x960 screen resolution");
        this.pop10x7Button.setHorizontalTextPosition(0);
        this.pop10x7Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroWizard.this.pop10x7ButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 3;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
        this.step3Panel.add((Component)this.pop10x7Button, gridBagConstraints4);
        this.pop4x3Button.setIcon(new ImageIcon(this.getClass().getResource("/img/square.png")));
        this.pop4x3Button.setText("<html><center><b>4x3</b></center></html>");
        this.pop4x3Button.setToolTipText("population with 12 images");
        this.pop4x3Button.setHorizontalTextPosition(0);
        this.pop4x3Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroWizard.this.pop4x3ButtonActionPerformed(evt);
            }
        });
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
        this.step3Panel.add((Component)this.pop4x3Button, gridBagConstraints4);
        this.pop6x4Button.setIcon(new ImageIcon(this.getClass().getResource("/img/square.png")));
        this.pop6x4Button.setText("<html><center><b>6x4</b></center></html>");
        this.pop6x4Button.setToolTipText("population with 24 images");
        this.pop6x4Button.setHorizontalTextPosition(0);
        this.pop6x4Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroWizard.this.pop6x4ButtonActionPerformed(evt);
            }
        });
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
        this.step3Panel.add((Component)this.pop6x4Button, gridBagConstraints4);
        this.pop8x5Button.setIcon(new ImageIcon(this.getClass().getResource("/img/square.png")));
        this.pop8x5Button.setText("<html><center><b>8x5</b></center></html>");
        this.pop8x5Button.setToolTipText("population with 40 images, needs 1024x768 screen resolution");
        this.pop8x5Button.setHorizontalTextPosition(0);
        this.pop8x5Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroWizard.this.pop8x5ButtonActionPerformed(evt);
            }
        });
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
        this.step3Panel.add((Component)this.pop8x5Button, gridBagConstraints4);
        this.card3Panel.add((Component)this.step3Panel, "Center");
        this.choicePanel.add((Component)this.card3Panel, "card3");
        this.card5Panel.setLayout(new BorderLayout());
        this.headline5Panel.add(new JLabel(new ImageIcon(this.getClass().getResource("/img/step3load.png"))));
        this.card5Panel.add((Component)this.headline5Panel, "North");
        this.step5Panel.setLayout(new GridBagLayout());
        if (openImageIcon == null) {
            openImageIcon = Kandid.getInstance().createImageIcon("open.png", null);
        }
        this.loadButton.setIcon(openImageIcon);
        this.loadButton.setText("Open");
        this.loadButton.setEnabled(false);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroWizard.this.loadButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 3;
        gridBagConstraints5.gridy = 5;
        gridBagConstraints5.anchor = 13;
        this.step5Panel.add((Component)this.loadButton, gridBagConstraints5);
        this.newFilterCheckBox.setText("Only new versions");
        this.newFilterCheckBox.setSelected(true);
        this.newFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroWizard.this.newFilterCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 5;
        gridBagConstraints5.anchor = 13;
        this.step5Panel.add((Component)this.newFilterCheckBox, gridBagConstraints5);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setMinimumSize(new Dimension(455, 550));
        this.jScrollPane1.setPreferredSize(new Dimension(455, 550));
        this.loadList.setFont(new Font("Dialog", 0, 12));
        this.loadList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                IntroWizard.this.loadListValueChanged(evt);
            }
        });
        this.loadList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IntroWizard.this.loadListMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.loadList);
        gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.gridwidth = 0;
        gridBagConstraints5.gridheight = 5;
        gridBagConstraints5.fill = 1;
        this.step5Panel.add((Component)this.jScrollPane1, gridBagConstraints5);
        this.card5Panel.add((Component)this.step5Panel, "Center");
        this.choicePanel.add((Component)this.card5Panel, "card5");
        this.add((Component)this.choicePanel, "Center");
    }

    private void newFilterCheckBoxActionPerformed(ActionEvent evt) {
        this.createPreviewList();
    }

    private void loadListValueChanged(ListSelectionEvent evt) {
        this.loadButton.setEnabled(this.loadList.getSelectedValue() != null);
    }

    private void loadListMouseClicked(MouseEvent evt) {
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        this.showPool(false, (String)((Hashtable)this.loadList.getSelectedValue()).get("filename"));
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        if (this.nofColorators == 1) {
            ((CardLayout)this.choicePanel.getLayout()).show(this.choicePanel, "card3");
        } else {
            ((CardLayout)this.choicePanel.getLayout()).show(this.choicePanel, "card2");
        }
    }

    private void existingButtonActionPerformed(ActionEvent evt) {
        ((CardLayout)this.choicePanel.getLayout()).last(this.choicePanel);
    }

    private void bwButtonActionPerformed(ActionEvent evt) {
        this.coloratorName = "kandid.colorator.BlackWhiteColorator";
        ((CardLayout)this.choicePanel.getLayout()).next(this.choicePanel);
    }

    private void grayButtonActionPerformed(ActionEvent evt) {
        this.coloratorName = "kandid.colorator.GrayColorator";
        ((CardLayout)this.choicePanel.getLayout()).next(this.choicePanel);
    }

    private void rgbButtonActionPerformed(ActionEvent evt) {
        this.coloratorName = "kandid.colorator.RGBColorator";
        ((CardLayout)this.choicePanel.getLayout()).next(this.choicePanel);
    }

    private void lutButtonActionPerformed(ActionEvent evt) {
        this.coloratorName = "kandid.colorator.LookUpTableColorator";
        ((CardLayout)this.choicePanel.getLayout()).next(this.choicePanel);
    }

    private void gradButtonActionPerformed(ActionEvent evt) {
        this.coloratorName = "kandid.colorator.GradientColorator";
        ((CardLayout)this.choicePanel.getLayout()).next(this.choicePanel);
    }

    private void hsbButtonActionPerformed(ActionEvent evt) {
        this.coloratorName = "kandid.colorator.HsbFrequenceColorator";
        ((CardLayout)this.choicePanel.getLayout()).next(this.choicePanel);
    }

    private void transLutButtonActionPerformed(ActionEvent evt) {
        this.coloratorName = "kandid.colorator.TransparentLookUpTableColorator";
        ((CardLayout)this.choicePanel.getLayout()).next(this.choicePanel);
    }

    private void pop10x7ButtonActionPerformed(ActionEvent evt) {
        this.nRows = 7;
        this.nCols = 10;
        this.showPool(true, null);
    }

    private void pop4x3ButtonActionPerformed(ActionEvent evt) {
        this.nRows = 3;
        this.nCols = 4;
        this.showPool(true, null);
    }

    private void pop6x4ButtonActionPerformed(ActionEvent evt) {
        this.nRows = 4;
        this.nCols = 6;
        this.showPool(true, null);
    }

    private void pop8x5ButtonActionPerformed(ActionEvent evt) {
        this.nRows = 5;
        this.nCols = 8;
        this.showPool(true, null);
    }

    private void backButtonActionPerformed(ActionEvent evt) {
        ((CardLayout)this.choicePanel.getLayout()).first(this.choicePanel);
    }

    void showPool(boolean createNew, String populationFileName) {
        try {
            ((CardLayout)this.choicePanel.getLayout()).first(this.choicePanel);
            PopulationFrame populationFrame = new PopulationFrame();
            if (createNew) {
                this.mapCalculation();
                populationFrame.prepare(this.typeName, this.calculationName, this.coloratorName, this.nRows, this.nCols);
            } else {
                populationFrame.prepare(this.typeName, populationFileName);
            }
            populationFrame.pack();
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            populationFrame.setLocation((d.width - populationFrame.getSize().width) / 2, (d.height - populationFrame.getSize().height) / 2);
            populationFrame.setVisible(true);
            populationFrame.start(createNew);
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
        }
    }

    private void mapCalculation() {
        List<CalculationType> calculationList = this.catalog.getCalculation();
        block0: for (CalculationType calculation : calculationList) {
            if (!calculation.getName().equals(this.typeName)) continue;
            List<ModelType> modelList = calculation.getModel();
            for (ModelType model : modelList) {
                if (!this.coloratorName.equals(model.getColoratorClass())) continue;
                this.calculationName = model.getCalculationClass();
                continue block0;
            }
        }
    }

    private JList createPreviewList() {
        JList previewList = null;
        ArrayList<String> fileList = FileList.createImageList("./filebase", this.typeName, ".kpop");
        boolean useFilter = this.newFilterCheckBox.isSelected();
        if (fileList != null && fileList.size() > 0) {
            if (useFilter && fileList.size() > 1) {
                ArrayList<String> reducedList = new ArrayList<String>();
                reducedList.add(fileList.get(0));
                int ix = 1;
                while (ix < fileList.size()) {
                    if (this.isDifferent(fileList.get(ix), reducedList.get(reducedList.size() - 1))) {
                        reducedList.add(fileList.get(ix));
                    }
                    ++ix;
                }
                fileList = reducedList;
            }
            return PopulationPreview.createPreviewList(this.loadList, fileList);
        }
        return previewList;
    }

    private boolean isDifferent(Object pattern1, Object pattern2) {
        try {
            String s1 = (String)pattern1;
            String p1 = s1.substring(0, s1.lastIndexOf(95));
            String s2 = (String)pattern2;
            String p2 = s2.substring(0, s2.lastIndexOf(95));
            return !p1.equals(p2);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
            return true;
        }
    }

    private class TypeSelect
    implements ActionListener {
        private TypeSelect() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            IntroWizard.this.typeName = evt.getActionCommand();
            IntroWizard.this.nofColorators = 0;
            List<CalculationType> calculationList = IntroWizard.this.catalog.getCalculation();
            for (CalculationType calculation : calculationList) {
                if (!calculation.getName().equals(IntroWizard.this.typeName)) continue;
                IntroWizard.this.bwButton.setEnabled(false);
                IntroWizard.this.grayButton.setEnabled(false);
                IntroWizard.this.rgbButton.setEnabled(false);
                IntroWizard.this.lutButton.setEnabled(false);
                IntroWizard.this.gradButton.setEnabled(false);
                IntroWizard.this.hsbButton.setEnabled(false);
                IntroWizard.this.transLutButton.setEnabled(false);
                List<ModelType> modelList = calculation.getModel();
                for (ModelType model : modelList) {
                    if (model.getColoratorClass().equals("kandid.colorator.BlackWhiteColorator")) {
                        IntroWizard.this.bwButton.setEnabled(true);
                        IntroWizard.this.coloratorName = model.getColoratorClass();
                        ++IntroWizard.this.nofColorators;
                        continue;
                    }
                    if (model.getColoratorClass().equals("kandid.colorator.GrayColorator")) {
                        IntroWizard.this.grayButton.setEnabled(true);
                        IntroWizard.this.coloratorName = model.getColoratorClass();
                        ++IntroWizard.this.nofColorators;
                        continue;
                    }
                    if (model.getColoratorClass().equals("kandid.colorator.RGBColorator")) {
                        IntroWizard.this.rgbButton.setEnabled(true);
                        IntroWizard.this.coloratorName = model.getColoratorClass();
                        ++IntroWizard.this.nofColorators;
                        continue;
                    }
                    if (model.getColoratorClass().equals("kandid.colorator.LookUpTableColorator")) {
                        IntroWizard.this.lutButton.setEnabled(true);
                        IntroWizard.this.coloratorName = model.getColoratorClass();
                        ++IntroWizard.this.nofColorators;
                        continue;
                    }
                    if (model.getColoratorClass().equals("kandid.colorator.GradientColorator")) {
                        IntroWizard.this.gradButton.setEnabled(true);
                        IntroWizard.this.coloratorName = model.getColoratorClass();
                        ++IntroWizard.this.nofColorators;
                        continue;
                    }
                    if (model.getColoratorClass().equals("kandid.colorator.HsbFrequenceColorator")) {
                        IntroWizard.this.hsbButton.setEnabled(true);
                        IntroWizard.this.coloratorName = model.getColoratorClass();
                        ++IntroWizard.this.nofColorators;
                        continue;
                    }
                    if (!model.getColoratorClass().equals("kandid.colorator.TransparentLookUpTableColorator")) continue;
                    IntroWizard.this.transLutButton.setEnabled(true);
                    IntroWizard.this.coloratorName = model.getColoratorClass();
                    ++IntroWizard.this.nofColorators;
                }
            }
            JList previewList = IntroWizard.this.createPreviewList();
            if (previewList != null) {
                ((CardLayout)IntroWizard.this.choicePanel.getLayout()).next(IntroWizard.this.choicePanel);
            } else {
                IntroWizard.this.loadList.setListData(new String[0]);
                if (IntroWizard.this.nofColorators == 1) {
                    ((CardLayout)IntroWizard.this.choicePanel.getLayout()).show(IntroWizard.this.choicePanel, "card3");
                } else {
                    ((CardLayout)IntroWizard.this.choicePanel.getLayout()).show(IntroWizard.this.choicePanel, "card2");
                }
            }
        }
    }
}

