/*
 * Decompiled with CFR 0.152.
 */
package kandid;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import kandid.Console;
import kandid.Kandid;
import kandid.calculation.Calculation;
import kandid.calculation.Deviation;
import kandid.calculation.PixelCalculation;
import kandid.calculation.VectorCalculation;
import kandid.calculation.bridge.PixelBridgeCalculation;
import kandid.colorator.Colorator;
import kandid.extensions.LRUImageCache;
import kandid.soup.ChromosomeType;
import kandid.util.Debug;

public class Gateway {
    public static final int SCREEN = 1;
    public static final int BITMAP_FILE = 3;
    public static final int GENOMEDB = 6;
    private static LRUImageCache lruImageCache = LRUImageCache.getLRUImageCache();
    private Dimension canvasSize;
    private Calculation calc;
    private ChromosomeType chromosome;
    private Component viewComponent;
    private Image image;
    private Image cachedImage;
    private Graphics2D g2d;
    private int outputType;

    public void activateScreenCanvas(Dimension canvasSize, Component viewComponent, boolean zoomMode) {
        this.activateCanvas(1, canvasSize, viewComponent, null, zoomMode);
    }

    public void activateBitmapCanvas(Dimension canvasSize) {
        this.activateCanvas(3, canvasSize, Kandid.getFrame(), null, true);
    }

    private void activateCanvas(int outputType, Dimension canvasSize, Component viewComponent, Graphics2D setG2d, boolean zoomMode) {
        this.outputType = outputType;
        this.canvasSize = canvasSize;
        this.viewComponent = viewComponent;
        if (outputType == 3) {
            this.cachedImage = null;
            this.image = null;
        } else {
            this.image = this.cachedImage = lruImageCache.get(this.chromosome.getIdent(), canvasSize);
        }
        if (this.cachedImage == null) {
            if (this.calc instanceof VectorCalculation) {
                this.initVectorGraphics(setG2d);
                ((VectorCalculation)this.calc).activateCanvas(viewComponent, canvasSize, this.g2d, zoomMode);
            } else if (this.calc instanceof PixelCalculation) {
                this.initBitmapGraphics(setG2d);
                ((PixelCalculation)this.calc).activateCanvas(viewComponent, canvasSize, zoomMode);
                this.image = ((PixelCalculation)this.calc).getImage();
            }
        }
    }

    public void setChromosome(ChromosomeType chromosome, Calculation calculation, Colorator colorator) {
        this.calc = calculation;
        this.calc.setChromosome(chromosome, colorator);
        this.chromosome = chromosome;
    }

    public Calculation createCalculation(String calculationName) {
        try {
            Class<?> classDefinition = Class.forName(calculationName);
            Calculation calculation = (Calculation)classDefinition.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return calculation;
        }
        catch (Throwable exc) {
            Debug.stackTrace(exc);
            return null;
        }
    }

    private void initBitmapGraphics(Graphics2D setG2d) {
        if (this.outputType == 1 || this.outputType != 3) {
            // empty if block
        }
    }

    private void initVectorGraphics(Graphics2D setG2d) {
        if (this.outputType == 1) {
            this.image = this.viewComponent.createImage(this.canvasSize.width, this.canvasSize.height);
            this.g2d = (Graphics2D)this.image.getGraphics();
        } else if (this.outputType == 3) {
            this.image = new BufferedImage(this.canvasSize.width, this.canvasSize.height, 1);
            this.g2d = (Graphics2D)this.image.getGraphics();
        }
    }

    public Image getImage() {
        if (this.cachedImage != null) {
            return this.cachedImage;
        }
        if (this.calc instanceof PixelBridgeCalculation) {
            PixelBridgeCalculation pixelBridgeCalculation = (PixelBridgeCalculation)this.calc;
            this.image = pixelBridgeCalculation.getImage();
        }
        return this.image;
    }

    public Graphics2D getGraphics() {
        return this.g2d;
    }

    public void calculate(Deviation dev, boolean paintOnScreen, String exportFilename) {
        try {
            this.calc.calculate(dev, paintOnScreen, exportFilename);
        }
        catch (Throwable exc) {
            Console.append("Error in calculation '" + this.calc.toString() + "'.");
            Debug.stackTrace(exc);
        }
    }

    public void updateImage(JLabel iViewLabel) {
        if (!this.calc.isAborted()) {
            if (this.calc instanceof PixelCalculation) {
                PixelCalculation pixCalc = (PixelCalculation)this.calc;
                BufferedImage calculatedImage = pixCalc.getImage();
                AffineTransform aft = pixCalc.getAffineTransform();
                if (aft != null) {
                    if (aft.getScaleX() >= 1.0 || aft.getScaleY() >= 1.0) {
                        iViewLabel.setIcon(new ImageIcon(calculatedImage));
                    } else {
                        AffineTransformOp affineTransformOp = new AffineTransformOp(aft, 2);
                        BufferedImage scaledImage = new BufferedImage(this.canvasSize.width, this.canvasSize.height, 1);
                        affineTransformOp.filter(calculatedImage, scaledImage);
                        iViewLabel.setIcon(new ImageIcon(scaledImage));
                    }
                }
            } else if (this.calc instanceof VectorCalculation) {
                iViewLabel.setIcon(new ImageIcon(this.image));
            }
        }
    }

    public boolean getReady() {
        if (this.cachedImage != null) {
            return true;
        }
        if (this.image instanceof BufferedImage && this.calc.getReady() && !this.calc.isAborted()) {
            lruImageCache.put(this.calc, this.chromosome.getIdent(), (BufferedImage)this.image);
        }
        return this.calc.getReady();
    }

    public boolean getDeferred() {
        if (this.cachedImage != null) {
            return true;
        }
        return this.calc.getDeferred();
    }

    public Calculation getCalculation() {
        return this.calc;
    }
}

