/*
 * Decompiled with CFR 0.152.
 */
package kandid;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import kandid.DataSink;
import kandid.Kandid;
import kandid.soup.map.SetEditorMapping;
import kandid.tree.editor.UserNodeEditor;
import kandid.tree.renderer.UserNodeRenderer;

public class ChromosomeEditor
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static ImageIcon cancelImageIcon;
    private static ImageIcon acceptImageIcon;
    private JTree tree;
    private String title;
    private DataSink caller;
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JButton okButton = new JButton("Ok");
    private JButton applyButton = new JButton("Apply");
    private JButton cancelButton = new JButton("Close");
    private JPanel footerPanel = new JPanel();

    public ChromosomeEditor(DataSink caller, String title) {
        this.caller = caller;
        this.title = title;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.applyButton);
        this.okButton.setVisible(false);
    }

    private void initComponents() {
        this.setTitle(this.title);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ChromosomeEditor.this.closeEditor();
            }
        });
        this.tree = new JTree();
        this.tree.setEditable(true);
        this.tree.setModel(this.createModel());
        this.jScrollPane1.setViewportView(this.tree);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        if (acceptImageIcon == null) {
            acceptImageIcon = Kandid.getInstance().createImageIcon("accept.png", null);
        }
        this.okButton.setIcon(acceptImageIcon);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChromosomeEditor.this.okButton_actionPerformed(e);
            }
        });
        this.applyButton.setIcon(acceptImageIcon);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChromosomeEditor.this.applyButton_actionPerformed(e);
            }
        });
        if (cancelImageIcon == null) {
            cancelImageIcon = Kandid.getInstance().createImageIcon("cancel.png", null);
        }
        this.cancelButton.setIcon(cancelImageIcon);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChromosomeEditor.this.cancelButton_actionPerformed(e);
            }
        });
        this.footerPanel.add((Component)this.okButton, null);
        this.footerPanel.add((Component)this.applyButton, null);
        this.footerPanel.add((Component)this.cancelButton, null);
        this.getContentPane().add((Component)this.footerPanel, "South");
        this.pack();
    }

    void okButton_actionPerformed(ActionEvent e) {
        if (this.caller != null) {
            this.caller.apply();
        }
        this.closeEditor();
    }

    void applyButton_actionPerformed(ActionEvent e) {
        if (this.caller != null) {
            this.caller.apply();
        }
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.closeEditor();
    }

    private void closeEditor() {
        if (this.caller != null) {
            this.caller.quit();
        }
        this.dispose();
        SetEditorMapping.dump(this.tree);
    }

    private DefaultTreeModel createModel() {
        UserNodeRenderer renderer = new UserNodeRenderer();
        UserNodeEditor editor = new UserNodeEditor(this.tree, renderer, null);
        this.tree.setCellRenderer(renderer);
        this.tree.setCellEditor(editor);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.title);
        return new DefaultTreeModel(root);
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setTree(JTree tree) {
        this.tree = tree;
    }
}

