/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.util;

import junit.framework.TestCase;
import kandid.colorator.GrayColorator;

public class WeightTest extends TestCase {

  /**
   * Constructor for WeightTest.
   * @param arg0
   */
  public WeightTest(String arg0) {
    super(arg0);
  }

  public void testGetMax() {
    Weight weight = new Weight(100, 50, new GrayColorator());
    assertEquals(weight.getMax(), 0);
    assertEquals(weight.at(0, 0), 0);
    weight.inc(0, 0);
    weight.inc(99, 49);
    weight.inc(99, 49);
    assertEquals(weight.at(99, 49), 2);
    try {
      assertEquals(weight.at(100, 50), 0);       
    } catch (ArrayIndexOutOfBoundsException exc) {
      // should never raise an ArrayIndexOutOfBoundsException
      assertTrue(false);
    }
    assertEquals(weight.getMax(), 2);
  }

}
