/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.util;

import java.awt.FlowLayout;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import kandid.IconLoader;

/**
 * @author thomas jourdan
 *
 */
public class UiCopyleft extends JFrame {

	private static final long serialVersionUID = 1L;

  private javax.swing.JPanel jContentPane = null;

	private JPanel buttonPanel = null;
	private JPanel kandidPanel = null;
	private JButton closeButton = null;
	private JLabel kandidLabel = null;

  private IlCopyleft ilCopyleft;
	/**
	 * This is the default constructor
	 */
	public UiCopyleft() {
		super();
		initialize();
	}
  /**
   * @param ilCopyleft
   */
  public UiCopyleft(IlCopyleft ilCopyleft) {
    this();
    this.ilCopyleft = ilCopyleft;
  }
	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
//		this.setSize(300,200);
		this.setContentPane(getJContentPane());
		this.setTitle("Copyright");
	}
	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private javax.swing.JPanel getJContentPane() {
		if(jContentPane == null) {
			kandidLabel = new JLabel();
			jContentPane = new javax.swing.JPanel();
			jContentPane.setLayout(new BoxLayout(jContentPane, BoxLayout.Y_AXIS));
			kandidLabel.setText("<html>"
		      + "<br>Kandid is written by Thomas Jourdan. 2002-2025<br>Licensed under GNU GENERAL PUBLIC LICENSE, Version 3."
		      + "<br>"
			    + IlCopyleft.lib_text.replace("\n", "<br>")
			+ "</html>");
			jContentPane.setBorder(javax.swing.BorderFactory.createEmptyBorder(0,5,0,5));
			jContentPane.add(getKandidPanel(), null);
			jContentPane.add(getButtonPanel(), null);
		}
		return jContentPane;
	}
	/**
	 * This method initializes buttonPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	private JPanel getButtonPanel() {
		if (buttonPanel == null) {
			FlowLayout flowLayout1 = new FlowLayout();
			buttonPanel = new JPanel();
			buttonPanel.setLayout(flowLayout1);
			flowLayout1.setAlignment(java.awt.FlowLayout.RIGHT);
			buttonPanel.setAlignmentX(0.0F);
			buttonPanel.add(getCloseButton(), null);
		}
		return buttonPanel;
	}
	/**
	 * This method initializes kandidPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	private JPanel getKandidPanel() {
		if (kandidPanel == null) {
			kandidPanel = new JPanel();
			kandidPanel.setLayout(new BoxLayout(kandidPanel, BoxLayout.Y_AXIS));
			kandidPanel.add(kandidLabel, null);
		}
		return kandidPanel;
	}
	/**
	 * This method initializes closeButton	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	private JButton getCloseButton() {
		if (closeButton == null) {
			closeButton = new JButton();
      closeButton.setIcon(IconLoader.cancelImageIcon);
			closeButton.setText("Close");
			closeButton.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {    
          ilCopyleft.close();
				}
			});
		}
		return closeButton;
	}
}
