/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.util;

import java.io.PrintStream;

public class Debug {
  public static final boolean enabled = false;
  private static Runtime currentRuntime;
  private static PrintStream stream = null;
  private static long startStamp;
  
  static {
    currentRuntime = Runtime.getRuntime();
    startStamp = System.currentTimeMillis();
  }

  /** 
   *Don't let anyone else instantiate this class.
   */
  private Debug() {
  }

  /**
   * Generates information about memory usage.
   *
   * @return memory usage
   */
  public static String memoryText() {
    return "Memory used: " + ((currentRuntime.totalMemory() - currentRuntime.freeMemory()) / 1024) + "K, free memory: " + currentRuntime.freeMemory() / 1024 + "K, total memory: " + currentRuntime.totalMemory() / 1024 + "K.";
  }
  
  /**
   * Returns the time in milliseconds elapsed since program start up.
   *
   * @return memory usage
   */
  public static String currentTime() {
    return " t" + (System.currentTimeMillis() - startStamp);
  }
  
  /**
   * Generates information about the state of this class.
   */
  public static String info() {
    boolean assertEnabled = false;
    assert assertEnabled = true;
    return "Debug code is " + (Debug.enabled ? "enabled." : "disabled.") + 
           "\nAssertions are " + (assertEnabled ? "enabled." : "disabled.");
  }

  /**
   * Prints stack trace.
   *
   * @param exc an exception
   */
  public static void stackTrace(Throwable exc) {
    stream = System.err;
    stream.println("");
    stream.println(exc.toString() + "  " + currentTime());
    exc.printStackTrace(stream);
  }

}

