/*
 * UserText.java
 * sample code from Alexander Gusev
 * Created on October 31, 2001, 9:34 PM
 */

package kandid.tree.user;

import java.lang.reflect.Method;
import javax.swing.JLabel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.tree.TreeCellEditor;

import kandid.tree.editor.TextCellEditor;
import kandid.util.Debug;
/**
 *
 * @author  Alexander Gusev
 */
public class UserText extends AbstractUserObject {

  public UserText(JLabel label, TreeCellEditor editor, String value, Object dataModel, Method dataSetter) {
    super(label, editor, value, dataModel, dataSetter);
  }

  public void setAfterEditing(JComponent source) {
    String newValue = ((JTextField) source).getText();
    if (!value.equals(newValue)) {
      try {
        sendToModel(getInnerText(newValue));
        value = newValue;
      } catch (Exception exc) {
        Debug.stackTrace(exc);
      }
    }
  }

  public JComponent getRenderer() {
    JLabel label = (JLabel) renderer;
    if (value == null)
      label.setText("");
    else
      label.setText((String) value);
    return label;
  }

  public TreeCellEditor getEditor() {
    ((TextCellEditor) editor).setValue(getRenderValue());
    return editor;
  }

  public Object getValue() {
    return value;
  }

  public String getInnerText(String fullValue) {
    String innerValue = fullValue;
    try {
      int pos = fullValue.indexOf(" = ");
      if (pos >= 0) {
        pos += 2;
      }
      else if (pos < 0) {
        fullValue.indexOf("=");
      }
      if (pos >= 0) {
        innerValue = fullValue.substring(pos + 1);
      }
    } catch (Exception exc) {
      Debug.stackTrace(exc);
    }
    return innerValue.trim();
  }
}
