/*
 * UserCheckBox.java
 * sample code from Alexander Gusev
 * Created on October 31, 2001, 9:38 PM
 */

package kandid.tree.user;

import java.lang.reflect.Method;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.tree.TreeCellEditor;

import kandid.tree.editor.CheckBoxCellEditor;
/**
 *
 * @author  Alexander Gusev
 */
public class UserCheckBox extends AbstractUserObject {
  private String text;
  private boolean bolValue;
  private Object[] forSetValue;

  public UserCheckBox(JCheckBox checkBox, TreeCellEditor editor, String text, boolean value, Object dataModel, Method dataSetter) {
    super(checkBox, editor, null, dataModel, dataSetter);
    this.text = text;
    this.bolValue = value;
    this.forSetValue = new Object[2];
  }
  
  public void setAfterEditing(JComponent newValue) {
    bolValue = ((JCheckBox) newValue).isSelected();
    sendToModel(Boolean.valueOf(bolValue));
  }
  
  public JComponent getRenderer() {
    JCheckBox box = (JCheckBox) renderer;
    box.setSelected(bolValue);
    if (text != null)
      box.setText(text);
    return box;
  }
  
  public TreeCellEditor getEditor() {
    forSetValue[1 - 1] = Boolean.valueOf(bolValue);
    forSetValue[2 - 1] = text;
    ((CheckBoxCellEditor) editor).setValue(forSetValue);
    return editor;
  }

  public Object getValue() {
    return Boolean.valueOf(bolValue);
  }
}
