/*
 * TreeNodeRenderer.java
 * sample code from Alexander Gusev
 * Created on October 31, 2001, 8:26 PM
 */

package kandid.tree.renderer;


import java.awt.Color;
import java.awt.Component;
import javax.swing.*;
import javax.swing.tree.DefaultTreeCellRenderer;


import kandid.tree.user.*;
/**
 *
 * @author  Alexander Gusev
 */
public class UserNodeRenderer extends DefaultTreeCellRenderer{
    private static final long serialVersionUID = 1L;
    
    protected JComponent renderer;
    
    /** Creates new TreeNodeRenderer */
    public Component getTreeCellRendererComponent(JTree tree,Object value,boolean selected,
                                                        boolean expanded,boolean leaf,
                                                        int row,boolean hasFocus) {
           if( !(value instanceof UserTreeNode) )
               return super.getTreeCellRendererComponent( tree, value, selected,expanded, leaf,row, hasFocus);
           UserTreeNode node = (UserTreeNode) value;

           AbstractUserObject userObject = (AbstractUserObject)node.getUser();
           renderer = node.getUser().getRenderer();
           if( selected ){
               if( !renderer.isOpaque() ){
                   renderer.setOpaque( true );
               }
               renderer.setForeground( this.getTextSelectionColor() );
               renderer.setBackground( this.getBackgroundSelectionColor() );
           }else{
               renderer.setForeground( this.getTextNonSelectionColor() );
               Color backgroundColor = userObject.getBackgroundColor();
               renderer.setBackground( backgroundColor == null ? this.getBackgroundNonSelectionColor() : backgroundColor);
           }
           return renderer;
    }
}
