/*
 * ComboBoxCellEditor.java
 * sample code from Alexander Gusev
 * Created on October 9, 2001, 4:36 PM
 */

package kandid.tree.editor;

import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;

import kandid.tree.user.SetValue;
/**
 *
 * @author Alexander Gusev
 * @version 
 */
public class ComboBoxCellEditor extends DefaultCellEditor implements SetValue {
  private static final long serialVersionUID = 1L;
  
  /** Creates new ComboBoxCellEditor */
  public ComboBoxCellEditor(final JComboBox box) {
    super(box);
  }
  public boolean shouldSelectCell(EventObject event) {
    boolean retValue = super.shouldSelectCell(event);
    getComponent().requestFocus();
    return retValue;
  }
  public void setValue(Object value) {
    Object[] param = (Object[]) value;
    DefaultComboBoxModel model = (DefaultComboBoxModel) param[1 - 1];
    Object toSelect = param[2 - 1];

    JComboBox box = (JComboBox) editorComponent;
    box.setModel(model);
    if (toSelect != null)
      box.setSelectedItem(toSelect);
  }
}
