/*
 * CheckBoxCellEditor.java
 * sample code from Alexander Gusev
 * Created on October 9, 2001, 4:34 PM
 */

package kandid.tree.editor;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTree;

import kandid.tree.user.SetValue;
import kandid.tree.user.UserTreeNode;

/**
 *
 * @author  Alexander Gusev
 * @version 
 */
public class CheckBoxCellEditor extends DefaultCellEditor implements SetValue {
  private static final long serialVersionUID = 1L;
  
  /** Creates new CheckBoxCellEditor */
  public CheckBoxCellEditor(final JCheckBox box) {
    super(box);
  }

  public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
    if (!(value instanceof UserTreeNode))
      return super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
    return editorComponent;
  }

  public boolean shouldSelectCell(EventObject event) {
    boolean retValue = super.shouldSelectCell(event);
    getComponent().requestFocus();
    return retValue;
  }
  public void setValue(Object value) {
    Object[] param = (Object[]) value;
    Boolean bol = (Boolean) param[1 - 1]; //value
    String text = (String) param[2 - 1]; // text

    JCheckBox box = (JCheckBox) editorComponent;
    box.setSelected(bol.booleanValue());
    if (text != null)
      box.setText(text);
  }

}
