/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.soup.test;

import java.io.FileReader;
import java.io.LineNumberReader;

/**
 * 
 * @author thomas jourdan
 */
public class FileDiff {

  /**
   * Tests if two file have same content. All lines are trimed. Ident tag is not
   * checked.
   * 
   * @param fileName1
   * @param fileName2
   * @return true if file have same content
   */
  public boolean isEquals(String fileName1, String fileName2, boolean ignoreIdent) {
    boolean ok = true;
    LineNumberReader lineReader1 = null;
    LineNumberReader lineReader2 = null;
    try {
      lineReader1 = new LineNumberReader(new FileReader(fileName1));
      lineReader2 = new LineNumberReader(new FileReader(fileName2));
      String line1 = lineReader1.readLine();
      String line2 = lineReader2.readLine();
      while (line1 != null && line2 != null) {
        line1 = line1.trim();
        line2 = line2.trim();
        boolean isIdent1 = ignoreIdent && line1.startsWith("<ident>") && line1.endsWith("</ident>");
        boolean isIdent2 = ignoreIdent && line2.startsWith("<ident>") && line2.endsWith("</ident>");
        if (!(isIdent1 && isIdent2)) {
          if (!line1.equals(line2)) {
            System.out.println("meld " + fileName1 + " " + fileName2 + " &");
            System.out.println("lines with different content");
            System.out.println(line1);
            System.out.println(line2);
            ok = false;
            break;
          }
        }
        line1 = lineReader1.readLine();
        line2 = lineReader2.readLine();
      }
      if ((line1 == null && line2 != null) || (line1 != null && line2 == null)) {
        System.out.println(fileName1);
        System.out.println(fileName2);
        System.out.println("different number of lines");
        ok = false;
      }
      if (lineReader1 != null)
        lineReader1.close();
      if (lineReader2 != null)
        lineReader2.close();
    } catch (Exception exc) {
//      Debug.stackTrace(exc);
      ok = false;
    }
    return ok;
  }

}
