/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.soup.test;

import junit.framework.TestCase;
import kandid.soup.util.ChromosomeStamp;

/**
 * 
 * @author thomas jourdan
 */
public class ChromosomeStampTest extends TestCase {
  
  /**
   * Constructor for ChromosomeStampTest.
   * @param arg0
   */
  public ChromosomeStampTest(String arg0) {
    super(arg0);
  }

 public void testChromosomeStamp() {
    ChromosomeStamp chromosomeStamp = new ChromosomeStamp("testStamp");
    chromosomeStamp.wipeIdent();
    assertTrue(chromosomeStamp.getNextStamp().endsWith("_1"));
    assertTrue(chromosomeStamp.getStamp().startsWith("testStamp"));
    
    String stamp2 = ChromosomeStamp.forceNextChromosomeId(chromosomeStamp.getStamp());
    assertTrue(chromosomeStamp.getStamp().equals(stamp2));
    assertTrue(stamp2.endsWith("_2"));
    assertTrue(stamp2.startsWith("testStamp"));
    
    String stamp3 = ChromosomeStamp.forceNextChromosomeId(stamp2);
    assertTrue(stamp3.endsWith("_3"));
    
    String stamp4 = ChromosomeStamp.forceNextChromosomeId(stamp2);
    assertTrue(stamp4.endsWith("_4"));
    
    String stamp100 = stamp4.substring(0,stamp4.length()-1) + "100";
    String stamp101 = ChromosomeStamp.forceNextChromosomeId(stamp100);
    assertTrue(stamp101.endsWith("_101"));
    
    String stamp102 = ChromosomeStamp.forceNextChromosomeId(stamp101);
    assertTrue(stamp102.endsWith("_102"));
  }

 public void testPopulationIDfromName() {
    ChromosomeStamp chromosomeStamp1 = new ChromosomeStamp("testStamp");
    chromosomeStamp1.setPopulationIDfromName("Voronoi_dfg9g66x_2.kpop");
    assertEquals("Voronoi_RGB_dfg9g66x", chromosomeStamp1.getTypePopulationIdent("RGB"));
//!!    assertTrue(chromosomeStamp1.getUniqStoreID() == 3);
    
    ChromosomeStamp chromosomeStamp2 = new ChromosomeStamp("testStamp");
    chromosomeStamp2.setPopulationIDfromName("./filebase/SymmetricIfs/dg2i0fgw/SymmetricIfs/SymmetricIfs_dfg9g66x_2.kpop");
    assertEquals("SymmetricIfs_x_dfg9g66x", chromosomeStamp2.getTypePopulationIdent("x"));
  }

  public void testPatchPopulationIdent() {
     assertEquals("Voronoi_RGB_123456_2", ChromosomeStamp.patchPopulationIdent("Voronoi_RGB_dfg9g66x_2", "123456"));
   }

  public void testRemoveType() {
     assertEquals("dt70u63c_dt70u64j", ChromosomeStamp.removeType("PovThing_dt70u63c_dt70u64j"));
   }

}
