<!--
  Copyright (C) 2002 - 2025 Thomas Jourdan

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:jxb="http://java.sun.com/xml/ns/jaxb"
                xmlns:kandid="http://kandid.sourceforge.net/2003/XMLSchema"
                version="1.0">

  <xsl:output method="text"/>

  <xsl:template match="xsd:schema">
    <xsl:variable name="chromosomeType" select="descendant::xsd:element[@name='chromosome']/@type"/>
    // This file was generated by the sdlexport.xsl style sheet. 
    // Any modifications to this file will be lost upon recompilation of the style sheet or the source schema. 
    
    package kandid.calculation.bridge.povray;
      import kandid.soup.ExprSdlArgsListGene;
      import kandid.soup.ExprSdlListGene;
      import kandid.soup.ExprSdlOprBase;
      import kandid.soup.ExprSdlOprGene;
      import kandid.soup.ExprSdlVarBase;

    public class SdlExport {

      public SdlExport() {
      }
			
			/**
			 * generateSDLFunction.
			 * @param sdlExpressionGene
			 */
			public StringBuffer generateSDLFunction(ExprSdlListGene exprSdlListGene) {
        StringBuffer sdl = new StringBuffer();
        sdl.append("function(x,y,z) { ");
        sdl.append(compile0(exprSdlListGene));
        sdl.append(" }");
        return sdl;
			}

      <xsl:call-template name="compile0"/>

      /**
       * @param obj
       */
      private StringBuffer compileElement(Object obj) {
        StringBuffer sdl = new StringBuffer();
        if (obj instanceof ExprSdlArgsListGene.Var) {
          ExprSdlArgsListGene.Var var = (ExprSdlArgsListGene.Var) obj;
          if (var.getSdlVar().equals(ExprSdlVarBase.X)) {
            sdl.append(" x");        
          }
          else if (var.getSdlVar().equals(ExprSdlVarBase.Y)) {
            sdl.append(" y");        
          }
          else if (var.getSdlVar().equals(ExprSdlVarBase.Z)) {
            sdl.append(" z");        
          }
        }
        else if (obj instanceof ExprSdlArgsListGene.Const) {
          ExprSdlArgsListGene.Const aConst = (ExprSdlArgsListGene.Const) obj;
          sdl.append(" " + aConst.getSdlConst().getValue());        
        }
        else if (obj instanceof ExprSdlArgsListGene.SdlExpression) {
          ExprSdlArgsListGene.SdlExpression sdlExpressionArg = (ExprSdlArgsListGene.SdlExpression) obj;
          sdl.append(compile0(sdlExpressionArg.getList()));
        }
        else {
          assert false : "invalide object generating SDL expression" + obj.getClass().getName();
        }
        return sdl;
      }
    
    }
  </xsl:template>


  <xsl:template name="compile0">
    /**
     * Method compile0.
     * @param sdlExpressionGene
     */
    private StringBuffer compile0(ExprSdlListGene exprSdlListGene) {
      StringBuffer sdl = new StringBuffer();
      sdl.append("(");
      ExprSdlOprGene opr = exprSdlListGene.getOpr();
      ExprSdlArgsListGene args = exprSdlListGene.getArgs();
      java.util.List argsList = args.getVarOrConstOrSdlExpression();
      int argsLen = argsList.size();
      assert argsLen > 0 : "argument list to short " + argsLen;
      if (false) {
      }
      <xsl:for-each select="descendant::xsd:simpleType[@name = 'exprSdlOprBase']">
        <xsl:for-each select="descendant::xsd:restriction/xsd:enumeration/xsd:annotation/xsd:appinfo">
          else if(opr.getSdlOpr().equals(ExprSdlOprBase.<xsl:value-of select="translate(../../@value, 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>)) {
          <xsl:choose>
            <xsl:when test="(kandid:args) and (kandid:sdlPrefixFragment)">
              <!-- function with fixed number of arguments -->
              // function with <xsl:value-of select="kandid:args"/> of arguments
              int fixedLen = <xsl:value-of select="kandid:args"/>;
              sdl.append("<xsl:value-of select="kandid:sdlPrefixFragment"/>(");                
              for (int ax = 0; ax &lt; fixedLen; ax++) {
                sdl.append(compileElement(argsList.get(ax % argsList.size())));
                if(ax+1 &lt; fixedLen)
                  sdl.append(",");                
              }
              sdl.append(")");
            </xsl:when>
            <xsl:when test="not(kandid:args) and (kandid:sdlInfixFragment)">
              <!-- operator chain with varaible number of arguments -->
              // operator chain with varaible number of arguments
              for (int ax = 0; ax &lt; argsLen; ax++) {
                sdl.append(compileElement(argsList.get(ax)));
                if(ax+1 &lt; argsLen)
                  sdl.append("<xsl:value-of select="kandid:sdlInfixFragment"/>");                
              }
            </xsl:when>
            <xsl:when test="not(kandid:args) and (kandid:sdlPrefixFragment)">
              <!-- function with varaible number of arguments -->
              // function with varaible number of arguments
              sdl.append("<xsl:value-of select="kandid:sdlPrefixFragment"/>(");                
              for (int ax = 0; ax &lt; argsLen; ax++) {
                sdl.append(compileElement(argsList.get(ax)));
                if(ax+1 &lt; argsLen)
                  sdl.append(",");                
              }
              sdl.append(")");
            </xsl:when>
            <xsl:otherwise>
            // TODO not supported by sdlexport.xsl
            !! ERROR
            </xsl:otherwise>
          </xsl:choose>
          }
        </xsl:for-each>
      </xsl:for-each>
      else {
        assert false : "invalide operator " + opr.getSdlOpr();
      }
      sdl.append(")");
      return sdl;
    }
  </xsl:template>


  <xsl:template match="*">
  </xsl:template>

</xsl:stylesheet>

