<?xml version="1.0" encoding="UTF-8"?>
<!--
  Copyright (C) 2002 - 2025 Thomas Jourdan

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:jxb="http://java.sun.com/xml/ns/jaxb"
                xmlns:kandid="http://kandid.sourceforge.net/2003/XMLSchema"
                version="1.0">

<xsl:output method="text"/>

<xsl:template match="xsd:schema">
<xsl:variable name="chromosomeType" select="descendant::xsd:element[@name='chromosome']/@type"/>
// This file was generated by the random.xsl style sheet. 
// Any modifications to this file will be lost upon recompilation of the style sheet or the source schema. 

package kandid.soup.map;
import javax.xml.bind.JAXBException;
import kandid.soup.*;
import kandid.soup.genetic.lsys.LsysGenetic;
public class RandomizeChromosome {

  private static ObjectFactory objectFactory = new ObjectFactory();

  <xsl:apply-templates/>
}
</xsl:template>

<xsl:template match="xsd:complexType">
  <xsl:if test="contains(@name, 'Gene')">
    <xsl:variable name="geneType" select="@name"/>
    <xsl:choose>
      <xsl:when test="@name = 'booleanGene'">
        protected void randomize(^<xsl:value-of select="$geneType"/> aGene, ChromosomeType aChromosome, double probability, int depth) throws JAXBException {
      </xsl:when>
      <xsl:when test="@name = 'integerGene'">
        protected void randomize(^<xsl:value-of select="$geneType"/> aGene, int minInclusive, int maxInclusive, ChromosomeType aChromosome, boolean binomialRamdomizer, double binomialProbability, int depth) throws JAXBException {
      </xsl:when>
      <xsl:when test="@name = 'doubleGene'">
        protected void randomize(^<xsl:value-of select="$geneType"/> aGene, double minInclusive, double maxInclusive, ChromosomeType aChromosome, boolean binomialRamdomizer, double binomialProbability, int depth) throws JAXBException {
      </xsl:when>
      <xsl:otherwise>
        protected void randomize(^<xsl:value-of select="$geneType"/> aGene, ChromosomeType aChromosome, int depth) throws JAXBException {
      </xsl:otherwise>
    </xsl:choose>
    <!-- call randomizer for super class -->
    <xsl:for-each select="descendant::xsd:extension">
      <xsl:if test="not(@base = 'geneType')">
        randomize((^<xsl:value-of select="@base"/>)aGene, aChromosome, depth);
      </xsl:if>
    </xsl:for-each>
    <!-- randomize members -->
    <xsl:if test="descendant::xsd:choice">
      <xsl:for-each select="descendant::xsd:choice">
        <xsl:if test="@minOccurs and @maxOccurs">
          <xsl:variable name="variants" select="count(descendant::xsd:element)"/>
            java.util.List list = aGene.get^<xsl:value-of select="descendant::xsd:element[position()=1]/@name"/><xsl:for-each select="descendant::xsd:element/following-sibling::xsd:element">Or^<xsl:value-of select="@name"/></xsl:for-each>();
            list.clear();
            int len = kandid.util.CentralRandomizer.getInt(<xsl:value-of select="@minOccurs"/>, <xsl:value-of select="@maxOccurs"/>);
            while(len > 0) {
              switch(kandid.util.CentralRandomizer.getInt(1, <xsl:value-of select="$variants"/>)) {
              <xsl:for-each select="descendant::xsd:element">
                case <xsl:number format="1" value="position()"/>:
                  <xsl:if test="contains(@name, 'Expression')">
										if(kandid.util.CentralRandomizer.getDouble(0.0, 0.15) &lt; (1.0 / depth)) {
									</xsl:if>
											^<xsl:value-of select="@type"/> aNew^<xsl:value-of select="@name"/> = objectFactory.create^<xsl:value-of select="@type"/>();
											randomize(aNew^<xsl:value-of select="@name"/>, aChromosome, depth+1);
											list.add(aNew^<xsl:value-of select="@name"/>);
											--len;
                  <xsl:if test="contains(@name, 'Expression')">
										}
									</xsl:if>
                  break;
              </xsl:for-each>
              }
            }
        </xsl:if>
      </xsl:for-each>
    </xsl:if>
    <xsl:if test="not(descendant::xsd:choice)">
      <xsl:for-each select="descendant::xsd:element">
        <xsl:if test="xsd:annotation/xsd:appinfo/kandid:random">
          // section copied from xsd:annotation/xsd:appinfo/kandid:random
          <xsl:value-of select="xsd:annotation/xsd:appinfo/kandid:random"/>
          // end section
        </xsl:if>
        <xsl:if test="not(xsd:annotation/xsd:appinfo/kandid:random)">
        <xsl:variable name="schemaBaseType" select="@type"/>
        <xsl:if test="not(contains($schemaBaseType, 'Gene'))">
          <!-- members are basic data type -->
          <xsl:variable name="javaReturnType" select="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:annotation/xsd:appinfo/jxb:javaType/@name"/>
          <xsl:variable name="enumvalues" select="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:restriction/xsd:enumeration/@value"/>
          <xsl:if test="$enumvalues">
            <!-- basic data type is an enumeration -->
            {
            String enumNames[] = {
            <xsl:for-each select="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:restriction/xsd:enumeration">
              "<xsl:value-of select="@value"/>",
            </xsl:for-each>
            };
            aGene.set^<xsl:value-of select="@name"/>(^<xsl:value-of select="@type"/>.fromValue(new String(enumNames[kandid.util.CentralRandomizer.getInt(enumNames.length-1)])));
            }
          </xsl:if>
          <xsl:if test="not($enumvalues)">
            <xsl:if test="$javaReturnType = 'boolean'">
              <!-- basic data type is boolean -->
              aGene.set^<xsl:value-of select="@name"/>(kandid.util.CentralRandomizer.getBoolean(probability));
            </xsl:if>
            <xsl:if test="$javaReturnType = 'int'">
              <!-- basic data type is int -->
              <xsl:variable name="minInclusive" select="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:restriction/xsd:minInclusive/@value"/>
              <xsl:variable name="maxInclusive" select="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:restriction/xsd:maxInclusive/@value"/>
              <xsl:if test="$minInclusive and $maxInclusive">
                  aGene.set^<xsl:value-of select="@name"/>(kandid.util.CentralRandomizer.getInt(<xsl:value-of select="$minInclusive"/>, <xsl:value-of select="$maxInclusive"/>));
              </xsl:if>
              <xsl:if test="not($minInclusive and $maxInclusive)">
                if(binomialRamdomizer)
                  aGene.set^<xsl:value-of select="@name"/>(minInclusive+kandid.util.CentralRandomizer.getBinomial(maxInclusive-minInclusive, binomialProbability));
                else
                  aGene.set^<xsl:value-of select="@name"/>(kandid.util.CentralRandomizer.getInt(minInclusive, maxInclusive));
              </xsl:if>
            </xsl:if>
            <xsl:if test="$javaReturnType = 'long'">
              <!-- basic data type is long -->
              aGene.set^<xsl:value-of select="@name"/>(kandid.util.CentralRandomizer.getLong());
            </xsl:if>
            <xsl:if test="$javaReturnType = 'float'">
              <!-- basic data type is double -->
              <xsl:variable name="minInclusive" select="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:restriction/xsd:minInclusive/@value"/>
              <xsl:variable name="maxInclusive" select="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:restriction/xsd:maxInclusive/@value"/>
              <xsl:if test="$minInclusive and $maxInclusive">
                aGene.set^<xsl:value-of select="@name"/>(kandid.util.CentralRandomizer.getFloat((float)<xsl:value-of select="$minInclusive"/>, (float)<xsl:value-of select="$maxInclusive"/>));
              </xsl:if>
              <xsl:if test="not($minInclusive and $maxInclusive)">
                aGene.set^<xsl:value-of select="@name"/>(kandid.util.CentralRandomizer.getFloat((float)minInclusive, (float)maxInclusive));
              </xsl:if>
            </xsl:if>
            <xsl:if test="$javaReturnType = 'double'">
              <!-- basic data type is double -->
              <xsl:variable name="minInclusive" select="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:restriction/xsd:minInclusive/@value"/>
              <xsl:variable name="maxInclusive" select="/xsd:schema/xsd:simpleType[@name=$schemaBaseType]/xsd:restriction/xsd:maxInclusive/@value"/>
              <xsl:if test="$minInclusive and $maxInclusive">
                aGene.set^<xsl:value-of select="@name"/>(kandid.util.CentralRandomizer.getDouble(<xsl:value-of select="$minInclusive"/>, <xsl:value-of select="$maxInclusive"/>));
              </xsl:if>
              <xsl:if test="not($minInclusive and $maxInclusive)">
                aGene.set^<xsl:value-of select="@name"/>(kandid.util.CentralRandomizer.getDouble(minInclusive, maxInclusive));
              </xsl:if>
            </xsl:if>
          </xsl:if>
        </xsl:if>
        <xsl:if test="contains($schemaBaseType, 'Gene')">
          <xsl:if test="@minOccurs and @maxOccurs">
            <!-- member is list of children of class class gen -->
            <xsl:call-template name="list">
              <xsl:with-param name="aObject">aGene</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
          <xsl:if test="not(@maxOccurs)">
            <!-- members are childs of class class gen -->
            ^<xsl:value-of select="@type"/> a^<xsl:value-of select="@name"/> = objectFactory.create^<xsl:value-of select="@type"/>();
            <xsl:if test="@kandid:minInclusive and @kandid:maxInclusive">
            //xx
              randomize(a^<xsl:value-of select="@name"/>, <xsl:value-of select="@kandid:minInclusive"/>, <xsl:value-of select="@kandid:maxInclusive"/>, aChromosome, false, 0.0, depth+1);
            </xsl:if>
            <xsl:if test="not(@kandid:minInclusive and @kandid:maxInclusive)">
              <xsl:variable name="probability" select="@kandid:probability"/>
              <xsl:if test="$probability">
                randomize(a^<xsl:value-of select="@name"/>, aChromosome, <xsl:value-of select="$probability"/>, depth+1);
              </xsl:if>
              <xsl:if test="not($probability)">
                randomize(a^<xsl:value-of select="@name"/>, aChromosome, depth+1);
              </xsl:if>
            </xsl:if>
            aGene.set^<xsl:value-of select="@name"/>(a^<xsl:value-of select="@name"/>);
          </xsl:if>
        </xsl:if>
        </xsl:if>
      </xsl:for-each>
    </xsl:if>
    }
  </xsl:if>

  <xsl:if test="contains(@name, 'Chromosome')">
    public void randomize(^<xsl:value-of select="@name"/> aChromosome) throws JAXBException {
    <!-- call randomizer for super class -->
    <xsl:for-each select="descendant::xsd:extension">
      <xsl:if test="not((@base = 'chromosomeType') or (@base = 'coloratorType'))">
        randomize((^<xsl:value-of select="@base"/>)aChromosome);
      </xsl:if>
    </xsl:for-each>
    <!-- randomize elements -->
    <xsl:for-each select="descendant::xsd:element">
      <xsl:variable name="schemaBaseType" select="@type"/>
      <xsl:if test="contains($schemaBaseType, 'Gene')">
        <xsl:if test="@minOccurs and @maxOccurs">
          <!-- member is list of children of class class gen -->
          <xsl:call-template name="list">
            <xsl:with-param name="aObject">aChromosome</xsl:with-param>
          </xsl:call-template>
        </xsl:if>
        <xsl:if test="not(@maxOccurs)">
          <!-- members are childs of class class gen -->
          ^<xsl:value-of select="@type"/> a^<xsl:value-of select="@name"/> = objectFactory.create^<xsl:value-of select="@type"/>();
          <xsl:if test="@kandid:minInclusive and @kandid:maxInclusive">
            <xsl:if test="@kandid:ramdomizer and @kandid:binomialProbability">
              randomize(a^<xsl:value-of select="@name"/>, <xsl:value-of select="@kandid:minInclusive"/>, <xsl:value-of select="@kandid:maxInclusive"/>, aChromosome, true, <xsl:value-of select="@kandid:binomialProbability"/>, 1);
            </xsl:if>
            <xsl:if test="not(@kandid:ramdomizer and @kandid:binomialProbability)">
              randomize(a^<xsl:value-of select="@name"/>, <xsl:value-of select="@kandid:minInclusive"/>, <xsl:value-of select="@kandid:maxInclusive"/>, aChromosome, false, 0.0, 1);
            </xsl:if>
          </xsl:if>
          <xsl:if test="not(@kandid:minInclusive and @kandid:maxInclusive)">
            <xsl:if test="@type = 'booleanGene'">
              randomize(a^<xsl:value-of select="@name"/>, aChromosome, 0.5, 1);
            </xsl:if>
            <xsl:if test="not(@type = 'booleanGene')">
              randomize(a^<xsl:value-of select="@name"/>, aChromosome, 1);
            </xsl:if>
          </xsl:if>
          aChromosome.set^<xsl:value-of select="@name"/>(a^<xsl:value-of select="@name"/>);
        </xsl:if>
      </xsl:if>
    </xsl:for-each>
    }
  </xsl:if>
</xsl:template>

<xsl:template name="list">
  <xsl:param name="aObject">aGene</xsl:param>
  <!-- member is list of children of class class gen -->
  {
  java.util.List list = <xsl:value-of select="$aObject"/>.get^<xsl:value-of select="@name"/>();
  list.clear();
  
  <xsl:choose>
    <xsl:when test="@kandid:initialLength">
      int newLength = <xsl:value-of select="@kandid:initialLength"/>;
    </xsl:when>
    <xsl:when test="@kandid:ramdomizer and @kandid:binomialProbability">
      int newLength = <xsl:value-of select="@minOccurs"/>+kandid.util.CentralRandomizer.getBinomial(<xsl:value-of select="@maxOccurs"/>-<xsl:value-of select="@minOccurs"/>, <xsl:value-of select="@kandid:binomialProbability"/>);
    </xsl:when>
    <xsl:otherwise>
      int newLength = kandid.util.CentralRandomizer.getInt(<xsl:value-of select="@minOccurs"/>, <xsl:value-of select="@maxOccurs"/>);
    </xsl:otherwise>
  </xsl:choose>
  while(newLength > 0) {
    ^<xsl:value-of select="@type"/> a^<xsl:value-of select="@name"/> = objectFactory.create^<xsl:value-of select="@type"/>();
    randomize(a^<xsl:value-of select="@name"/>, aChromosome, 1);
    list.add(a^<xsl:value-of select="@name"/>);
    --newLength;
  }
  }
</xsl:template>

<xsl:template match="*">
</xsl:template>

</xsl:stylesheet>
