/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.soup.helper;
import java.io.*;

public class InsertRootElement {
  public static void insert(Reader ir, Writer out) {
    try {
      LineNumberReader in = new LineNumberReader(ir);
      String lineIn;

      while ((lineIn = in.readLine()) != null) {
        if ((out != null) && (lineIn != null)) {
          lineIn = lineIn.trim();

          if (lineIn.length() > 0) {
            String lineOut = new String(lineIn);
            lineOut = lineOut.replace("@XmlType(name = \"entityType\", propOrder = {",
                                      "@javax.xml.bind.annotation.XmlRootElement\n@XmlType(name = \"entityType\", propOrder = {");
            lineOut = lineOut.replace("@XmlType(name = \"populationType\", propOrder = {",
                                      "@javax.xml.bind.annotation.XmlRootElement\n@XmlType(name = \"populationType\", propOrder = {");
            lineOut = lineOut.replace("@XmlType(name = \"preferenceType\", propOrder = {",
                                      "@javax.xml.bind.annotation.XmlRootElement\n@XmlType(name = \"preferenceType\", propOrder = {");

            out.write(lineOut, 0, lineOut.length());
            out.write("\n", 0, 1);
          }
        }
      }

      in.close();

      if (out != null) {
        out.close();
      }
    } catch (IOException exc) {
      exc.printStackTrace();
    }
  }

  public static void main(String[] args) {
    try {
      Reader in;
      Writer out;

      if (args.length == 0) {
        in = new InputStreamReader(System.in);
      } else {
        in = new FileReader(args[0]);
      }

      if (args.length == 0) {
        out = new OutputStreamWriter(System.out);
      } else {
        out = new FileWriter(args[1]);
      }

      InsertRootElement.insert(in, out);
    } catch (IOException exc) {
      exc.printStackTrace();
    }
  }
}
