package kandid.soup.genetic.voronoi;

import java.util.List;

import kandid.soup.ColorGene;
import kandid.soup.DistanceFunctionBase;
import kandid.soup.DistanceFunctionGene;
import kandid.soup.KingGene;
import kandid.soup.NormalizedGene;
import kandid.soup.ObjectFactory;
import kandid.soup.RandomWalkPointGene;
import kandid.soup.SymmetricGene;
import kandid.soup.VoronoiChromosomeBase;

public class RandomizerBase {
  protected static ObjectFactory objectFactory = new ObjectFactory();

  public static VoronoiChromosomeBase create() {
    VoronoiChromosomeBase chromosome = objectFactory.createVoronoiChromosomeBase();
    randomize_members(chromosome);
    return chromosome;
  }

  protected static void randomize_members(VoronoiChromosomeBase chromosome) {
    List<DistanceFunctionGene> dist = chromosome.getDistance();
    int len = kandid.util.CentralRandomizer.getInt(1, 8);
    while (len > 0) {
      dist.add(randomize_distance());
      --len;
    }
    
    List<KingGene> kings = chromosome.getKing();
    len = kandid.util.CentralRandomizer.getInt(2, 50);
    while (len > 0) {
      kings.add(randomize_king());
      --len;
    }
  }

  static DistanceFunctionGene randomize_distance() {
    DistanceFunctionBase[] possible_distance = DistanceFunctionBase.values();
    DistanceFunctionBase new_distance = possible_distance[kandid.util.CentralRandomizer.getInt(possible_distance.length - 1)];
    DistanceFunctionGene new_distance_gene = objectFactory.createDistanceFunctionGene();
    new_distance_gene.setDistanceFunction(new_distance);
    
    SymmetricGene weight = objectFactory.createSymmetricGene();
    weight.setValue(kandid.util.CentralRandomizer.getDouble(-1.0, 1.0));
    new_distance_gene.setWeight(weight);
    return new_distance_gene;
  }

  static KingGene randomize_king() {
    KingGene king = objectFactory.createKingGene();
    king.setPoint(randomize_point());
    king.setColor(randomize_color());
    king.setWeight(randomize_weight());
    return king;
    
  }

  private static NormalizedGene randomize_weight() {
    NormalizedGene new_weight = objectFactory.createNormalizedGene();
    new_weight.setValue(kandid.util.CentralRandomizer.getDouble(1.0));
    return new_weight;
  }

  private static ColorGene randomize_color() {
    ColorGene new_color = objectFactory.createColorGene();
    new_color.setRed((float)kandid.util.CentralRandomizer.getDouble(1.0));
    new_color.setGreen((float)kandid.util.CentralRandomizer.getDouble(1.0));
    new_color.setBlue((float)kandid.util.CentralRandomizer.getDouble(1.0));
    return new_color;
  }

  private static RandomWalkPointGene randomize_point() {
    RandomWalkPointGene new_point = objectFactory.createRandomWalkPointGene();
    double  radius = kandid.util.CentralRandomizer.getDouble(1.0);
    double  angle  = kandid.util.CentralRandomizer.getDouble(-Math.PI, Math.PI);
    new_point.setX(radius * Math.cos(angle));
    new_point.setY(radius * Math.sin(angle));
    return new_point;
  }

}
