package kandid.soup.genetic.voronoi;

import kandid.Environment;
import kandid.soup.DoubleGene;
import kandid.soup.IntegerGene;
import kandid.soup.VoronoiTransparentChromosome;

public class MutatorTransparent extends MutatorBase {
  
  public static int mutate(Environment env, VoronoiTransparentChromosome chromosome) {
    int mutationCounter = MutatorBase.mutate_members(env, chromosome);

    mutationCounter += mutate_IntegerGene(env, chromosome.getPrioritySize(), 2, 10);
    mutationCounter += mutate_DoubleGene(env, chromosome.getPriorityWeight(), 0.5, 2.0);

    return mutationCounter;
  }

  private static int mutate_DoubleGene(Environment env, DoubleGene gene, double minInclusive, double maxInclusive) {
    int mutationCounter = 0;
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      double oldValue = gene.getValue();
      double newValue = oldValue + env.getScaleFactor() * kandid.util.CentralRandomizer.getGaussian();
      if (newValue < minInclusive)
        newValue = minInclusive;
      else if (newValue > maxInclusive)
        newValue = maxInclusive;
      gene.setValue(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
    }
    return mutationCounter;
  }
  
  private static int mutate_IntegerGene(Environment env, IntegerGene gene, int minInclusive, int maxInclusive) {
    int mutationCounter = 0;
    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
      int oldValue = gene.getValue();
      int newValue = oldValue + (kandid.util.CentralRandomizer.getBoolean() ? 1 : -1);
      if (newValue < minInclusive)
        newValue = minInclusive;
      else if (newValue > maxInclusive)
        newValue = maxInclusive;
      gene.setValue(newValue);
      mutationCounter += oldValue != newValue ? 1 : 0;
    }
    return mutationCounter;
  }

//  private static int mutate_members(Environment env, VoronoiChromosome chromosome) {
//    int mutationCounter = 0;
//    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
//      mutationCounter += mutate_SymmetricGene(env, chromosome.getYard());
//    }
//    
//    List<DistanceFunctionGene> dist = chromosome.getDistance();
//    int len = dist.size();
//    for(int di=0; di<len; ++di) {
//      if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
//        mutationCounter += mutate_distance(env, dist.get(di));
//      }
//    }
//    if (dist.size() > Configuration.minOccursDistance+1 && kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
//      dist.remove(kandid.util.CentralRandomizer.getInt(0, dist.size()-1));
//      ++mutationCounter;
//    }
//    else if (dist.size() < Configuration.maxOccursDistance-1 && kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
//      dist.add(Randomizer.randomize_distance());
//      ++mutationCounter;
//    }
//
//    List<KingGene> kings = chromosome.getKing();
//    len = kings.size();
//    for(int di=0; di<len; ++di) {
//      if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
//        mutationCounter += mutate_king(env,kings.get(di));
//      }
//    }
//    if (kings.size() > Configuration.minOccursKings+1 && kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
//      kings.remove(kandid.util.CentralRandomizer.getInt(0, kings.size()-1));
//      ++mutationCounter;
//    }
//    else if (kings.size() < Configuration.maxOccursKings-1 && kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
//      kings.add(Randomizer.randomize_king());
//      ++mutationCounter;
//    }
//    return mutationCounter;
//  }
//
//  private static int mutate_king(Environment env, KingGene kingGene) {
//    int mutationCounter = 0;
//    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
//      mutate_point(env, kingGene.getPoint());
//      mutationCounter += 1;
//    }
//    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
//      mutationCounter += mutate_color(env, kingGene.getColor());
//    }
//    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
//      mutationCounter += mutate_NormalizedGene(env, kingGene.getWeight());
//    }
//    return mutationCounter;
//  }
//
//  private static int mutate_color(Environment env, ColorGene color) {
//    int mutationCounter = 0;
//    
//    kandid.colorator.ColorF32 rgb = new kandid.colorator.ColorF32(color.getRed(), color.getGreen(), color.getBlue());
//    kandid.colorator.ColorF32 hsb = new kandid.colorator.ColorF32();
//    kandid.colorator.ColorF32 old = new kandid.colorator.ColorF32();
//    kandid.colorator.ColorF32.rgb2hsb(rgb, hsb);
//    kandid.colorator.ColorF32.copy(rgb, old);
//    double  scale = env.getScaleFactor();
//    // hue
//    hsb.r   = hsb.r + (float)(scale * kandid.util.CentralRandomizer.getGaussian());
//    while(hsb.r < 0.0) {
//      hsb.r += 1.0;
//    }
//    while(hsb.r > 1.0) {
//      hsb.r -= 1.0;
//    }
//    // saturation
//    hsb.g = hsb.g + (float)(scale * kandid.util.CentralRandomizer.getGaussian());
//    if (hsb.g < 0.0) {
//      hsb.g = 0.0f;
//    }
//    else if (hsb.g > 1.0) {
//      hsb.g = 1.0f;
//    }
//    // brightness
//    hsb.b = hsb.b + (float)(scale * kandid.util.CentralRandomizer.getGaussian());
//    if (hsb.b < 0.0) {
//      hsb.b = 0.0f;
//    }
//    else if (hsb.b > 1.0) {
//      hsb.b = 1.0f;
//    }
//    kandid.colorator.ColorF32.hsb2rgb(hsb, rgb);
//    color.setRed(rgb.r);
//    color.setGreen(rgb.g);
//    color.setBlue(rgb.b);
//    mutationCounter += ((old.r != rgb.r) || (old.g != rgb.g) || (old.b != rgb.b)) ? 1 : 0;
//
//    return mutationCounter;
//  }
//
//  private static void mutate_point(Environment env, RandomWalkPointGene point) {
//    double  radius = kandid.util.CentralRandomizer.getDouble(env.getScaleFactor());
//    double  angle  = kandid.util.CentralRandomizer.getDouble(-Math.PI, Math.PI);
//    point.setX(point.getX() + radius * Math.cos(angle));
//    point.setY(point.getY() + radius * Math.sin(angle));
//  }
//
//  private static int mutate_distance(Environment env, DistanceFunctionGene distanceFunctionGene) {
//    int mutationCounter = 0;
//    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
//      DistanceFunctionBase old_var = distanceFunctionGene.getDistanceFunction();
//      DistanceFunctionBase[] possible_vars = DistanceFunctionBase.values();
//      DistanceFunctionBase new_var = possible_vars[kandid.util.CentralRandomizer.getInt(possible_vars.length - 1)];
//      distanceFunctionGene.setDistanceFunction(new_var);
//      mutationCounter += old_var != new_var ? 1 : 0;
//    }
//    return mutationCounter;
//  }
//
//  private static int mutate_SymmetricGene(Environment env, SymmetricGene gene) {
//    int mutationCounter = 0;
//    if (kandid.util.CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
//      double oldValue = gene.getValue();
//      double newValue = oldValue + env.getScaleFactor() * kandid.util.CentralRandomizer.getGaussian();
//      if (newValue < Configuration.minInclusiveSymmetric)
//        newValue = Configuration.minInclusiveSymmetric;
//      else if (newValue > Configuration.maxInclusiveSymmetric)
//        newValue = Configuration.maxInclusiveSymmetric;
//      gene.setValue(newValue);
//      mutationCounter += oldValue != newValue ? 1 : 0;
//    }
//    return mutationCounter;
//  }

}
