package kandid.soup.genetic.voronoi;

import kandid.Environment;
import kandid.soup.DoubleGene;
import kandid.soup.IntegerGene;
import kandid.soup.VoronoiTransparentChromosome;

public class MergerTransparent extends MergerBase {
  
  public static VoronoiTransparentChromosome merge(Environment env, VoronoiTransparentChromosome chromosome1, VoronoiTransparentChromosome chromosome2) {
    VoronoiTransparentChromosome new_chromosome = MergerBase.objectFactory.createVoronoiTransparentChromosome();
    MergerBase.merge_members(env, chromosome1, chromosome2, new_chromosome);
    
    new_chromosome.setPriorityWeight(merge_DoubleGene(env, chromosome1.getPriorityWeight(), chromosome2.getPriorityWeight()));
    new_chromosome.setPrioritySize(merge_IntegerGene(env, chromosome1.getPrioritySize(), chromosome2.getPrioritySize()));
    return new_chromosome;
  }

  private static DoubleGene merge_DoubleGene(Environment env, DoubleGene priorityWeight1, DoubleGene priorityWeight2) {
    double value;
    if (env.isSource1()) {
      value = priorityWeight1.getValue();
    }
    else {
      value = priorityWeight2.getValue();
    }
    DoubleGene new_gen = ClonerBase.objectFactory.createDoubleGene();
    new_gen.setValue(Double.valueOf(value));
    return new_gen;
  }

  private static IntegerGene merge_IntegerGene(Environment env, IntegerGene prioritySize1, IntegerGene prioritySize2) {
    int value;
    if (env.isSource1()) {
      value = prioritySize1.getValue();
    }
    else {
      value = prioritySize2.getValue();
    }
    IntegerGene new_gen = ClonerBase.objectFactory.createIntegerGene();
    new_gen.setValue(Integer.valueOf(value));
    return new_gen;
  }

//  private static void merge_members(Environment env, VoronoiChromosome chromosome1, VoronoiChromosome chromosome2, VoronoiChromosome new_chromosome) {
//    new_chromosome.setYard(merge_SymmetricGene(env, chromosome1.getYard(), chromosome2.getYard()));
//    
//    List<DistanceFunctionGene> dist1 = chromosome1.getDistance();
//    int length1 = dist1.size();
//    List<DistanceFunctionGene> dist2 = chromosome2.getDistance();
//    int length2 = dist2.size();
//    int commonLength = length1 < length2 ? length1 : length2;
//    for(int di=0; di<commonLength; ++di) {
//      new_chromosome.getDistance().add(merge_distance(env, dist1.get(di), dist2.get(di)));
//    }
//
//    List<KingGene> kings1 = chromosome1.getKing();
//    length1 = kings1.size();
//    List<KingGene> kings2 = chromosome2.getKing();
//    length2 = kings2.size();
//    commonLength = length1 < length2 ? length1 : length2;
//    for(int di=0; di<commonLength; ++di) {
//      new_chromosome.getKing().add(merge_king(env, kings1.get(di), kings2.get(di)));
//    }
//  }
//
//  private static KingGene merge_king(Environment env, KingGene kingGene1, KingGene kingGene2) {
//    KingGene new_king = objectFactory.createKingGene();
//    new_king.setPoint(merge_point(env, kingGene1.getPoint(), kingGene2.getPoint()));
//    new_king.setColor(merge_color(env, kingGene1.getColor(), kingGene2.getColor()));
//    new_king.setWeight(merge_NormalizedGene(env, kingGene1.getWeight(), kingGene2.getWeight()));
//    return new_king;
//  }
//
//  private static ColorGene merge_color(Environment env, ColorGene color1, ColorGene color2) {
//    float red, green, blue;
//    if(env.isSource1()) {
//      red   = color1.getRed();
//      green = color1.getGreen();
//      blue  = color1.getBlue();
//    }
//    else {
//      red   = color2.getRed();
//      green = color2.getGreen();
//      blue  = color2.getBlue();
//    }
//    ColorGene new_color = objectFactory.createColorGene();
//    new_color.setRed(Float.valueOf(red));
//    new_color.setGreen(Float.valueOf(green));
//    new_color.setBlue(Float.valueOf(blue));
//    return new_color;
//  }
//
//  private static RandomWalkPointGene merge_point(Environment env, RandomWalkPointGene point1, RandomWalkPointGene point2) {
//    double x, y;
//    if(env.isSource1()) {
//      x = point1.getX();
//      y = point1.getY();
//    }
//    else {
//      x = point2.getX();
//      y = point2.getY();
//    }
//    RandomWalkPointGene new_point = objectFactory.createRandomWalkPointGene();
//    new_point.setX(Double.valueOf(x));
//    new_point.setY(Double.valueOf(y));
//    return new_point;
//  }
//
//  private static DistanceFunctionGene merge_distance(Environment env, DistanceFunctionGene distanceFunctionGene1, DistanceFunctionGene distanceFunctionGene2) {
//    String value;
//    if(env.isSource1()) {
//      value = distanceFunctionGene1.getDistanceFunction().value();
//    }
//    else {
//      value = distanceFunctionGene2.getDistanceFunction().value();
//    }
//    DistanceFunctionGene new_dist = objectFactory.createDistanceFunctionGene();
//    new_dist.setDistanceFunction(DistanceFunctionBase.fromValue(value));
//    new_dist.setWeight(merge_SymmetricGene(env, distanceFunctionGene1.getWeight(), distanceFunctionGene2.getWeight()));
//    return new_dist;
//  }
//
//  private static SymmetricGene merge_SymmetricGene(Environment env, SymmetricGene gene1, SymmetricGene gene2) {
//    double value;
//    if(env.isSource1()) {
//      value = gene1.getValue();
//    }
//    else {
//      value = gene2.getValue();
//    }
//    SymmetricGene new_gene = objectFactory.createSymmetricGene();
//    new_gene.setValue(Double.valueOf(value));
//    return new_gene;
//  }
//
//  private static NormalizedGene merge_NormalizedGene(Environment env, NormalizedGene gene1, NormalizedGene gene2) {
//    double value;
//    if(env.isSource1()) {
//      value = gene1.getValue();
//    }
//    else {
//      value = gene2.getValue();
//    }
//    NormalizedGene new_gen = objectFactory.createNormalizedGene();
//    new_gen.setValue(Double.valueOf(value));
//    return new_gen;
//  }

}
