package kandid.soup.genetic.voronoi;

import java.util.List;

import kandid.Environment;
import kandid.soup.ColorGene;
import kandid.soup.DistanceFunctionBase;
import kandid.soup.DistanceFunctionGene;
import kandid.soup.KingGene;
import kandid.soup.NormalizedGene;
import kandid.soup.ObjectFactory;
import kandid.soup.RandomWalkPointGene;
import kandid.soup.SymmetricGene;
import kandid.soup.VoronoiChromosomeBase;

public class MergerBase {
  protected static ObjectFactory objectFactory = new ObjectFactory();
  
  public static VoronoiChromosomeBase merge(Environment env, VoronoiChromosomeBase chromosome1, VoronoiChromosomeBase chromosome2) {
    VoronoiChromosomeBase new_chromosome = objectFactory.createVoronoiChromosomeBase();
    merge_members(env, chromosome1, chromosome2, new_chromosome);
    return new_chromosome;
  }

  protected static void merge_members(Environment env, VoronoiChromosomeBase chromosome1, VoronoiChromosomeBase chromosome2, VoronoiChromosomeBase new_chromosome) {
    List<DistanceFunctionGene> dist1 = chromosome1.getDistance();
    int length1 = dist1.size();
    List<DistanceFunctionGene> dist2 = chromosome2.getDistance();
    int length2 = dist2.size();
    int commonLength = length1 < length2 ? length1 : length2;
    for(int di=0; di<commonLength; ++di) {
      new_chromosome.getDistance().add(merge_distance(env, dist1.get(di), dist2.get(di)));
    }

    List<KingGene> kings1 = chromosome1.getKing();
    length1 = kings1.size();
    List<KingGene> kings2 = chromosome2.getKing();
    length2 = kings2.size();
    commonLength = length1 < length2 ? length1 : length2;
    for(int di=0; di<commonLength; ++di) {
      new_chromosome.getKing().add(merge_king(env, kings1.get(di), kings2.get(di)));
    }
  }

  private static KingGene merge_king(Environment env, KingGene kingGene1, KingGene kingGene2) {
    KingGene new_king = objectFactory.createKingGene();
    new_king.setPoint(merge_point(env, kingGene1.getPoint(), kingGene2.getPoint()));
    new_king.setColor(merge_color(env, kingGene1.getColor(), kingGene2.getColor()));
    new_king.setWeight(merge_NormalizedGene(env, kingGene1.getWeight(), kingGene2.getWeight()));
    return new_king;
  }

  private static ColorGene merge_color(Environment env, ColorGene color1, ColorGene color2) {
    float red, green, blue;
    if(env.isSource1()) {
      red   = color1.getRed();
      green = color1.getGreen();
      blue  = color1.getBlue();
    }
    else {
      red   = color2.getRed();
      green = color2.getGreen();
      blue  = color2.getBlue();
    }
    ColorGene new_color = objectFactory.createColorGene();
    new_color.setRed(Float.valueOf(red));
    new_color.setGreen(Float.valueOf(green));
    new_color.setBlue(Float.valueOf(blue));
    return new_color;
  }

  private static RandomWalkPointGene merge_point(Environment env, RandomWalkPointGene point1, RandomWalkPointGene point2) {
    double x, y;
    if(env.isSource1()) {
      x = point1.getX();
      y = point1.getY();
    }
    else {
      x = point2.getX();
      y = point2.getY();
    }
    RandomWalkPointGene new_point = objectFactory.createRandomWalkPointGene();
    new_point.setX(Double.valueOf(x));
    new_point.setY(Double.valueOf(y));
    return new_point;
  }

  private static DistanceFunctionGene merge_distance(Environment env, DistanceFunctionGene distanceFunctionGene1, DistanceFunctionGene distanceFunctionGene2) {
    String value;
    if(env.isSource1()) {
      value = distanceFunctionGene1.getDistanceFunction().value();
    }
    else {
      value = distanceFunctionGene2.getDistanceFunction().value();
    }
    DistanceFunctionGene new_dist = objectFactory.createDistanceFunctionGene();
    new_dist.setDistanceFunction(DistanceFunctionBase.fromValue(value));
    new_dist.setWeight(merge_SymmetricGene(env, distanceFunctionGene1.getWeight(), distanceFunctionGene2.getWeight()));
    return new_dist;
  }

  protected static SymmetricGene merge_SymmetricGene(Environment env, SymmetricGene gene1, SymmetricGene gene2) {
    double value;
    if(env.isSource1()) {
      value = gene1.getValue();
    }
    else {
      value = gene2.getValue();
    }
    SymmetricGene new_gene = objectFactory.createSymmetricGene();
    new_gene.setValue(Double.valueOf(value));
    return new_gene;
  }

  private static NormalizedGene merge_NormalizedGene(Environment env, NormalizedGene gene1, NormalizedGene gene2) {
    double value;
    if(env.isSource1()) {
      value = gene1.getValue();
    }
    else {
      value = gene2.getValue();
    }
    NormalizedGene new_gen = objectFactory.createNormalizedGene();
    new_gen.setValue(Double.valueOf(value));
    return new_gen;
  }

}
