package kandid.soup.genetic.voronoi;

import kandid.soup.DoubleGene;
import kandid.soup.IntegerGene;
import kandid.soup.VoronoiChromosomeBase;
import kandid.soup.VoronoiTransparentChromosome;

public class ClonerTransparent extends VoronoiChromosomeBase {
  
  public static VoronoiTransparentChromosome deepclone(VoronoiTransparentChromosome chromosome1) {
    VoronoiTransparentChromosome new_chromosome = ClonerBase.objectFactory.createVoronoiTransparentChromosome();
    ClonerBase.deepclone_members(chromosome1, new_chromosome);
    
    new_chromosome.setPrioritySize(deepclone_IntegerGene(chromosome1.getPrioritySize()));
    new_chromosome.setPriorityWeight(deepclone_DoubleGene(chromosome1.getPriorityWeight()));
    return new_chromosome;
  }

  private static DoubleGene deepclone_DoubleGene(DoubleGene priorityWeight) {
    double value = priorityWeight.getValue();
    DoubleGene new_gen = ClonerBase.objectFactory.createDoubleGene();
    new_gen.setValue(Double.valueOf(value));
    return new_gen;
  }

  private static IntegerGene deepclone_IntegerGene(IntegerGene prioritySize) {
    int value = prioritySize.getValue();
    IntegerGene new_gen = ClonerBase.objectFactory.createIntegerGene();
    new_gen.setValue(Integer.valueOf(value));
    return new_gen;
  }

//  private static void deepclone_members(VoronoiChromosome chromosome1, VoronoiChromosome new_chromosome) {
//    new_chromosome.setYard(deepclone_SymmetricGene(chromosome1.getYard()));
//    
//    List<DistanceFunctionGene> dist = chromosome1.getDistance();
//    int len = dist.size();
//    for(int di=0; di<len; ++di) {
//      new_chromosome.getDistance().add(deepclone_distance(dist.get(di)));
//    }
//
//    List<KingGene> kings = chromosome1.getKing();
//    len = kings.size();
//    for(int di=0; di<len; ++di) {
//      new_chromosome.getKing().add(deepclone_king(kings.get(di)));
//    }
//  }
//
//  private static KingGene deepclone_king(KingGene kingGene) {
//    KingGene new_king = objectFactory.createKingGene();
//    new_king.setPoint(deepclone_point(kingGene.getPoint()));
//    new_king.setColor(deepclone_color(kingGene.getColor()));
//    new_king.setWeight(deepclone_NormalizedGene(kingGene.getWeight()));
//    return new_king;
//  }
//
//  private static ColorGene deepclone_color(ColorGene color) {
//    ColorGene new_color = objectFactory.createColorGene();
//    float red = color.getRed();
//    new_color.setRed(Float.valueOf(red));
//    float green = color.getGreen();
//    new_color.setGreen(Float.valueOf(green));
//    float blue = color.getBlue();
//    new_color.setBlue(Float.valueOf(blue));
//    return new_color;
//  }
//
//  private static RandomWalkPointGene deepclone_point(RandomWalkPointGene point) {
//    RandomWalkPointGene new_point = objectFactory.createRandomWalkPointGene();
//    double x = point.getX();
//    new_point.setX(Double.valueOf(x));
//    double y = point.getY();
//    new_point.setY(Double.valueOf(y));
//    return new_point;
//  }
//
//  private static DistanceFunctionGene deepclone_distance(DistanceFunctionGene distanceFunctionGene) {
//    DistanceFunctionGene new_dist = objectFactory.createDistanceFunctionGene();
//    String value = distanceFunctionGene.getDistanceFunction().value();
//    new_dist.setDistanceFunction(DistanceFunctionBase.fromValue(value));
//    new_dist.setWeight(deepclone_SymmetricGene(distanceFunctionGene.getWeight()));
//    return new_dist;
//  }
//
//  private static SymmetricGene deepclone_SymmetricGene(SymmetricGene gene) {
//    double value = gene.getValue();
//    SymmetricGene new_gene = objectFactory.createSymmetricGene();
//    new_gene.setValue(Double.valueOf(value));
//    return new_gene;
//  }
//
//  private static NormalizedGene deepclone_NormalizedGene(NormalizedGene gene) {
//    double value = gene.getValue();
//    NormalizedGene new_gen = objectFactory.createNormalizedGene();
//    new_gen.setValue(Double.valueOf(value));
//    return new_gen;
//  }
//
}
