package kandid.soup.genetic.voronoi;

import java.util.List;

import kandid.soup.ColorGene;
import kandid.soup.DistanceFunctionBase;
import kandid.soup.DistanceFunctionGene;
import kandid.soup.KingGene;
import kandid.soup.NormalizedGene;
import kandid.soup.ObjectFactory;
import kandid.soup.RandomWalkPointGene;
import kandid.soup.SymmetricGene;
import kandid.soup.VoronoiChromosomeBase;

public class ClonerBase {
  static ObjectFactory objectFactory = new ObjectFactory();
  
  public static VoronoiChromosomeBase deepclone(VoronoiChromosomeBase chromosome1) {
    VoronoiChromosomeBase new_chromosome = objectFactory.createVoronoiChromosomeBase();
    deepclone_members(chromosome1, new_chromosome);
    return new_chromosome;
  }

  protected static void deepclone_members(VoronoiChromosomeBase chromosome1, VoronoiChromosomeBase new_chromosome) {
    List<DistanceFunctionGene> dist = chromosome1.getDistance();
    int len = dist.size();
    for(int di=0; di<len; ++di) {
      new_chromosome.getDistance().add(deepclone_distance(dist.get(di)));
    }

    List<KingGene> kings = chromosome1.getKing();
    len = kings.size();
    for(int di=0; di<len; ++di) {
      new_chromosome.getKing().add(deepclone_king(kings.get(di)));
    }
  }

  protected static KingGene deepclone_king(KingGene kingGene) {
    KingGene new_king = objectFactory.createKingGene();
    new_king.setPoint(deepclone_point(kingGene.getPoint()));
    new_king.setColor(deepclone_color(kingGene.getColor()));
    new_king.setWeight(deepclone_NormalizedGene(kingGene.getWeight()));
    return new_king;
  }

  protected static ColorGene deepclone_color(ColorGene color) {
    ColorGene new_color = objectFactory.createColorGene();
    float red = color.getRed();
    new_color.setRed(Float.valueOf(red));
    float green = color.getGreen();
    new_color.setGreen(Float.valueOf(green));
    float blue = color.getBlue();
    new_color.setBlue(Float.valueOf(blue));
    return new_color;
  }

  protected static RandomWalkPointGene deepclone_point(RandomWalkPointGene point) {
    RandomWalkPointGene new_point = objectFactory.createRandomWalkPointGene();
    double x = point.getX();
    new_point.setX(Double.valueOf(x));
    double y = point.getY();
    new_point.setY(Double.valueOf(y));
    return new_point;
  }

  protected static DistanceFunctionGene deepclone_distance(DistanceFunctionGene distanceFunctionGene) {
    DistanceFunctionGene new_dist = objectFactory.createDistanceFunctionGene();
    String value = distanceFunctionGene.getDistanceFunction().value();
    new_dist.setDistanceFunction(DistanceFunctionBase.fromValue(value));
    new_dist.setWeight(deepclone_SymmetricGene(distanceFunctionGene.getWeight()));
    return new_dist;
  }

  protected static SymmetricGene deepclone_SymmetricGene(SymmetricGene gene) {
    double value = gene.getValue();
    SymmetricGene new_gene = objectFactory.createSymmetricGene();
    new_gene.setValue(Double.valueOf(value));
    return new_gene;
  }

  protected static NormalizedGene deepclone_NormalizedGene(NormalizedGene gene) {
    double value = gene.getValue();
    NormalizedGene new_gen = objectFactory.createNormalizedGene();
    new_gen.setValue(Double.valueOf(value));
    return new_gen;
  }

}
