package kandid.soup.genetic.vectorvm;

import java.util.List;

import kandid.soup.DoubleGene;
import kandid.soup.ExprVectorArgsListGene;
import kandid.soup.ExprVectorConstGene;
import kandid.soup.ExprVectorListGene;
import kandid.soup.ExprVectorOprBase;
import kandid.soup.ExprVectorOprGene;
import kandid.soup.ExprVectorVarBase;
import kandid.soup.ExprVectorVarGene;
import kandid.soup.GeneType;
import kandid.soup.ObjectFactory;
import kandid.soup.VectorExprGene;
import kandid.soup.VectorExpressionChromosome;
import kandid.soup.SeedGene;

public class Cloner {
  private static ObjectFactory objectFactory = new ObjectFactory();

  public static VectorExpressionChromosome deepclone(VectorExpressionChromosome chromosome1) {
    System.out.println("deepclone chromosome1 " + chromosome1.getClass().getSimpleName() + " " + chromosome1);
    VectorExpressionChromosome new_chromosome = objectFactory.createVectorExpressionChromosome();
    new_chromosome.setNoiseSeed(deepclone(chromosome1.getNoiseSeed()));
    new_chromosome.setVectorExpression(deepclone(chromosome1.getVectorExpression()));
    return new_chromosome;
  }

  private static SeedGene deepclone(SeedGene gene1) {
    SeedGene new_noiseSeed = objectFactory.createSeedGene();
    long seed = gene1.getValue().longValue();
    new_noiseSeed.setValue(Long.valueOf(seed));
    return new_noiseSeed;
  }

  public static VectorExprGene deepclone(VectorExprGene gene1) {
    VectorExprGene new_scalarExpression = objectFactory.createVectorExprGene();
    ExprVectorListGene scalarList1 = gene1.getList();
    
    ExprVectorListGene new_list = objectFactory.createExprVectorListGene();
    new_scalarExpression.setList(new_list);

    ExprVectorOprGene new_opr = objectFactory.createExprVectorOprGene();
    ExprVectorOprGene opr1 = scalarList1.getOpr();
    String opr_value = opr1.getVectorOpr().value();
    new_opr.setVectorOpr(ExprVectorOprBase.fromValue(opr_value));
    new_list.setOpr(new_opr);

    ExprVectorArgsListGene new_args = objectFactory.createExprVectorArgsListGene();
    new_list.setArgs(new_args);
    
    List<GeneType> vce1_list = scalarList1.getArgs().getVarOrConstOrVectorExpression();
    int length1 = vce1_list.size();
    for(int ci=0; ci<length1; ++ci) {
//    * {@link ExprVectorVarGene }
//    * {@link ExprVectorConstGene }
//    * {@link VectorExprGene }
      GeneType vce1 = vce1_list.get(ci);
      if(vce1 instanceof ExprVectorVarGene) {
        ExprVectorVarGene vce1_var_gene = (ExprVectorVarGene)vce1;
        add_var_gene(new_args, vce1_var_gene);
      }
      else if(vce1 instanceof ExprVectorConstGene) {
        ExprVectorConstGene vce1_const_gene = (ExprVectorConstGene)vce1;
        add_const_gene(new_args, vce1_const_gene);
      }
      else if(vce1 instanceof VectorExprGene) {
        VectorExprGene new_expr_gene = deepclone(((VectorExprGene)vce1));
        new_args.getVarOrConstOrVectorExpression().add(new_expr_gene);
      }
      else {
        assert false : "no strategy for cloning " + vce1.getClass().getName();
      }
    }
    return new_scalarExpression;
  }

  public static void add_const_gene(ExprVectorArgsListGene new_args, ExprVectorConstGene vce1_const_gene) {
    ExprVectorConstGene new_cnst_gene = objectFactory.createExprVectorConstGene();
    {
    DoubleGene new_dbl_cnst = objectFactory.createDoubleGene();
    vce1_const_gene.getCx();
    double value = vce1_const_gene.getCx().getValue();
    new_dbl_cnst.setValue(Double.valueOf(value));
    new_cnst_gene.setCx(new_dbl_cnst);
    }
    {
    DoubleGene new_dbl_cnst = objectFactory.createDoubleGene();
    vce1_const_gene.getCy();
    double value = vce1_const_gene.getCx().getValue();
    new_dbl_cnst.setValue(Double.valueOf(value));
    new_cnst_gene.setCy(new_dbl_cnst);
    }
    {
    DoubleGene new_dbl_cnst = objectFactory.createDoubleGene();
    vce1_const_gene.getCz();
    double value = vce1_const_gene.getCx().getValue();
    new_dbl_cnst.setValue(Double.valueOf(value));
    new_cnst_gene.setCz(new_dbl_cnst);
    }
    new_args.getVarOrConstOrVectorExpression().add(new_cnst_gene);
  }

  public static void add_var_gene(ExprVectorArgsListGene new_args, ExprVectorVarGene vce1_var_gene) {
    ExprVectorVarGene new_var_gene = objectFactory.createExprVectorVarGene();
    String value = vce1_var_gene.getVectorVar().value();
    new_var_gene.setVectorVar(ExprVectorVarBase.fromValue(value));
    new_args.getVarOrConstOrVectorExpression().add(new_var_gene);
  }

}
