package kandid.soup.genetic.scalarvm;

import java.util.List;

import kandid.soup.DoubleGene;
import kandid.soup.ExprScalarArgsListGene;
import kandid.soup.ExprScalarConstGene;
import kandid.soup.ExprScalarListGene;
import kandid.soup.ExprScalarOprBase;
import kandid.soup.ExprScalarOprGene;
import kandid.soup.ExprScalarVarBase;
import kandid.soup.ExprScalarVarGene;
import kandid.soup.GeneType;
import kandid.soup.ObjectFactory;
import kandid.soup.ScalarExprGene;
import kandid.soup.ScalarExpressionChromosome;
import kandid.soup.SeedGene;

public class Randomizer {
  private static ObjectFactory objectFactory = new ObjectFactory();

  public static ScalarExpressionChromosome create() {
    ScalarExpressionChromosome chromosome = objectFactory.createScalarExpressionChromosome();

    ScalarExprGene new_scalarExpression = objectFactory.createScalarExprGene();
    randomize(new_scalarExpression, 1);
    chromosome.setScalarExpression(new_scalarExpression);
    
    SeedGene new_noiseSeed = objectFactory.createSeedGene();
    new_noiseSeed.setValue(kandid.util.CentralRandomizer.getLong());
    chromosome.setNoiseSeed(new_noiseSeed);

    return chromosome;
  }

  static void randomize(ScalarExprGene aScalarExpression, int depth) {
    ExprScalarListGene new_list = objectFactory.createExprScalarListGene();
    aScalarExpression.setList(new_list);
    new_list.setOpr(randomize_opr());
    new_list.setArgs(randomize_argslist(depth + 1));
  }

  private static ExprScalarArgsListGene randomize_argslist(int depth) {
    ExprScalarArgsListGene new_argslist = objectFactory.createExprScalarArgsListGene();
    List<GeneType> vce1_list = new_argslist.getVarOrConstOrScalarExpression();
    int len = kandid.util.CentralRandomizer.getInt(Configuration.minOccurs, Configuration.maxOccurs);
    while (len > 0) {
      switch (kandid.util.CentralRandomizer.getInt(1, 3)) {
      case 1:
        vce1_list.add(randomize_var());
        --len;
        break;
      case 2:
        vce1_list.add(randomize_const());
        --len;
        break;
      case 3:
        if (kandid.util.CentralRandomizer.getDouble(0.0, 0.15) < (1.0 / depth)) {
          ScalarExprGene new_scalar_expression = objectFactory.createScalarExprGene();
          randomize(new_scalar_expression, depth + 1);
          vce1_list.add(new_scalar_expression);
          --len;
        }
        break;
      }
    }
    return new_argslist;
  }

  static ExprScalarConstGene randomize_const() {
    ExprScalarConstGene new_const = objectFactory.createExprScalarConstGene();
    DoubleGene new_double = objectFactory.createDoubleGene();
    new_double.setValue(kandid.util.CentralRandomizer.getDouble(Configuration.minInclusive, Configuration.maxInclusive));
    new_const.setScalarConst(new_double);
    return new_const;
  }

  static ExprScalarVarGene randomize_var() {
    ExprScalarVarBase[] possible_vars = ExprScalarVarBase.values();
    ExprScalarVarBase new_var = possible_vars[kandid.util.CentralRandomizer.getInt(possible_vars.length - 1)];
    ExprScalarVarGene new_var_gene = objectFactory.createExprScalarVarGene();
    new_var_gene.setScalarVar(new_var);
    return new_var_gene;
  }

  private static ExprScalarOprGene randomize_opr() {
    ExprScalarOprGene new_opr_gene = objectFactory.createExprScalarOprGene();
    ExprScalarOprBase[] possible_oprs = ExprScalarOprBase.values();
    ExprScalarOprBase new_opr = possible_oprs[kandid.util.CentralRandomizer.getInt(possible_oprs.length - 1)];
    new_opr_gene.setScalarOpr(new_opr);
    return new_opr_gene;
  }

}
