package kandid.soup.genetic.scalarvm;

import java.util.List;

import kandid.Environment;
import kandid.soup.ExprScalarArgsListGene;
import kandid.soup.ExprScalarConstGene;
import kandid.soup.ExprScalarListGene;
import kandid.soup.ExprScalarOprBase;
import kandid.soup.ExprScalarOprGene;
import kandid.soup.ExprScalarVarGene;
import kandid.soup.GeneType;
import kandid.soup.ObjectFactory;
import kandid.soup.ScalarExprGene;
import kandid.soup.ScalarExpressionChromosome;
import kandid.soup.SeedGene;

public class Merger {
  private static ObjectFactory objectFactory = new ObjectFactory();

  public static ScalarExpressionChromosome merge(Environment env, ScalarExpressionChromosome chromosome1, ScalarExpressionChromosome chromosome2) {
    System.out.println("merger chromosome1 " + chromosome1.getClass().getSimpleName() + " " + chromosome1);
    System.out.println("merger chromosome2 " + chromosome2.getClass().getSimpleName() + " " + chromosome2);
    ScalarExpressionChromosome new_chromosome = objectFactory.createScalarExpressionChromosome();
    new_chromosome.setNoiseSeed(merge(env, chromosome1.getNoiseSeed(), chromosome2.getNoiseSeed()));
    new_chromosome.setScalarExpression(merge(env, chromosome1.getScalarExpression(), chromosome2.getScalarExpression()));
    return new_chromosome;
  }

  private static SeedGene merge(Environment env, SeedGene gene1, SeedGene gene2) {
    SeedGene new_noiseSeed = objectFactory.createSeedGene();
    long seed = env.isSource1() ? gene1.getValue().longValue() : gene2.getValue().longValue();
    new_noiseSeed.setValue(Long.valueOf(seed));
    return new_noiseSeed;
  }

  private static ScalarExprGene merge(Environment env, ScalarExprGene gene1, ScalarExprGene gene2) {
    ScalarExprGene new_scalarExpression = objectFactory.createScalarExprGene();
    ExprScalarListGene scalarList1 = gene1.getList();
    ExprScalarListGene scalarList2 = gene2.getList();
    
    ExprScalarListGene new_list = objectFactory.createExprScalarListGene();
    new_scalarExpression.setList(new_list);

    ExprScalarOprGene new_opr = objectFactory.createExprScalarOprGene();
    ExprScalarOprGene opr1or2 = env.isSource1() ? scalarList1.getOpr() : scalarList2.getOpr();
    String opr_value = opr1or2.getScalarOpr().value();
    new_opr.setScalarOpr(ExprScalarOprBase.fromValue(opr_value));
    new_list.setOpr(new_opr);

    ExprScalarArgsListGene new_args = objectFactory.createExprScalarArgsListGene();
    new_list.setArgs(new_args);
    
    List<GeneType> vce1_list = scalarList1.getArgs().getVarOrConstOrScalarExpression();
    List<GeneType> vce2_list = scalarList2.getArgs().getVarOrConstOrScalarExpression();
    int length1 = vce1_list.size();
    int length2 = vce2_list.size();
    int commonLength = length1 < length2 ? length1 : length2;
    for(int ci=0; ci<commonLength; ++ci) {
//    * {@link ExprScalarVarGene }
//    * {@link ExprScalarConstGene }
//    * {@link ScalarExprGene }
      GeneType vce1 = vce1_list.get(ci);
      GeneType vce2 = vce2_list.get(ci);
      if(vce1 instanceof ExprScalarVarGene && vce2 instanceof ExprScalarVarGene) {
        ExprScalarVarGene vce1or2_var_gene = env.isSource1() ? (ExprScalarVarGene)vce1 : (ExprScalarVarGene)vce2;
        Cloner.add_var_gene(new_args, vce1or2_var_gene);
      }
      else if(vce1 instanceof ExprScalarConstGene && vce2 instanceof ExprScalarConstGene) {
        ExprScalarConstGene vce1or2_const_gene = env.isSource1() ? (ExprScalarConstGene)vce1 : (ExprScalarConstGene)vce2;
        Cloner.add_const_gene(new_args, vce1or2_const_gene);
      }
      else if(vce1 instanceof ScalarExprGene && vce2 instanceof ScalarExprGene) {
        ScalarExprGene new_expr_gene;
        if(env.isSource1()) {
          new_expr_gene = merge(env, ((ScalarExprGene)vce1), ((ScalarExprGene)vce2));
        }
        else {
          new_expr_gene = merge(env, ((ScalarExprGene)vce2), ((ScalarExprGene)vce1));
        }
        new_args.getVarOrConstOrScalarExpression().add(new_expr_gene);
      }
      else if(vce1 instanceof ExprScalarVarGene && vce2 instanceof ExprScalarConstGene) {
        if(env.isSource1()) {
          Cloner.add_var_gene(new_args, (ExprScalarVarGene)vce1);
        }
        else {
          Cloner.add_const_gene(new_args, (ExprScalarConstGene)vce2);
        }
      }
      else if(vce1 instanceof ExprScalarConstGene && vce2 instanceof ExprScalarVarGene) {
        if(env.isSource1()) {
          Cloner.add_const_gene(new_args, (ExprScalarConstGene)vce1);
        }
        else {
          Cloner.add_var_gene(new_args, (ExprScalarVarGene)vce2);
        }
      }
      else if(vce1 instanceof ScalarExprGene && vce2 instanceof ExprScalarVarGene) {
        if(env.isSource1()) {
          ScalarExprGene new_expr_gene = Cloner.deepclone((ScalarExprGene)vce1);
          new_args.getVarOrConstOrScalarExpression().add(new_expr_gene);
        }
        else {
          Cloner.add_var_gene(new_args, (ExprScalarVarGene)vce2);
        }
      }
      else if(vce1 instanceof ScalarExprGene && vce2 instanceof ExprScalarConstGene) {
        if(env.isSource1()) {
          ScalarExprGene new_expr_gene = Cloner.deepclone((ScalarExprGene)vce1);
          new_args.getVarOrConstOrScalarExpression().add(new_expr_gene);
        }
        else {
          Cloner.add_const_gene(new_args, (ExprScalarConstGene)vce2);
        }
      }
      else if(vce1 instanceof ExprScalarVarGene && vce2 instanceof ScalarExprGene) {
        if(env.isSource1()) {
          Cloner.add_var_gene(new_args, (ExprScalarVarGene)vce1);
        }
        else {
          ScalarExprGene new_expr_gene = Cloner.deepclone((ScalarExprGene)vce2);
          new_args.getVarOrConstOrScalarExpression().add(new_expr_gene);
        }
      }
      else if(vce1 instanceof ExprScalarConstGene && vce2 instanceof ScalarExprGene) {
        if(env.isSource1()) {
          Cloner.add_const_gene(new_args, (ExprScalarConstGene)vce1);
        }
        else {
          ScalarExprGene new_expr_gene = Cloner.deepclone((ScalarExprGene)vce2);
          new_args.getVarOrConstOrScalarExpression().add(new_expr_gene);
        }
      }
      else {
        assert false : "no strategy for merging " + vce1.getClass().getName() + " with " + vce2.getClass().getName();
      }
    }
    return new_scalarExpression;
  }
}
