/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.soup.genetic.lsys;

import kandid.soup.ChromosomeType;
import kandid.soup.Lsys0LChromosome;
import kandid.soup.LsysD0LChromosome;
import kandid.soup.LsysILChromosome;

/**
 * @author thomas jourdan
 *
 */
public class LsysGeneticFactory {
  
  private static LsysD0LGeneticWorker lsysD0LGeneticWorker;
  private static Lsys0LGeneticWorker lsys0LGeneticWorker;
  private static LsysILGeneticWorker lsysILGeneticWorker;
  
  public static LsysGeneticWorker getLsysGeneticWorker(ChromosomeType aChromosome) {
    if(aChromosome instanceof LsysD0LChromosome) {
      if(lsysD0LGeneticWorker == null) {
        lsysD0LGeneticWorker = new LsysD0LGeneticWorker();
      }
      return lsysD0LGeneticWorker;
    }
    else if(aChromosome instanceof Lsys0LChromosome) {
      if(lsys0LGeneticWorker == null) {
        lsys0LGeneticWorker = new Lsys0LGeneticWorker();
      }
      return lsys0LGeneticWorker;
    }
    else if(aChromosome instanceof LsysILChromosome) {
      if(lsysILGeneticWorker == null) {
        lsysILGeneticWorker = new LsysILGeneticWorker();
      }
      return lsysILGeneticWorker;
    }
    assert false : "wrong chromosome type: " + aChromosome.getClass().getName();
    return null;
  }

}
