/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.soup.genetic.lsys;

import java.util.Iterator;
import java.util.List;

import kandid.soup.LsysChromosome;
import kandid.util.CentralRandomizer;

/**
 * @author thomas jourdan
 *
 */
public class Lsys0LGeneticWorker extends LsysGeneticWorker {

  /**
   * @param lsysChromosome
   * @return
   */
  public String randomizeAlphabet(LsysChromosome lsysChromosome) {
    List alphabethList = super.randomizeAlphabetList(lsysChromosome);
    String alphabeth = "";
    for (Iterator iter = alphabethList.iterator(); iter.hasNext();) {
      String character = (String) iter.next();
      alphabeth += character.charAt(0);
    }
    return alphabeth;
  }

  /* (non-Javadoc)
   * @see kandid.soup.genetic.lsys.LsysGeneticWorker#getMaxProductions(kandid.soup.impl.LsysChromosomeImpl)
   */
  public int getNumberOfProductions(LsysChromosome lsysChromosome) {
    return 1+CentralRandomizer.getBinomial(64, 0.25);
  }

}
