/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.preference.util;

public class PasswordHelper {
  
  public static String construct(String publicForm2) {
    StringBuffer pwd = new StringBuffer(publicForm2);
    for (int ix = 0; ix < pwd.length(); ++ix) {
      pwd.setCharAt(ix, (char)(pwd.charAt(ix) - ix));
    }
    pwd = pwd.reverse();
    return pwd.deleteCharAt(pwd.length()-1).toString();
  }

  public static String deconstruct(String pwd) {
    StringBuffer publicForm = new StringBuffer(pwd);
    publicForm.append("*");
    publicForm = publicForm.reverse();
    for (int ix = 0; ix < publicForm.length(); ++ix) {
      publicForm.setCharAt(ix, (char)(publicForm.charAt(ix) + ix));
    }
    return publicForm.toString();
  }

}
