/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.preference.ui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import kandid.IconLoader;
import kandid.Kandid;

/**
 * @author thomas jourdan
 *
 */
public class UiPreference extends JDialog {
  private static final long serialVersionUID = 1L;

  private IlPreference ilPreference;

  private javax.swing.JPanel jContentPanel = null;

  private JTabbedPane jTabbedPane = null;
  private JPanel tab1Panel = null;
  private JPanel heading1Panel = null;
  private JPanel detail1Panel = null;
  private JLabel nicknameLabel = null;
  private JTextField nicknameTextField = null;
  private JLabel mailLabel = null;
  private JTextField mailTextField = null;
  private JPanel tab2Panel = null;
  private JPanel tab3Panel = null;
  private JPanel tab5Panel = null;
  private JPanel heading2Panel = null;
  private JPanel detail2Panel = null;
  private JPanel heading3Panel = null;
  private JPanel detail3Panel = null;
  private JPanel heading5Panel = null;
  private JPanel detail5Panel = null;
  private JLabel heading2Label = null;
  private JLabel heading3Label = null;
  private JLabel heading5Label = null;
  private JLabel heading1Label = null;
  private JCheckBox enableProxyCheckBox = null;
  private JLabel enableProxyLabel = null;
  private JLabel proxyHostLabel = null;
  private JTextField proxyHostTextField = null;
  private JLabel proxyPortLabel = null;
  private JTextField proxyPortTextField = null;
  private JLabel usernameLabel = null;
  private JTextField usernameTextField = null;
  private JLabel passwordLabel = null;
  private JPasswordField jPasswordField = null;
  private JLabel filebaseLabel = null;
  private JLabel incommingLabel = null;
  private JLabel cacheLabel = null;
  private JLabel scratchLabel = null;
  private JLabel smtpLabel = null;
  private JTextField smtpTextField = null;
  private JPanel buttonPanel = null;
  private JPanel contentPanel = null;
  private JButton cancelButton = null;
  private JButton applyButton = null;
  private JLabel proxyLoginLabel = null;
  private JLabel noProxyHostsLabel = null;
  private JTextField nonProxyHostsTextField = null;
  private JButton okButton = null;

	private JPanel tab4Panel = null;
	private JPanel heading4Panel = null;
	private JPanel detail4Panel = null;
	private JLabel heading4Label = null;
	private JLabel webDbUrlLabel = null;
	private JTextField webDbUrlTextField = null;
	private JLabel timeoutLabel = null;
	private JTextField timeoutTextField = null;
	private JLabel installIdLabel = null;
	private JTextField installIdTextField = null;
	private JTextField filebaseTextField = null;
  private JTextField incommingTextField = null;
  private JTextField scratchTextField = null;
  private JTextField cacheTextField = null;
	/**
   * This is the default constructor
   */
  public UiPreference() {
    super();
    initialize();
    enableProxyLabels();
  }
  /**
   * @param preference
   */
  public UiPreference(IlPreference ilPreference) {
    this();
    this.ilPreference = ilPreference;
  }
	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
//		this.setSize(300,200);
		this.setModal(true);
		this.setTitle("Kandid Preferences");
		this.setContentPane(getJContentPane());
	}
	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private javax.swing.JPanel getJContentPane() {
		if(jContentPanel == null) {
			jContentPanel = new javax.swing.JPanel();
      jContentPanel.setLayout(new BoxLayout(jContentPanel, BoxLayout.Y_AXIS));
      jContentPanel.add(getContentPanel(), null);
      jContentPanel.add(getButtonPanel(), null);
		}
		return jContentPanel;
	}
  /**
   * This method initializes jTabbedPane
   * 
   * @return javax.swing.JTabbedPane
   */
  protected JTabbedPane getJTabbedPane() {
    if (jTabbedPane == null) {
      jTabbedPane = new JTabbedPane();
//      jTabbedPane.addTab("User ID", null, getTab1Panel(), null);
//      jTabbedPane.addTab("HTTP Proxy", null, getTab2Panel(), null);
      jTabbedPane.addTab("Folders", null, getTab3Panel(), null);
//      jTabbedPane.addTab("WEB Database", null, getTab4Panel(), null);
//      jTabbedPane.addTab("Breeder List", null, getTab5Panel(), null);
    }
    return jTabbedPane;
  }

  /**
   * This method initializes tab1Panel
   * 
   *  
   */
  private JPanel getTab1Panel() {
    if (tab1Panel == null) {
      tab1Panel = new JPanel();
      tab1Panel.setLayout(new BorderLayout());
      tab1Panel.add(getHeading1Panel(), java.awt.BorderLayout.NORTH);
      tab1Panel.add(getDetail1Panel(), java.awt.BorderLayout.WEST);
    }
    return tab1Panel;
  }
  /**
   * This method initializes heading1Panel
   * 
   * @return javax.swing.JPanel
   */
  private JPanel getHeading1Panel() {
    if (heading1Panel == null) {
      FlowLayout flowLayout1 = new FlowLayout();
      heading1Label = new JLabel();
      heading1Panel = new JPanel();
      heading1Panel.setLayout(flowLayout1);
      heading1Label.setText("<HTML>Enter your nickname if you want to publish your images in the Kandid WEB Database.<br><br>Mail address is optional.</HTML>");
      heading1Label.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
      heading1Label.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
      flowLayout1.setAlignment(java.awt.FlowLayout.LEFT);
      heading1Panel.add(heading1Label, null);
    }
    return heading1Panel;
  }
//      detail1Panel.add(mailLabel, mailLabel.getName());
//      detail1Panel.add(mailLabel, mailLabel.getName());
//.swing.JPanel
//   */
  private JPanel getDetail1Panel() {
    if (detail1Panel == null) {
      GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
      mailLabel = new JLabel();
      nicknameLabel = new JLabel();
      detail1Panel = new JPanel();
      detail1Panel.setLayout(new GridBagLayout());
      nicknameLabel.setText("Nickname:  ");
      gridBagConstraints10.gridx = 0;
      gridBagConstraints10.gridy = 0;
      gridBagConstraints10.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints11.gridx = 1;
      gridBagConstraints11.gridy = 0;
      gridBagConstraints12.gridx = 0;
      gridBagConstraints12.gridy = 1;
      gridBagConstraints12.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints13.gridx = 1;
      gridBagConstraints13.gridy = 1;
      detail1Panel.add(nicknameLabel, gridBagConstraints10);
      detail1Panel.add(getNicknameTextField(), gridBagConstraints11);
      detail1Panel.add(mailLabel, gridBagConstraints12);
      detail1Panel.add(getMailTextField(), gridBagConstraints13);
      mailLabel.setText("Mail address:  ");
    }
    return detail1Panel;
  }
  /**
   * This method initializes nicknameTextField
   * 
   * @return javax.swing.JTextField
   */
  protected JTextField getNicknameTextField() {
    if (nicknameTextField == null) {
      nicknameTextField = new JTextField();
      nicknameTextField.setColumns(32);
    }
    return nicknameTextField;
  }
  /**
   * This method initializes mailTextField
   * 
   * @return javax.swing.JTextField
   */
  protected JTextField getMailTextField() {
    if (mailTextField == null) {
      mailTextField = new JTextField();
      mailTextField.setColumns(32);
    }
    return mailTextField;
  }
  /**
   * This method initializes tab2Panel  
   *  
   * @return javax.swing.JPanel 
   */    
  private JPanel getTab2Panel() {
    if (tab2Panel == null) {
      GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
      tab2Panel = new JPanel();
      tab2Panel.setLayout(new GridBagLayout());
      gridBagConstraints2.gridx = 0;
      gridBagConstraints2.gridy = 0;
      gridBagConstraints2.insets = new java.awt.Insets(1,1,1,1);
      gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints3.gridx = 0;
      gridBagConstraints3.gridy = 1;
      gridBagConstraints3.insets = new java.awt.Insets(1,1,1,1);
      gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
      tab2Panel.add(getHeading2Panel(), gridBagConstraints2);
      tab2Panel.add(getDetail2Panel(), gridBagConstraints3);
    }
    return tab2Panel;
  }
  /**
   * This method initializes tab3Panel  
   *  
   * @return javax.swing.JPanel 
   */    
  private JPanel getTab3Panel() {
    if (tab3Panel == null) {
      tab3Panel = new JPanel();
      tab3Panel.setLayout(new BorderLayout());
      tab3Panel.add(getHeading3Panel(), java.awt.BorderLayout.NORTH);
      tab3Panel.add(getDetail3Panel(), java.awt.BorderLayout.WEST);
    }
    return tab3Panel;
  }
  /**
   * This method initializes tab5Panel  
   *  
   * @return javax.swing.JPanel 
   */    
  private JPanel getTab5Panel() {
    if (tab5Panel == null) {
      tab5Panel = new JPanel();
      tab5Panel.setLayout(new BorderLayout());
      tab5Panel.add(getHeading5Panel(), java.awt.BorderLayout.NORTH);
      tab5Panel.add(getDetail5Panel(), java.awt.BorderLayout.WEST);
    }
    return tab5Panel;
  }
  /**
   * This method initializes heading2Panel  
   *  
   * @return javax.swing.JPanel 
   */    
  private JPanel getHeading2Panel() {
    if (heading2Panel == null) {
      FlowLayout flowLayout2 = new FlowLayout();
      heading2Label = new JLabel();
      heading2Panel = new JPanel();
      heading2Panel.setLayout(flowLayout2);
      heading2Label.setText("<HTML>If you are connected to the Internet through a firewall or proxy,<br>you will need to enter the proxy host.</HTML>");
      flowLayout2.setAlignment(java.awt.FlowLayout.LEFT);
      heading2Panel.add(heading2Label, null);
    }
    return heading2Panel;
  }
  /**
   * This method initializes detail2Panel 
   *  
   * @return javax.swing.JPanel 
   */    
  private JPanel getDetail2Panel() {
    if (detail2Panel == null) {
      noProxyHostsLabel = new JLabel();
      proxyLoginLabel = new JLabel();
      GridBagConstraints gridBagConstraints7b = new GridBagConstraints();
      GridBagConstraints gridBagConstraints7a = new GridBagConstraints();
      GridBagConstraints gridBagConstraints6b = new GridBagConstraints();
      GridBagConstraints gridBagConstraints6a = new GridBagConstraints();
      GridBagConstraints gridBagConstraints4a = new GridBagConstraints();
      GridBagConstraints gridBagConstraints4b = new GridBagConstraints();
      GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints3b = new GridBagConstraints();
      GridBagConstraints gridBagConstraints3a = new GridBagConstraints();
      GridBagConstraints gridBagConstraints2b = new GridBagConstraints();
      GridBagConstraints gridBagConstraints2a = new GridBagConstraints();
      GridBagConstraints gridBagConstraints1b = new GridBagConstraints();
      GridBagConstraints gridBagConstraints1a = new GridBagConstraints();
      enableProxyLabel = new JLabel();
      proxyHostLabel = new JLabel();
      proxyPortLabel = new JLabel();
      usernameLabel = new JLabel();
      passwordLabel = new JLabel();
      detail2Panel = new JPanel();
      detail2Panel.setLayout(new GridBagLayout());
      enableProxyLabel.setText("Enable HTTP proxy");
      proxyHostLabel.setText("Hostname for HTTP Proxy:  ");
      proxyPortLabel.setText("Portnumber for HTTP Proxy:  ");
      usernameLabel.setText("Username:  ");
      passwordLabel.setText("Password:   ");
      gridBagConstraints6a.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints1a.gridx = 0;
      gridBagConstraints1a.gridy = 0;
      gridBagConstraints1a.anchor = java.awt.GridBagConstraints.EAST;
      gridBagConstraints1b.gridx = 1;
      gridBagConstraints1b.gridy = 0;
      gridBagConstraints1b.anchor = java.awt.GridBagConstraints.WEST;
      
      gridBagConstraints2a.gridx = 0;
      gridBagConstraints2a.gridy = 1;
      gridBagConstraints2a.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints2b.gridx = 1;
      gridBagConstraints2b.gridy = 1;
      
      gridBagConstraints3a.gridx = 0;
      gridBagConstraints3a.gridy = 2;
      gridBagConstraints3a.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints3b.gridx = 1;
      gridBagConstraints3b.gridy = 2;
      
      gridBagConstraints4a.gridx = 0;
      gridBagConstraints4a.gridy = 3;
      gridBagConstraints4a.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints4b.gridx = 1;
      gridBagConstraints4b.gridy = 3;
      
      gridBagConstraints5.gridx = 0;
      gridBagConstraints5.gridy = 4;

      gridBagConstraints6a.gridx = 0;
      gridBagConstraints6a.gridy = 5;
      gridBagConstraints6b.gridx = 1;
      gridBagConstraints6b.gridy = 5;
      
      gridBagConstraints7a.gridx = 0;
      gridBagConstraints7a.gridy = 6;
      gridBagConstraints7b.gridx = 1;
      gridBagConstraints7b.gridy = 6;
      proxyLoginLabel.setText("<HTML><BR>If necessary enter username and password for the proxy host.</HTML>");
      gridBagConstraints5.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints5.gridwidth = 2;
      noProxyHostsLabel.setText("No Proxy for hosts:  ");
      detail2Panel.add(getEnableProxyCheckBox(), gridBagConstraints1a);
      detail2Panel.add(enableProxyLabel, gridBagConstraints1b);
      detail2Panel.add(proxyHostLabel, gridBagConstraints2a);
      detail2Panel.add(getProxyHostTextField(), gridBagConstraints2b);
      detail2Panel.add(proxyPortLabel, gridBagConstraints3a);
      detail2Panel.add(getProxyPortTextField(), gridBagConstraints3b);
      detail2Panel.add(noProxyHostsLabel, gridBagConstraints4a);
      detail2Panel.add(getNonProxyHostsTextField(), gridBagConstraints4b);
      detail2Panel.add(proxyLoginLabel, gridBagConstraints5);
      detail2Panel.add(getUsernameTextField(), gridBagConstraints6b);
      detail2Panel.add(usernameLabel, gridBagConstraints6a);
      gridBagConstraints7a.anchor = java.awt.GridBagConstraints.WEST;
      detail2Panel.add(passwordLabel, gridBagConstraints7a);
      detail2Panel.add(getJPasswordField(), gridBagConstraints7b);
    }
    return detail2Panel;
  }
  /**
   * This method initializes heading3Panel  
   *  
   * @return javax.swing.JPanel 
   */    
  private JPanel getHeading3Panel() {
    if (heading3Panel == null) {
      FlowLayout flowLayout3 = new FlowLayout();
      heading3Label = new JLabel();
      heading3Panel = new JPanel();
      heading3Panel.setLayout(flowLayout3);
      heading3Label.setText("Local folders.");
      flowLayout3.setAlignment(java.awt.FlowLayout.LEFT);
      heading3Panel.add(heading3Label, null);
    }
    return heading3Panel;
  }
  /**
   * This method initializes detail3Panel 
   *  
   * @return javax.swing.JPanel 
   */    
  private JPanel getDetail3Panel() {
    if (detail3Panel == null) {
      GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
      incommingLabel = new JLabel();
      filebaseLabel = new JLabel();
      scratchLabel = new JLabel();
      cacheLabel = new JLabel();
      
      detail3Panel = new JPanel();
      detail3Panel.setLayout(new GridBagLayout());
      
      filebaseLabel.setText("Folder for local images:");
//      incommingLabel.setText("Folder for loaded images:");
      incommingLabel.setText("");
      scratchLabel.setText("Folder for scratch files:");
      cacheLabel.setText("Folder for image cache:");
      
      gridBagConstraints18.gridx = 0;
      gridBagConstraints18.gridy = 0;
      gridBagConstraints18.anchor = java.awt.GridBagConstraints.WEST;
      detail3Panel.add(filebaseLabel, gridBagConstraints18);
      gridBagConstraints25.gridx = 0;
      gridBagConstraints25.gridy = 1;
      detail3Panel.add(getFilebaseTextField(), gridBagConstraints25);

      gridBagConstraints20.gridx = 0;
      gridBagConstraints20.gridy = 3;
      gridBagConstraints20.anchor = java.awt.GridBagConstraints.WEST;
      detail3Panel.add(incommingLabel, gridBagConstraints20);
      gridBagConstraints32.gridx = 0;
      gridBagConstraints32.gridy = 4;
      detail3Panel.add(getIncommingTextField(), gridBagConstraints32);
      
      gridBagConstraints31.gridx = 0;
      gridBagConstraints31.gridy = 6;
      gridBagConstraints31.anchor = java.awt.GridBagConstraints.WEST;
      detail3Panel.add(cacheLabel, gridBagConstraints31);
      gridBagConstraints33.gridx = 0;
      gridBagConstraints33.gridy = 7;
      detail3Panel.add(getCacheTextField(), gridBagConstraints33);
      
      gridBagConstraints34.gridx = 0;
      gridBagConstraints34.gridy = 9;
      gridBagConstraints34.anchor = java.awt.GridBagConstraints.WEST;
      detail3Panel.add(scratchLabel, gridBagConstraints34);
      gridBagConstraints35.gridx = 0;
      gridBagConstraints35.gridy = 10;
      detail3Panel.add(getScratchTextField(), gridBagConstraints35);
    }
    return detail3Panel;
  }
  /**
   * This method initializes heading5Panel  
   *  
   * @return javax.swing.JPanel 
   */    
  private JPanel getHeading5Panel() {
    if (heading5Panel == null) {
      FlowLayout flowLayout4 = new FlowLayout();
      heading5Label = new JLabel();
      heading5Panel = new JPanel();
      heading5Panel.setLayout(flowLayout4);
      heading5Label.setText("<HTML>For sending images to the breeder list an SMTP host for outgoing mail<br>is required.<br><br>Additionally nickname and mail address must be filled in tab 'User ID'.");
      flowLayout4.setAlignment(java.awt.FlowLayout.LEFT);
      heading5Panel.add(heading5Label, null);
    }
    return heading5Panel;
  }
  /**
   * This method initializes detail5Panel 
   *  
   * @return javax.swing.JPanel 
   */    
  private JPanel getDetail5Panel() {
    if (detail5Panel == null) {
      GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
      smtpLabel = new JLabel();
      detail5Panel = new JPanel();
      detail5Panel.setLayout(new GridBagLayout());
      smtpLabel.setText("SMTP Host:  ");
      gridBagConstraints22.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints22.gridx = 0;
      gridBagConstraints22.gridy = 0;
      gridBagConstraints23.gridx = 1;
      gridBagConstraints23.gridy = 0;
      detail5Panel.add(smtpLabel, gridBagConstraints22);
      detail5Panel.add(getSmtpTextField(), gridBagConstraints23);
    }
    return detail5Panel;
  }
  /**
   * This method initializes enableProxyCheckBox  
   *  
   * @return javax.swing.JCheckBox  
   */    
  protected JCheckBox getEnableProxyCheckBox() {
    if (enableProxyCheckBox == null) {
      enableProxyCheckBox = new JCheckBox();
      enableProxyCheckBox.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      enableProxyCheckBox.addActionListener(new java.awt.event.ActionListener() { 
      	public void actionPerformed(java.awt.event.ActionEvent e) {
          ilPreference.enableProxy();
          enableProxyLabels();
      	}
      });
    }
    return enableProxyCheckBox;
  }
  /**
   * This method initializes proxyHostTextField 
   *  
   * @return javax.swing.JTextField 
   */    
  protected JTextField getProxyHostTextField() {
    if (proxyHostTextField == null) {
      proxyHostTextField = new JTextField();
      proxyHostTextField.setColumns(32);
    }
    return proxyHostTextField;
  }
  /**
   * This method initializes proxyPortTextField 
   *  
   * @return javax.swing.JTextField 
   */    
  protected JTextField getProxyPortTextField() {
    if (proxyPortTextField == null) {
      proxyPortTextField = new JTextField();
      proxyPortTextField.setColumns(32);
    }
    return proxyPortTextField;
  }
  /**
   * This method initializes usernameTextField  
   *  
   * @return javax.swing.JTextField 
   */    
  protected JTextField getUsernameTextField() {
    if (usernameTextField == null) {
      usernameTextField = new JTextField();
      usernameTextField.setColumns(32);
    }
    return usernameTextField;
  }
  /**
   * This method initializes jPasswordField 
   *  
   * @return javax.swing.JPasswordField 
   */    
  protected JPasswordField getJPasswordField() {
    if (jPasswordField == null) {
      jPasswordField = new JPasswordField();
      jPasswordField.setColumns(32);
    }
    return jPasswordField;
  }
  /**
   * This method initializes smtpTextField  
   *  
   * @return javax.swing.JTextField 
   */    
  protected JTextField getSmtpTextField() {
    if (smtpTextField == null) {
      smtpTextField = new JTextField();
      smtpTextField.setColumns(32);
    }
    return smtpTextField;
  }
  /**
   * This method initializes buttonPanel  
   *  
   * @return javax.swing.JPanel 
   */    
  private JPanel getButtonPanel() {
    if (buttonPanel == null) {
      FlowLayout flowLayout9 = new FlowLayout();
      buttonPanel = new JPanel();
      buttonPanel.setLayout(flowLayout9);
      flowLayout9.setAlignment(java.awt.FlowLayout.RIGHT);
      buttonPanel.add(getOkButton(), null);
      buttonPanel.add(getApplyButton(), null);
      buttonPanel.add(getCancelButton(), null);
    }
    return buttonPanel;
  }
  /**
   * This method initializes contentPanel 
   *  
   * @return javax.swing.JPanel 
   */    
  private JPanel getContentPanel() {
    if (contentPanel == null) {
      contentPanel = new JPanel();
      contentPanel.add(getJTabbedPane(), null);
    }
    return contentPanel;
  }
  /**
   * This method initializes cancelButton 
   *  
   * @return javax.swing.JButton  
   */    
  private JButton getCancelButton() {
    if (cancelButton == null) {
      cancelButton = new JButton();
      cancelButton.setIcon(IconLoader.cancelImageIcon);
      cancelButton.setText("Cancel");
      cancelButton.addActionListener(new java.awt.event.ActionListener() { 
        public void actionPerformed(java.awt.event.ActionEvent e) {
          ilPreference.cancel();
        }
      });
    }
    return cancelButton;
  }
  /**
   * This method initializes applyButton  
   *  
   * @return javax.swing.JButton  
   */    
  private JButton getApplyButton() {
    if (applyButton == null) {
      applyButton = new JButton();
      applyButton.setIcon(IconLoader.applyImageIcon);
      applyButton.setText("Apply");
      applyButton.addActionListener(new java.awt.event.ActionListener() { 
        public void actionPerformed(java.awt.event.ActionEvent e) {
          ilPreference.apply();
        }
      });
    }
    return applyButton;
  }
  /**
   * This method initializes nonProxyHostsTextField 
   *  
   * @return javax.swing.JTextField 
   */    
  protected JTextField getNonProxyHostsTextField() {
    if (nonProxyHostsTextField == null) {
      nonProxyHostsTextField = new JTextField();
      nonProxyHostsTextField.setColumns(32);
    }
    return nonProxyHostsTextField;
  }
  /**
   * This method initializes okButton 
   *  
   * @return javax.swing.JButton  
   */    
  private JButton getOkButton() {
    if (okButton == null) {
      okButton = new JButton();
      okButton.setIcon(IconLoader.okImageIcon);
      okButton.setText("OK");
      okButton.addActionListener(new java.awt.event.ActionListener() { 
        public void actionPerformed(java.awt.event.ActionEvent e) {
          ilPreference.ok();
        }
      });
    }
    return okButton;
  }
	/**
	 * This method initializes tab4Panel	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	private JPanel getTab4Panel() {
		if (tab4Panel == null) {
			tab4Panel = new JPanel();
			tab4Panel.setLayout(new BorderLayout());
			tab4Panel.add(getHeading4Panel(), java.awt.BorderLayout.NORTH);
			tab4Panel.add(getDetail4Panel(), java.awt.BorderLayout.WEST);
		}
		return tab4Panel;
	}
	/**
	 * This method initializes heading4Panel	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	private JPanel getHeading4Panel() {
		if (heading4Panel == null) {
			FlowLayout flowLayout11 = new FlowLayout();
			heading4Label = new JLabel();
			heading4Panel = new JPanel();
			heading4Panel.setLayout(flowLayout11);
			heading4Label.setText("<html>Kandid WEB Database is for sharing Image genomes with other users.<br>The content of this database is licenced under<br>Creative Commons License Attribution-NonCommercial-ShareAlike 2.0.<br> More infos at: <a href='http://creativecommons.org/'>http://creativecommons.org/</a><html>");
			flowLayout11.setAlignment(java.awt.FlowLayout.LEFT);
			heading4Panel.add(heading4Label, null);
		}
		return heading4Panel;
	}
	/**
	 * This method initializes detail4Panel	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	private JPanel getDetail4Panel() {
		if (detail4Panel == null) {
			webDbUrlLabel = new JLabel();
			timeoutLabel = new JLabel();
			installIdLabel = new JLabel();
			GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
			GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
			detail4Panel = new JPanel();
			detail4Panel.setLayout(new GridBagLayout());
			webDbUrlLabel.setText("URL:  ");
			webDbUrlLabel.setEnabled(true);
			timeoutLabel.setText("Timeout:  ");
			installIdLabel.setText("Installation ID:  ");
			gridBagConstraints31.weightx = 1.0;
			gridBagConstraints31.fill = java.awt.GridBagConstraints.HORIZONTAL;
			gridBagConstraints31.gridx = 1;
			gridBagConstraints31.gridy = 2;
			gridBagConstraints4.gridx = 0;
			gridBagConstraints4.gridy = 0;
			gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
			gridBagConstraints1.gridx = 1;
			gridBagConstraints1.gridy = 0;
			gridBagConstraints51.gridx = 0;
			gridBagConstraints51.gridy = 1;
			gridBagConstraints51.anchor = java.awt.GridBagConstraints.WEST;
			gridBagConstraints24.gridx = 1;
			gridBagConstraints24.gridy = 1;
			gridBagConstraints6.gridx = 0;
			gridBagConstraints6.gridy = 2;
			gridBagConstraints6.anchor = java.awt.GridBagConstraints.WEST;
			detail4Panel.add(webDbUrlLabel, gridBagConstraints4);
			detail4Panel.add(getWebDbUrlTextField(), gridBagConstraints1);
			detail4Panel.add(timeoutLabel, gridBagConstraints51);
			detail4Panel.add(getTimeoutTextField(), gridBagConstraints24);
			detail4Panel.add(installIdLabel, gridBagConstraints6);
			detail4Panel.add(getInstallIdTextField(), gridBagConstraints31);
			gridBagConstraints24.weightx = 1.0;
			gridBagConstraints24.fill = java.awt.GridBagConstraints.HORIZONTAL;
			gridBagConstraints1.weightx = 1.0;
			gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
		}
		return detail4Panel;
	}
	/**
	 * This method initializes webDbUrlTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */    
	protected JTextField getWebDbUrlTextField() {
		if (webDbUrlTextField == null) {
			webDbUrlTextField = new JTextField();
			webDbUrlTextField.setColumns(32);
			webDbUrlTextField.setEditable(false);
			webDbUrlTextField.setAutoscrolls(false);
		}
		return webDbUrlTextField;
	}
	/**
	 * This method initializes timeoutTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */    
	protected JTextField getTimeoutTextField() {
		if (timeoutTextField == null) {
			timeoutTextField = new JTextField();
			timeoutTextField.setColumns(32);
		}
		return timeoutTextField;
	}
	/**
	 * This method initializes installIdTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */    
	protected JTextField getInstallIdTextField() {
		if (installIdTextField == null) {
			installIdTextField = new JTextField();
			installIdTextField.setColumns(32);
			installIdTextField.setEditable(false);
		}
		return installIdTextField;
	}
	/**
	 * This method initializes filebaseTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */    
	protected JTextField getFilebaseTextField() {
		if (filebaseTextField == null) {
			filebaseTextField = new JTextField();
			filebaseTextField.setColumns(42);
			filebaseTextField.setEditable(false);
		}
		return filebaseTextField;
	}
	/**
	 * This method initializes incommingTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */    
	protected JTextField getIncommingTextField() {
		if (incommingTextField == null) {
			incommingTextField = new JTextField();
			incommingTextField.setColumns(42);
			incommingTextField.setEditable(false);
		}
		return incommingTextField;
	}
  /**
   * This method initializes cacheTextField 
   *  
   * @return javax.swing.JTextField 
   */    
  protected JTextField getCacheTextField() {
    if (cacheTextField == null) {
      cacheTextField = new JTextField();
      cacheTextField.setColumns(42);
      cacheTextField.setEditable(false);
    }
    return incommingTextField;
  }
  /**
   * This method initializes scratchTextField 
   *  
   * @return javax.swing.JTextField 
   */    
  protected JTextField getScratchTextField() {
    if (scratchTextField == null) {
      scratchTextField = new JTextField();
      scratchTextField.setColumns(42);
      scratchTextField.setEditable(false);
    }
    return scratchTextField;
  }
  
  private void enableProxyLabels() {
    if(enableProxyCheckBox == null)
      return;

    boolean enabled = enableProxyCheckBox.isSelected();
    if(proxyHostLabel != null) proxyHostLabel.setEnabled(enabled);
    if(proxyPortLabel != null) proxyPortLabel.setEnabled(enabled);
    if(noProxyHostsLabel != null) noProxyHostsLabel.setEnabled(enabled);
    if(proxyLoginLabel != null) proxyLoginLabel.setEnabled(enabled);
    if(usernameLabel != null) usernameLabel.setEnabled(enabled);
    if(passwordLabel != null) passwordLabel.setEnabled(enabled);
  }
        }
