/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 * Copyright (C) 1998, 2003 Slava Pestov, setHTTPProxy is from JEdit open source project.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.preference.test;

import junit.framework.TestCase;
import kandid.preference.util.PasswordHelper;

public class PasswordHelperTest extends TestCase {

  /**
   * Constructor for PasswordHelperTest.
   * @param arg0
   */
  public PasswordHelperTest(String arg0) {
    super(arg0);
  }

  public void con(String pwd) {
    String publicForm = PasswordHelper.deconstruct(pwd);
    assertTrue(!pwd.equals(publicForm));
    assertEquals(pwd, PasswordHelper.construct(publicForm));
  }

  public void testConstruct() {
    con("abc");
    con("");
    con("");
  }

}
