/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.pond.util;

import kandid.Console;
import kandid.extensions.ExportWizard;
import kandid.pond.BreederType;
import kandid.preference.PreferenceType;
import kandid.util.Debug;

public class BreederSearchThread extends Thread {
  private BreederType    breederType;
  private PreferenceType preferences;
  private ExportWizard   parent;
  private ConnectingDialog connectingDialog;
  
  /**
   * Constructor for BreederSearchThread.
   */
  private BreederSearchThread() {
    super();
  }

  /**
   * Method getBreederRequestThread.
   * @return BreederSearchThread
   */
  public static BreederSearchThread getBreederRequestThread() {
    return new BreederSearchThread();
  }

  /**
   * Get random preeder using a http connection.
   * @see java.lang.Runnable#run()
   */
  public void run() {
    String url = "";
    try {
      String baseUrl = null;
      breederType = null;
      BreederListConnection bl = new BreederListConnection();
      if (preferences != null && preferences.getKandid().getHome().length() > 0) {
        baseUrl = preferences.getKandid().getHome();
      } else {
        baseUrl = "http://kandid.sourceforge.net";
      }
      // enable greeting mode
      String breederSearch = System.getProperty("BreederSearch");
      boolean greetingMode = breederSearch != null && breederSearch.equals("greeting");
      String script  = greetingMode ? "/getnewbreeder.php" : "/getrandombreeder.php";
      if (preferences != null && preferences.getUser().getEmail().length() > 0) {
        url = baseUrl + script + "?not=" + preferences.getUser().getEmail();
      } else {
        url = baseUrl +script;
      }
      bl.readPond(url);
      breederType = bl.getRandomBreeder();
      if(parent != null)
        parent.signalBreederSearchReady();
    } catch (Exception exc) {
      Debug.stackTrace(exc);
      Console.append(exc.toString());
      Console.append(exc.getMessage() + ": " + url);
    }
    connectingDialog.setVisible(false);
    connectingDialog.dispose();
    connectingDialog = null;
  }

  /**
   * Starts thread searching for a random breeder.
   * @param preferences
   * @param parent
   */
  public void searchRandomBreeder(PreferenceType preferences, ExportWizard parent) {
    breederType = null;
    this.parent = parent;
    this.preferences = preferences;
    connectingDialog = new ConnectingDialog(parent, false, this);
    connectingDialog.setVisible(true);
    System.out.println("start ");
    start();
  }

  /**
   * Returns the breeder.
   * @return BreederType
   */
  public BreederType getBreederType() {
    return breederType;
  }

}
