/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.pond.test;

import java.io.IOException;
import java.net.URISyntaxException;

import javax.xml.bind.JAXBException;

import junit.framework.TestCase;
import kandid.pond.BreederType;
import kandid.pond.util.*;
import kandid.util.Debug;

/**
 * 
 * @author thomas jourdan
 */
public class BreederListTest extends TestCase {

  /**
   * Constructor for BreederListTest.
   * @param arg0
   */
  public BreederListTest(String arg0) {
    super(arg0);
  }

  public void testGetRandomBreeder() {
    // TODO GetRandomBreeder is not tested
//    getNewBreeder();
//    System.getProperties().remove("BreederSearch");
//    getRandomBreeder();
  }

  private void readFrom(String from) {
    BreederListConnection bl = new BreederListConnection();
    try {
      bl.readPond(BreederRequestThreadTest.getTestPreferences().getKandid().getHome() + from);
      BreederType breederType = bl.getRandomBreeder();
      String result = breederType.getEmail();
      assertEquals("x (dot) genepool (at) mail (dot) xyz", result);
    }
    catch (JAXBException exc) {
      Debug.stackTrace(exc);
      assertTrue(false);
    }
    catch (IOException exc) {
      Debug.stackTrace(exc);
      assertTrue(false);
    } catch (URISyntaxException e) {
      Debug.stackTrace(e);
      assertTrue(false);
    }
  }

  private void getRandomBreeder() {
    readFrom("/getrandombreeder.php?not=x@mail.xyz");
  }

  private void getNewBreeder() {
    readFrom("/getnewbreeder.php");
  }

}
