/*
 * Copyright 2013, Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package kandid.noise;

import javax.vecmath.Vector3d;

public class PerlinNoise3D {
  private PerlinNoise noiseGenerator;
  
  
  public PerlinNoise3D() {
    super();
    this.noiseGenerator = new PerlinNoise(-1);
  }

  Vector3d calculateNoise(Vector3d point) {
    Vector3d vnoise = new Vector3d();
    this.noiseGenerator.unoise3d(point.x, point.y, point.z, vnoise);
//    vnoise.x = 2.0 * vnoise.x - 1.0;
//    vnoise.y = 2.0 * vnoise.y - 1.0;
//    vnoise.z = 2.0 * vnoise.z - 1.0;
    return vnoise;
  }

  @Override
  public String toString() {
    return "PerlinNoise3D [toString()=" + super.toString() + "]";
  }

}
