/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.extensions;

 /**
  * File name filter for Kandid populations.
  * @author thomas jourdan
  */
public class KandidFilenameFilter implements java.io.FilenameFilter {
  private String prefix;
  private String postfix;

  /**
   * Creates new KandidFilenameFilter.
   * @param prefix
   * @param postfix
   */
  public KandidFilenameFilter(String prefix, String postfix) {
    this.prefix = prefix + "_";
    this.postfix = postfix;
  }

  /**
   * Accepts only files starting with a given prefix and ends with postfix.
   *
   * @param file the directory in which the file was found.
   * @param str the name of the file.
   *
   * @return
   */
  public boolean accept(java.io.File file, java.lang.String str) {
    if (file.canRead()) {
      return str.startsWith(prefix) && str.endsWith(postfix);
    }
    return false;
  }
}
