/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.extensions;

import java.io.File;
import java.util.Collections;

import kandid.Kandid;
import kandid.util.Debug;


public class FileList {

  /**
   * Method crawlDir.
   * @param home
   * @param kpopList
   */
  private static void crawlDir(String home, String typeName, String extension, java.util.List<String> kpopList) {
    File currDir = new File(home);
    String[] dirList = currDir.list();
    if (dirList != null) {
      int entries = 0;
      while (entries < dirList.length) {
        String fname = home + "/" + dirList[entries];
        File currEntry = new File(fname);
        if (currEntry.isDirectory()) {
          if (Debug.enabled) System.out.println("D " + fname);
          crawlDir(fname, typeName, extension, kpopList);
        }
        ++entries;
      }
    }
    String[] fileList = currDir.list(new KandidFilenameFilter(typeName, extension));
    if (fileList != null) {
      int entries = 0;
      while (entries < fileList.length) {
        File currEntry = new File(fileList[entries]);
        if (!currEntry.isDirectory()) {
          String fname = home + "/" + currEntry.getPath();
          if (Debug.enabled) System.out.println("F " + fname);
          kpopList.add(fname);
        }
        ++entries;
      }
    }
  }

  /**
   * Method createPopulationList
   */
  public static java.util.ArrayList<String> createImageList(String root, String typeName, String extension) {
    java.util.ArrayList<String> kpopList = new java.util.ArrayList<>();
    FileList.crawlDir(root, typeName, extension, kpopList);
    Collections.sort(kpopList);
    Collections.reverse(kpopList);
    return kpopList;
  }

}
