/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.extensions;

import junit.framework.TestCase;
import kandid.Kandid;
import kandid.colorator.Colorator;

/**
 * 
 * @author thomas jourdan
 */
public class ExportStateTest extends TestCase {

  /**
   * Constructor for ExportStateTest.
   * 
   * @param arg0
   */
  public ExportStateTest(String arg0) {
    super(arg0);
  }

  public void testGetPath() {
    ExportState exportState = new ExportState();
    exportState.setFullname("DirectLca_RGB_dfy932bg_dfy932gf_x156_y156.kimg");
    assertEquals("filebase/DirectLca/RGB/dfy932bg/", exportState.getPath(Kandid.localImageFolder));
  }

  public void testGetFullname() {
    ExportState exportState = new ExportState();
    exportState.setFullname("DirectLca_RGB_dfy932bg_dfy932gf_x156_y156.kimg");
    assertEquals("DirectLca_RGB_dfy932bg_dfy932gf_x156_y156.kimg", exportState.getFullname());
  }

  public void testGetFilename() {
    ExportState exportState = new ExportState();
    exportState.setFullname("DirectLca_RGB_dfy932bg_dfy932gf_x156_y156.kimg");
    assertEquals("DirectLca_RGB_dfy932bg_dfy932gf_x156_y156", exportState.getFilename());
  }

  public void testGetExtension() {
    ExportState exportState = new ExportState();
    exportState.setFullname("DirectLca_RGB_dfy932bg_dfy932gf_x156_y156.kimg");
    assertEquals("kimg", exportState.getExtension());
  }

  public void testGetFullname2() {
    ExportState exportState = new ExportState();
    try {
      Class cc = Class.forName("kandid.colorator.GradientColorator");
      Colorator colorator = (Colorator) cc.getDeclaredConstructor().newInstance();
      String coloratorShortName = colorator.getShortName();
      exportState.setFullname("ScalarExpression_dvnueewj_dvnueftt", coloratorShortName);
      assertEquals("incoming/ScalarExpression/Grad/dvnueewj/", exportState.getPath(Kandid.incomingImageFolder));
      assertEquals("ScalarExpression_Grad_dvnueewj_dvnueftt", exportState.getFilename());
    } catch (Exception exc) {
      fail();
    }

  }

}