/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.extensions;

import java.awt.image.BufferedImage;

import kandid.Gateway;
import kandid.colorator.Colorator;
import kandid.soup.ChromosomeType;

/**
 * Base class for exporting to different file formats
 * @author thomas jourdan
 */
public abstract class ExportEngine {
  protected ChromosomeType       chromosome;
  protected String      calculationName;
  protected Colorator   colorator;
  protected ExportState exportState;
  protected Thread      engine;    // Thread calculating image
  protected Gateway     gw;
  protected BufferedImage bufferedImage;


  /**
   * Constructor ExportEngine
   */
  public ExportEngine() {
    engine = null;
  }

  /**
   * Constructor ExportEngine
   *
   * @param chromosome chromosome of this image
   * @param calculationName name of the calculation for this image
   * @param colorator color strategy for this image
   * @param exportState detail information like file name and size
   */
  public ExportEngine(ChromosomeType chromosome, String calculationName, Colorator colorator, ExportState exportState) {
    this.chromosome      = chromosome;
    this.calculationName = calculationName;
    this.colorator       = colorator;
    this.exportState     = exportState;
    gw                   = new Gateway();
  }

}