/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.colorator;

import junit.framework.TestCase;

/**
 * 
 * @author thomas jourdan
 */
public class LookUpTableColoratorTest extends TestCase {

  /**
   * Constructor for LookUpTableColoratorTest.
   * @param arg0
   */
  public LookUpTableColoratorTest(String arg0) {
    super(arg0);
  }

  public void testDiffHue() {
    final double epsilon = 1E-5;
    assertEquals(0.0,  LookUpTableColorator.diffHue(0.0,  1.0), epsilon);
    assertEquals(0.0,  LookUpTableColorator.diffHue(1.0,  0.0), epsilon);
    assertEquals(0.0,  LookUpTableColorator.diffHue(0.0,  0.0), epsilon);
    assertEquals(0.0,  LookUpTableColorator.diffHue(1.0,  1.0), epsilon);
    assertEquals(0.5,  LookUpTableColorator.diffHue(0.0,  0.5), epsilon);
    assertEquals(0.49, LookUpTableColorator.diffHue(0.0,  0.49), epsilon);
    assertEquals(0.49, LookUpTableColorator.diffHue(0.49, 0.0),  epsilon);
    assertEquals(0.0,  LookUpTableColorator.diffHue(0.49, 0.49), epsilon);
    assertEquals(0.02, LookUpTableColorator.diffHue(0.01, 0.99), epsilon);
    assertEquals(0.02, LookUpTableColorator.diffHue(0.99, 0.01), epsilon);
  }

  public void testIsMinDiffCW() {
    assertEquals(false, LookUpTableColorator.isMinDiffCW(0.0F,    0.0F));
    assertEquals(false, LookUpTableColorator.isMinDiffCW(0.0F,    1.0F));    
    assertEquals(false, LookUpTableColorator.isMinDiffCW(1.0F,    0.0F));    
    // test CW
    assertEquals(true, LookUpTableColorator.isMinDiffCW(0.95F,  0.15F));    
    assertEquals(true, LookUpTableColorator.isMinDiffCW(0.45F,  0.55F));    
    assertEquals(true, LookUpTableColorator.isMinDiffCW(0.45F,  0.55F));    
    assertEquals(true, LookUpTableColorator.isMinDiffCW(0.45F,  0.55F));    
    assertEquals(true, LookUpTableColorator.isMinDiffCW(0.9F,   0.95F));    
    // test CCW
    assertEquals(false, LookUpTableColorator.isMinDiffCW(0.15F,  0.95F));    
    assertEquals(false, LookUpTableColorator.isMinDiffCW(0.55F,  0.45F));    
    assertEquals(false, LookUpTableColorator.isMinDiffCW(0.95F,  0.9F));    
  }

}
