/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.colorator;

import kandid.genomedb.ChromosomeType;
import kandid.soup.HsbFrequenceChromosome;

/**
 *
 * @author thomas jourdan
 * @version
 */
public class HsbFrequenceColorator implements Colorator {

  private double phaseshift;
	private double frequence;

	public void getColor(double hue, double saturation, double brightness, ColorF32 cout) {
    assert cout != null;
    if(saturation < 0.0)
      saturation = 0.0;
    else if(saturation > 1.0)
      saturation = 1.0;
    if(brightness < 0.0)
      brightness = 0.0;
    else if(brightness > 1.0)
      brightness = 1.0;
    ColorF32 hsb = new ColorF32((float)(frequence*hue+phaseshift), (float)saturation, (float)brightness);
    ColorF32.hsb2rgb(hsb, cout);
  }
  
  /**
   * Convert brightness to gray scale
   * @param brightness a value between 0.0 (inclusive) and 1.0 (exclusive).
   */
  public void getColor(double brightness, ColorF32 cout) {
    assert cout != null;
    float gray;
    if (brightness > 1.0) {
      gray = 1.0f;
    }
    else if (brightness < 0.0) {
      gray = 0.0f;
    }
    else {
      gray = (float)brightness;
    }
    cout.r = gray;
    cout.g = gray;
    cout.b = gray;
  }

  /**
   * Method getColor.
   * @param colorGene
   */
  public void getColor(kandid.soup.ColorGene colorGene, ColorF32 cout) {
    // don't implement
    // don't implement
    assert cout != null;
    cout.r = 0.0f;
    cout.g = 0.0f;
    cout.b = 0.0f;
  }

  /**
   * Method getColor.
   * @param color
   */
  public void getColor(java.awt.Color color, ColorF32 cout) {
    // don't implement
    assert cout != null;
    cout.r = 0.0f;
    cout.g = 0.0f;
    cout.b = 0.0f;
  }

  /**
   * Method getShortName.
   * @return String
   */
  public String getShortName() {
    return "HSBF";
  }

  /**
   * @see kandid.colorator.Colorator#setColorTable(ChromosomeType)
   */
  public void setColorTable(kandid.soup.ChromosomeType colorTable) {
    frequence = ((HsbFrequenceChromosome)colorTable).getFrequence().getValue();
    phaseshift = ((HsbFrequenceChromosome)colorTable).getPhaseshift().getValue();
  }

  /**
   * not implemented. Makes no sense in this context
   * @see kandid.colorator.Colorator#getDiscretColor(int, ColorF32)
   */
  public void getDiscretColor(int index, ColorF32 cout) {
    // don't implement
    assert cout != null;
    cout.r = 0.0f;
    cout.g = 0.0f;
    cout.b = 0.0f;
  }

  /**
   * not implemented. Makes no sense in this context
   * @see kandid.colorator.Colorator#getNumberOfDiscretColors(int)
   */
  public int getNumberOfDiscretColors() {
    // don't implement
    return 0;
  }

}
