/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.colorator;

import junit.framework.TestCase;

/**
 * 
 * @author thomas jourdan
 */
public class GradientColoratorTest extends TestCase {

  final double epsilon = 1E-5;

  /**
   * Constructor for GradientColoratorTest.
   * @param arg0
   */
  public GradientColoratorTest(String arg0) {
    super(arg0);
  }

  public void testInterpolate() {
    assertEquals(0.0,    GradientColorator.interpolate(0.0F,  0.0F, 1.0-0.0), epsilon);    
    assertEquals(0.5,    GradientColorator.interpolate(0.0F,  1.0F, 1.0-0.5), epsilon);    
    assertEquals(1.0,    GradientColorator.interpolate(0.95F, 1.0F, 1.0-1.0), epsilon);    
    assertEquals(0.95,   GradientColorator.interpolate(0.95F, 1.0F, 1.0-0.0), epsilon);    
    assertEquals(0.9975, GradientColorator.interpolate(0.95F, 1.0F, 1.0-0.95),epsilon);    
  }

  public void testInterpolateHue() {
    assertEquals(0.0, GradientColorator.interpolateHue(0.0F,    0.0F,  1.0),  epsilon);
    assertEquals(0.0, GradientColorator.interpolateHue(0.0F,    1.0F,  0.5),  epsilon);    
    assertEquals(0.0, GradientColorator.interpolateHue(1.0F,    0.0F,  0.5),  epsilon);    
    // test CW
    assertEquals(0.05, GradientColorator.interpolateHue(0.95F,  0.15F, 0.5), epsilon);    
    assertEquals(0.45, GradientColorator.interpolateHue(0.45F,  0.55F, 1.0), epsilon);    
    assertEquals(0.50, GradientColorator.interpolateHue(0.45F,  0.55F, 0.5), epsilon);    
    assertEquals(0.55, GradientColorator.interpolateHue(0.45F,  0.55F, 0.0), epsilon);    
    assertEquals(0.925, GradientColorator.interpolateHue(0.9F,  0.95F, 0.5), epsilon);    
    // test CCW
    assertEquals(0.05, GradientColorator.interpolateHue(0.15F,  0.95F, 0.5), epsilon);    
    assertEquals(0.5, GradientColorator.interpolateHue(0.55F,   0.45F, 0.5), epsilon);    
    assertEquals(0.925, GradientColorator.interpolateHue(0.95F,  0.9F, 0.5), epsilon);    
  }

}
