/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.voronoi;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import kandid.soup.*;
import kandid.colorator.ColorF32;

/**
 * @author thomas jourdan
 */
public class VoronoiCalculation extends VoronoiCalculationBase implements Cloneable {
  protected ColorF32 intPalette[];
  protected double yard;

  /* For documentation please see super class RefinementCalculation. */
  public void activateCanvas(Component viewComponent, Dimension canvasSize, boolean zoomMode) {
    super.activateCanvas(viewComponent, canvasSize, zoomMode);
    VoronoiChromosome voronoiChromosome = (VoronoiChromosome) chromosome;
    yard = voronoiChromosome.getYard().getValue();

    List<KingGene> kingList = voronoiChromosome.getKing();
    numberOfKings = kingList.size();
    intPalette = new ColorF32[numberOfKings];
    for (int kx = 0; kx < numberOfKings; ++kx) {
      KingGene kingGene = kingList.get(kx);
      intPalette[kx] = new ColorF32();
      colorator.getColor(kingGene.getColor(), intPalette[kx]);
    }

  }

  /* For documentation please see super class RefinementCalculation. */
  public void calculate(boolean paintOnScreen, String doExport) {
    if (enterDepth()) {
      while (more) {
        double nearestDistance = Double.MAX_VALUE;
        int nearestKing = 0;
        int kx = numberOfKings;
        while (kx > 0) {
          --kx;
          double dist = kw[kx] * distance(kx);
          if (yard > 0.0) {
            if (dist < yard)
              dist = 0.0;
            else
              dist = dist - yard;
          }
          if (dist < nearestDistance) {
            nearestDistance = dist;
            nearestKing = kx;
          }
        }
        setPixel(intPalette[nearestKing]);
        nextLocation();
      }
    }
  }

  public boolean hasWhiteBackground() {
    return false;
  }
}
