// This file was generated by the vectorvm.xsl style sheet.
// Any modifications to this file will be lost upon recompilation of the style sheet or the source schema.
package kandid.calculation.vm.vector;

import java.util.Random;

import javax.vecmath.Vector3d;

import kandid.soup.ExprVectorArgsListGene;
import kandid.soup.ExprVectorConstGene;
import kandid.soup.ExprVectorListGene;
import kandid.soup.ExprVectorOprBase;
import kandid.soup.ExprVectorOprGene;
import kandid.soup.ExprVectorVarBase;
import kandid.soup.ExprVectorVarGene;
import kandid.soup.VectorExprGene;
import kandid.calculation.vm.scalar.ScalarVM;
import kandid.util.PovNoise;

public class VectorVM {
  private static final int maxTapeLen = 16 * 1024;
  protected int codeTape[];
  protected int iOper[];
  protected double xOper[];
  protected double yOper[];
  protected double zOper[];
  protected int tapeLength;
  protected double xStack[] = new double[128];
  protected double yStack[] = new double[128];
  protected double zStack[] = new double[128];
  protected PovNoise povNoise;
  protected double[] aList = new double[6];
  protected Random aListRandomAccess = new Random();
  protected static final int oprStop = 0;
  protected static final int oprPop = 1;
  protected static final int oprPushConst = 2;
  protected static final int oprPushAccu = 3;
  protected static final int oprPushXYT = 4;
  protected static final int oprPushXYR = 5;
  protected static final int oprPushXYM = 6;
  protected static final int oprIf = 7;
  protected static final int oprJmp = 8;
  protected static final int oprAdd = (oprJmp + 1);
  protected static final int oprSub = (oprJmp + 2);
  protected static final int oprMult = (oprJmp + 3);
  protected static final int oprMod = (oprJmp + 4);
  protected static final int oprCross = (oprJmp + 5);
  protected static final int oprSincos = (oprJmp + 6);
  protected static final int oprAtan = (oprJmp + 7);
  protected static final int oprMaxvalue = (oprJmp + 8);
  protected static final int oprMinvalue = (oprJmp + 9);
  protected static final int oprMaxvector = (oprJmp + 10);
  protected static final int oprMinvector = (oprJmp + 11);
  protected static final int oprMaxmix = (oprJmp + 12);
  protected static final int oprInvmix = (oprJmp + 13);
  protected static final int oprStep = (oprJmp + 14);
  protected static final int oprNoise = (oprJmp + 15);
  protected static final int oprTurbulence = (oprJmp + 16);
  protected static final int oprWaves = (oprJmp + 17);

  public VectorVM(long seed) {
    povNoise = new PovNoise(seed);
  }

  /**
   * Method compile.
   * 
   * @param vectorExprGene
   */
  public void compile(VectorExprGene vectorExprGene) {
    codeTape = new int[maxTapeLen];
    iOper = new int[maxTapeLen];
    xOper = new double[maxTapeLen];
    yOper = new double[maxTapeLen];
    zOper = new double[maxTapeLen];
    tapeLength = 0;
    compile0(vectorExprGene);
    codeTape[tapeLength] = oprStop;
    ++tapeLength;
  }

  /**
   * Method compile0.
   * 
   * @param vectorExprGene
   */
  private void compile0(VectorExprGene vectorExprGene) {
    ExprVectorListGene exprListGene = vectorExprGene.getList();
    ExprVectorOprGene opr = exprListGene.getOpr();
    ExprVectorArgsListGene args = exprListGene.getArgs();
    java.util.List argsList = args.getVarOrConstOrVectorExpression();
    int argsLen = argsList.size();
    assert argsLen > 0 : "argument list to short " + argsLen;
    if (false) {
      assert false : "code should never be reached";
    } else if (opr.getVectorOpr().equals(ExprVectorOprBase.ADD)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprAdd;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getVectorOpr().equals(ExprVectorOprBase.SUB)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprSub;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getVectorOpr().equals(ExprVectorOprBase.MULT)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprMult;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getVectorOpr().equals(ExprVectorOprBase.MOD)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprMod;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getVectorOpr().equals(ExprVectorOprBase.CROSS)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprCross;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getVectorOpr().equals(ExprVectorOprBase.SINCOS)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprSincos;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getVectorOpr().equals(ExprVectorOprBase.ATAN)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprAtan;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getVectorOpr().equals(ExprVectorOprBase.MAXVALUE)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprMaxvalue;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getVectorOpr().equals(ExprVectorOprBase.MINVALUE)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprMinvalue;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getVectorOpr().equals(ExprVectorOprBase.MAXVECTOR)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprMaxvector;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getVectorOpr().equals(ExprVectorOprBase.MINVECTOR)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprMinvector;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getVectorOpr().equals(ExprVectorOprBase.MAXMIX)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprMaxmix;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getVectorOpr().equals(ExprVectorOprBase.INVMIX)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprInvmix;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getVectorOpr().equals(ExprVectorOprBase.STEP)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprStep;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getVectorOpr().equals(ExprVectorOprBase.NOISE)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprNoise;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getVectorOpr().equals(ExprVectorOprBase.TURBULENCE)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprTurbulence;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getVectorOpr().equals(ExprVectorOprBase.WAVES)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprWaves;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else {
      assert false : "invalid operator " + opr.getVectorOpr();
    }
  }

  /**
   * @param obj
   */
  private void compileElement(Object obj) {
    if (obj instanceof ExprVectorVarGene) {
      ExprVectorVarGene var = (ExprVectorVarGene) obj;
      if (var.getVectorVar().equals(ExprVectorVarBase.XYT)) {
        codeTape[tapeLength++] = oprPushXYT;
      } else if (var.getVectorVar().equals(ExprVectorVarBase.XYR)) {
        codeTape[tapeLength++] = oprPushXYR;
      } else if (var.getVectorVar().equals(ExprVectorVarBase.XYM)) {
        codeTape[tapeLength++] = oprPushXYM;
      } else {
        assert false : "invalid var compiling vector expression" + var.getVectorVar();
      }
    } else if (obj instanceof ExprVectorConstGene) {
      ExprVectorConstGene aConst = (ExprVectorConstGene) obj;
      codeTape[tapeLength] = oprPushConst;
      xOper[tapeLength] = aConst.getCx().getValue();
      yOper[tapeLength] = aConst.getCy().getValue();
      zOper[tapeLength] = aConst.getCz().getValue();
      ++tapeLength;
    } else if (obj instanceof VectorExprGene) {
      VectorExprGene vectorExpressionArg = (VectorExprGene) obj;
      compile0(vectorExpressionArg);
      codeTape[tapeLength++] = oprPushAccu;
    } else {
      assert false : "invalid object compiling vector expression" + obj.getClass().getName();
    }
  }

  /**
   * Executes code tape and returns the result from accumulator.
   * 
   * @param x
   * @param y
   * @param t
   * @param result
   */
  public void execute(double x, double y, double t, Vector3d result) {
    double xi = -x;
    double yi = -y;
    double r = Math.sqrt(x * x + y * y);
    double m = Math.abs(x) + Math.abs(y);
    double xAccu = 0.0;
    double yAccu = 0.0;
    double zAccu = 0.0;
    int tos = 0;
    int ip = 0;
    int argLength = 0;
    while (ip < tapeLength) {
      switch (codeTape[ip]) {
      case oprStop:
        result.x = xAccu;
        result.y = yAccu;
        result.z = zAccu;
        return;
      case oprPop:
        --tos;
        xAccu = xStack[tos];
        yAccu = yStack[tos];
        zAccu = zStack[tos];
        break;
      case oprPushConst:
        xStack[tos] = xOper[ip];
        yStack[tos] = yOper[ip];
        zStack[tos] = zOper[ip];
        tos++;
        break;
      case oprPushAccu:
        xStack[tos] = xAccu;
        yStack[tos] = yAccu;
        zStack[tos] = zAccu;
        tos++;
        break;
      case oprPushXYT:
        xStack[tos] = x;
        yStack[tos] = y;
        zStack[tos] = t;
        tos++;
        break;
      case oprPushXYR:
        xStack[tos] = x;
        yStack[tos] = y;
        zStack[tos] = r;
        tos++;
        break;
      case oprPushXYM:
        xStack[tos] = x;
        yStack[tos] = y;
        zStack[tos] = m;
        tos++;
        break;
      case oprJmp:
        ip = iOper[ip] - 1;
        break;
      case oprAdd:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'add' should be 2."; {
        xAccu = xStack[tos - 1] + xStack[tos - 2];
        yAccu = yStack[tos - 1] + yStack[tos - 2];
        zAccu = zStack[tos - 1] + zStack[tos - 2];
      }
        tos -= 2;
        break;
      case oprSub:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'sub' should be 2."; {
        xAccu = xStack[tos - 1] - xStack[tos - 2];
        yAccu = yStack[tos - 1] - yStack[tos - 2];
        zAccu = zStack[tos - 1] - zStack[tos - 2];
      }
        tos -= 2;
        break;
      case oprMult:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'mult' should be 2."; {
        xAccu = xStack[tos - 1] * xStack[tos - 2];
        yAccu = yStack[tos - 1] * yStack[tos - 2];
        zAccu = zStack[tos - 1] * zStack[tos - 2];
      }
        tos -= 2;
        break;
      case oprMod:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'mod' should be 2."; {
        if (Math.abs(xStack[tos - 2]) > ScalarVM.epsilon) {
          long n = (long) (xStack[tos - 1] / xStack[tos - 2]);
          xAccu = xStack[tos - 1] - n * xStack[tos - 2];
          if (xAccu < 0.0)
            xAccu += xStack[tos - 2];
        } else
          xAccu = 0.0;
        if (Math.abs(yStack[tos - 2]) > ScalarVM.epsilon) {
          long n = (long) (yStack[tos - 1] / yStack[tos - 2]);
          yAccu = yStack[tos - 1] - n * yStack[tos - 2];
          if (yAccu < 0.0)
            yAccu += yStack[tos - 2];
        } else
          yAccu = 0.0;
        if (Math.abs(zStack[tos - 2]) > ScalarVM.epsilon) {
          long n = (long) (zStack[tos - 1] / zStack[tos - 2]);
          zAccu = zStack[tos - 1] - n * zStack[tos - 2];
          if (zAccu < 0.0)
            zAccu += zStack[tos - 2];
          zAccu = zStack[tos - 1];
        } else
          zAccu = 0.0;
      }
        tos -= 2;
        break;
      case oprCross:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'cross' should be 2."; {
        xAccu = yStack[tos - 1] * zStack[tos - 2] - zStack[tos - 1] * yStack[tos - 2];
        yAccu = zStack[tos - 1] * xStack[tos - 2] - xStack[tos - 1] * zStack[tos - 2];
        zAccu = xStack[tos - 1] * yStack[tos - 2] - yStack[tos - 1] * xStack[tos - 2];
      }
        tos -= 2;
        break;
      case oprSincos:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'sincos' should be 2."; {
        xAccu = Math.sin(Math.PI * xStack[tos - 1]) + Math.cos(Math.PI * xStack[tos - 2]);
        yAccu = Math.sin(Math.PI * yStack[tos - 1]) + Math.cos(Math.PI * yStack[tos - 2]);
        zAccu = Math.sin(Math.PI * zStack[tos - 1]) + Math.cos(Math.PI * zStack[tos - 2]);
      }
        tos -= 2;
        break;
      case oprAtan:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'atan' should be 2."; {
        xAccu = Math.atan2(xStack[tos - 1], xStack[tos - 2]) / Math.PI;
        yAccu = Math.atan2(yStack[tos - 1], yStack[tos - 2]) / Math.PI;
        zAccu = Math.atan2(zStack[tos - 1], zStack[tos - 2]) / Math.PI;
      }
        tos -= 2;
        break;
      case oprMaxvalue:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'maxvalue' should be 2."; {
        xAccu = xStack[tos - 1] > xStack[tos - 2] ? xStack[tos - 1] : xStack[tos - 2];
        yAccu = yStack[tos - 1] > yStack[tos - 2] ? yStack[tos - 1] : yStack[tos - 2];
        zAccu = zStack[tos - 1] > zStack[tos - 2] ? zStack[tos - 1] : zStack[tos - 2];
      }
        tos -= 2;
        break;
      case oprMinvalue:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'minvalue' should be 2."; {
        xAccu = xStack[tos - 1] < xStack[tos - 2] ? xStack[tos - 1] : xStack[tos - 2];
        yAccu = yStack[tos - 1] < yStack[tos - 2] ? yStack[tos - 1] : yStack[tos - 2];
        zAccu = zStack[tos - 1] < zStack[tos - 2] ? zStack[tos - 1] : zStack[tos - 2];
      }
        tos -= 2;
        break;
      case oprMaxvector:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'maxvector' should be 2."; {
        if ((xStack[tos - 1] * xStack[tos - 1] + yStack[tos - 1] * yStack[tos - 1] + zStack[tos - 1] * zStack[tos - 1]) > (xStack[tos - 2] * xStack[tos - 2] + yStack[tos - 2] * yStack[tos - 2] + zStack[tos - 2] * zStack[tos - 2])) {
          xAccu = xStack[tos - 1];
          yAccu = yStack[tos - 1];
          zAccu = zStack[tos - 1];
        } else {
          xAccu = xStack[tos - 2];
          yAccu = yStack[tos - 2];
          zAccu = zStack[tos - 2];
        }
      }
        tos -= 2;
        break;
      case oprMinvector:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'minvector' should be 2."; {
        if ((xStack[tos - 1] * xStack[tos - 1] + yStack[tos - 1] * yStack[tos - 1] + zStack[tos - 1] * zStack[tos - 1]) < (xStack[tos - 2] * xStack[tos - 2] + yStack[tos - 2] * yStack[tos - 2] + zStack[tos - 2] * zStack[tos - 2])) {
          xAccu = xStack[tos - 1];
          yAccu = yStack[tos - 1];
          zAccu = zStack[tos - 1];
        } else {
          xAccu = xStack[tos - 2];
          yAccu = yStack[tos - 2];
          zAccu = zStack[tos - 2];
        }
      }
        tos -= 2;
        break;
      case oprMaxmix:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'maxmix' should be 2."; {
        double l1 = (xStack[tos - 1] * xStack[tos - 1] + yStack[tos - 1] * yStack[tos - 1] + zStack[tos - 1] * zStack[tos - 1]);
        double l2 = (xStack[tos - 2] * xStack[tos - 2] + yStack[tos - 2] * yStack[tos - 2] + zStack[tos - 2] * zStack[tos - 2]);
        double h = l1 / (l1 + l2);
        xAccu = h * xStack[tos - 1] + (1 - h) * xStack[tos - 2];
        yAccu = h * yStack[tos - 1] + (1 - h) * yStack[tos - 2];
        zAccu = h * zStack[tos - 1] + (1 - h) * zStack[tos - 2];
      }
        tos -= 2;
        break;
      case oprInvmix:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'invmix' should be 2."; {
        double l1 = (xStack[tos - 1] * xStack[tos - 1] + yStack[tos - 1] * yStack[tos - 1] + zStack[tos - 1] * zStack[tos - 1]);
        double l2 = (xStack[tos - 2] * xStack[tos - 2] + yStack[tos - 2] * yStack[tos - 2] + zStack[tos - 2] * zStack[tos - 2]);
        double h = l1 / (l1 + l2);
        xAccu = (1 - h) * xStack[tos - 1] + h * xStack[tos - 2];
        yAccu = (1 - h) * yStack[tos - 1] + h * yStack[tos - 2];
        zAccu = (1 - h) * zStack[tos - 1] + h * zStack[tos - 2];
      }
        tos -= 2;
        break;
      case oprStep:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'step' should be 2."; {
        xAccu = xStack[tos - 1] > xStack[tos - 2] ? 1.0 : -1.0;
        yAccu = yStack[tos - 1] > yStack[tos - 2] ? 1.0 : -1.0;
        zAccu = zStack[tos - 1] > zStack[tos - 2] ? 1.0 : -1.0;
      }
        tos -= 2;
        break;
      case oprNoise:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'noise' should be 2."; {
        Vector3d vr = povNoise.getDNoise(xStack[tos - 2] * xStack[tos - 1], yStack[tos - 2] * yStack[tos - 1], zStack[tos - 2] * zStack[tos - 1]);
        xAccu = vr.x;
        yAccu = vr.y;
        zAccu = vr.z;
      }
        tos -= 2;
        break;
      case oprTurbulence:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'turbulence' should be 2."; {
        int octaves = (int) Math.log(1.0 + (1.0 / (Math.abs(xStack[tos - 2]) + ScalarVM.epsilon)) + (1.0 / (Math.abs(yStack[tos - 2]) + ScalarVM.epsilon)) + (1.0 / (Math.abs(zStack[tos - 2]) + ScalarVM.epsilon)) + (1.0 / (Math.abs(xStack[tos - 1]) + ScalarVM.epsilon))
            + (1.0 / (Math.abs(yStack[tos - 1]) + ScalarVM.epsilon)) + (1.0 / (Math.abs(zStack[tos - 1]) + ScalarVM.epsilon)));
        octaves = octaves > 7 ? 8 : octaves + 1;
        Vector3d vr = povNoise.getDTurbulence(xStack[tos - 2] * xStack[tos - 1], yStack[tos - 2] * yStack[tos - 1], zStack[tos - 2] * zStack[tos - 1], octaves);
        xAccu = vr.x;
        yAccu = vr.y;
        zAccu = vr.z;
      }
        tos -= 2;
        break;
      case oprWaves:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'waves' should be 2."; {
        int numberOfWaves = (int) Math.log(1.0 + (1.0 / (Math.abs(xStack[tos - 2]) + ScalarVM.epsilon)) + (1.0 / (Math.abs(yStack[tos - 2]) + ScalarVM.epsilon)) + (1.0 / (Math.abs(zStack[tos - 2]) + ScalarVM.epsilon)) + (1.0 / (Math.abs(xStack[tos - 1]) + ScalarVM.epsilon))
            + (1.0 / (Math.abs(yStack[tos - 1]) + ScalarVM.epsilon)) + (1.0 / (Math.abs(zStack[tos - 1] + ScalarVM.epsilon))));
        Vector3d vr = povNoise.getWaves(xStack[tos - 2] * xStack[tos - 1], xStack[tos - 2] * yStack[tos - 1], xStack[tos - 2] * zStack[tos - 1], yStack[tos - 2], zStack[tos - 2], numberOfWaves);
        xAccu = vr.x;
        yAccu = vr.y;
        zAccu = vr.z;
      }
        tos -= 2;
        break;
      default:
        assert false : "invalid code " + codeTape[ip] + " on tape position " + ip;
        break;
      }
      ++ip;
    }
    result.x = xAccu;
    result.y = yAccu;
    result.z = zAccu;
    return;
  }

  /**
   * @see java.lang.Object#toString()
   */
  public String toString() {
    StringBuffer asm = new StringBuffer();
    int argLength = 0;
    int ip = 0;
    while (ip < tapeLength) {
      asm.append(ip + "\t");
      switch (codeTape[ip]) {
      case oprStop:
        asm.append("stop");
        break;
      case oprPop:
        asm.append("pop");
        break;
      case oprPushConst:
        asm.append("pushConst\t");
        asm.append(xOper[ip]);
        asm.append('\t');
        asm.append(yOper[ip]);
        asm.append('\t');
        asm.append(zOper[ip]);
        break;
      case oprPushAccu:
        asm.append("pushAccu");
        break;
      case oprPushXYT:
        asm.append("pushXYT");
        break;
      case oprPushXYR:
        asm.append("pushXYR");
        break;
      case oprPushXYM:
        asm.append("pushXYM");
        break;
      case oprJmp:
        asm.append("jmp\t");
        asm.append(iOper[ip]);
        break;
      case oprAdd:
        asm.append("add\t");
        asm.append(iOper[ip]);
        break;
      case oprSub:
        asm.append("sub\t");
        asm.append(iOper[ip]);
        break;
      case oprMult:
        asm.append("mult\t");
        asm.append(iOper[ip]);
        break;
      case oprMod:
        asm.append("mod\t");
        asm.append(iOper[ip]);
        break;
      case oprCross:
        asm.append("cross\t");
        asm.append(iOper[ip]);
        break;
      case oprSincos:
        asm.append("sincos\t");
        asm.append(iOper[ip]);
        break;
      case oprAtan:
        asm.append("atan\t");
        asm.append(iOper[ip]);
        break;
      case oprMaxvalue:
        asm.append("maxvalue\t");
        asm.append(iOper[ip]);
        break;
      case oprMinvalue:
        asm.append("minvalue\t");
        asm.append(iOper[ip]);
        break;
      case oprMaxvector:
        asm.append("maxvector\t");
        asm.append(iOper[ip]);
        break;
      case oprMinvector:
        asm.append("minvector\t");
        asm.append(iOper[ip]);
        break;
      case oprMaxmix:
        asm.append("maxmix\t");
        asm.append(iOper[ip]);
        break;
      case oprInvmix:
        asm.append("invmix\t");
        asm.append(iOper[ip]);
        break;
      case oprStep:
        asm.append("step\t");
        asm.append(iOper[ip]);
        break;
      case oprNoise:
        asm.append("noise\t");
        asm.append(iOper[ip]);
        break;
      case oprTurbulence:
        asm.append("turbulence\t");
        asm.append(iOper[ip]);
        break;
      case oprWaves:
        asm.append("waves\t");
        asm.append(iOper[ip]);
        break;
      default:
        asm.append("invalid code\t");
        asm.append(iOper[ip]);
        assert false : "invalid code " + codeTape[ip] + " on tape position " + ip;
        break;
      }
      asm.append('\n');
      ++ip;
    }
    return asm.toString();
  }
}
