// This file was generated by the scalarvm.xsl style sheet.
// Any modifications to this file will be lost upon recompilation of the style sheet or the source schema.
package kandid.calculation.vm.scalar;

import kandid.soup.ExprScalarArgsListGene;
import kandid.soup.ExprScalarConstGene;
import kandid.soup.ExprScalarListGene;
import kandid.soup.ExprScalarOprBase;
import kandid.soup.ExprScalarOprGene;
import kandid.soup.ExprScalarVarBase;
import kandid.soup.ExprScalarVarGene;
import kandid.soup.ScalarExprGene;
import kandid.util.PovNoise;

public class ScalarVM {
  private static final int maxTapeLen = 16 * 1024;
  protected int codeTape[];
  protected int iOper[];
  protected double dOper[];
  protected int tapeLength;
  protected double dStack[] = new double[1024];
  protected PovNoise povNoise;
  public static final double epsilon = 1E-10;
  protected static final int oprStop = 0;
  protected static final int oprPop = 1;
  protected static final int oprPushConst = 2;
  protected static final int oprPushAccu = 3;
  protected static final int oprPushX = 4;
  protected static final int oprPushY = 5;
  protected static final int oprPushXI = 6;
  protected static final int oprPushYI = 7;
  protected static final int oprPushR = 8;
  protected static final int oprPushRI = 9;
  protected static final int oprPushT = 10;
  protected static final int oprPushTI = 11;
  protected static final int oprIf = 12;
  protected static final int oprJmp = 13;
  protected static final int oprAdd = (oprJmp + 1);
  protected static final int oprMult = (oprJmp + 2);
  protected static final int oprSub = (oprJmp + 3);
  protected static final int oprDiv = (oprJmp + 4);
  protected static final int oprNoise = (oprJmp + 5);
  protected static final int oprTurbulence = (oprJmp + 6);
  protected static final int oprSnoise = (oprJmp + 7);
  protected static final int oprSturbulence = (oprJmp + 8);
  protected static final int oprPow = (oprJmp + 9);
  protected static final int oprSqrt = (oprJmp + 10);
  protected static final int oprTan = (oprJmp + 11);
  protected static final int oprSin = (oprJmp + 12);
  protected static final int oprCos = (oprJmp + 13);
  protected static final int oprAtanq = (oprJmp + 14);
  protected static final int oprAtan = (oprJmp + 15);
  protected static final int oprLog = (oprJmp + 16);
  protected static final int oprMix = (oprJmp + 17);
  protected static final int oprMixx = (oprJmp + 18);
  protected static final int oprStep = (oprJmp + 19);
  protected static final int oprPuls = (oprJmp + 20);
  protected static final int oprClamp = (oprJmp + 21);
  protected static final int oprMax = (oprJmp + 22);
  protected static final int oprMin = (oprJmp + 23);
  protected static final int oprAbs = (oprJmp + 24);
  protected static final int oprSmoothstep = (oprJmp + 25);
  protected static final int oprBoxstep = (oprJmp + 26);
  protected static final int oprMod = (oprJmp + 27);
  protected static final int oprFloor = (oprJmp + 28);
  protected static final int oprCeil = (oprJmp + 29);
  protected static final int oprGamma = (oprJmp + 30);
  protected static final int oprGain = (oprJmp + 31);
  protected static final int oprBias = (oprJmp + 32);
  protected static final int oprEuclide = (oprJmp + 33);
  protected static final int oprAbsolute = (oprJmp + 34);

  public ScalarVM(long seed) {
    povNoise = new PovNoise(seed);
  }

  /**
   * Method compile.
   * 
   * @param scalarExprGene
   */
  public void compile(ScalarExprGene scalarExprGene) {
    codeTape = new int[maxTapeLen];
    iOper = new int[maxTapeLen];
    dOper = new double[maxTapeLen];
    tapeLength = 0;
    compile0(scalarExprGene);
    codeTape[tapeLength] = oprStop;
    ++tapeLength;
  }

  /**
   * Method compile0.
   * 
   * @param scalarExprGene
   */
  private void compile0(ScalarExprGene scalarExprGene) {
    ExprScalarListGene exprListGene = scalarExprGene.getList();
    ExprScalarOprGene opr = exprListGene.getOpr();
    ExprScalarArgsListGene args = exprListGene.getArgs();
    java.util.List argsList = args.getVarOrConstOrScalarExpression();
    int argsLen = argsList.size();
    assert argsLen > 0 : "argument list to short " + argsLen;
    if (opr.getScalarOpr().equals(ExprScalarOprBase.IF_POSITIVE)) {
// condition
      compileElement(argsList.get(0));
      int patchIf = tapeLength;
      codeTape[tapeLength++] = oprIf;
// then
      compileElement(argsList.get(1 % argsLen));
      int patchJmp = tapeLength;
      codeTape[tapeLength++] = oprJmp;
      iOper[patchIf] = tapeLength;
// else
      compileElement(argsList.get(2 % argsLen));
      iOper[patchJmp] = tapeLength;
      codeTape[tapeLength++] = oprPop;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.ADD)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprAdd;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.MULT)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprMult;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.SUB)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprSub;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.DIV)) {
      while (argsLen > 0) {
        --argsLen;
        compileElement(argsList.get(argsLen));
      }
      codeTape[tapeLength] = oprDiv;
      iOper[tapeLength] = argsList.size();
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.NOISE)) {
      int ax = 3;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprNoise;
      iOper[tapeLength] = 3;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.TURBULENCE)) {
      int ax = 4;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprTurbulence;
      iOper[tapeLength] = 4;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.SNOISE)) {
      int ax = 4;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprSnoise;
      iOper[tapeLength] = 4;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.STURBULENCE)) {
      int ax = 5;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprSturbulence;
      iOper[tapeLength] = 5;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.POW)) {
      int ax = 2;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprPow;
      iOper[tapeLength] = 2;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.SQRT)) {
      int ax = 1;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprSqrt;
      iOper[tapeLength] = 1;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.TAN)) {
      int ax = 1;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprTan;
      iOper[tapeLength] = 1;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.SIN)) {
      int ax = 1;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprSin;
      iOper[tapeLength] = 1;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.COS)) {
      int ax = 1;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprCos;
      iOper[tapeLength] = 1;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.ATANQ)) {
      int ax = 2;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprAtanq;
      iOper[tapeLength] = 2;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.ATAN)) {
      int ax = 1;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprAtan;
      iOper[tapeLength] = 1;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.LOG)) {
      int ax = 1;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprLog;
      iOper[tapeLength] = 1;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.MIX)) {
      int ax = 3;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprMix;
      iOper[tapeLength] = 3;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.MIXX)) {
      int ax = 5;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprMixx;
      iOper[tapeLength] = 5;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.STEP)) {
      int ax = 2;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprStep;
      iOper[tapeLength] = 2;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.PULS)) {
      int ax = 3;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprPuls;
      iOper[tapeLength] = 3;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.CLAMP)) {
      int ax = 3;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprClamp;
      iOper[tapeLength] = 3;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.MAX)) {
      int ax = 2;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprMax;
      iOper[tapeLength] = 2;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.MIN)) {
      int ax = 2;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprMin;
      iOper[tapeLength] = 2;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.ABS)) {
      int ax = 1;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprAbs;
      iOper[tapeLength] = 1;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.SMOOTHSTEP)) {
      int ax = 3;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprSmoothstep;
      iOper[tapeLength] = 3;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.BOXSTEP)) {
      int ax = 3;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprBoxstep;
      iOper[tapeLength] = 3;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.MOD)) {
      int ax = 2;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprMod;
      iOper[tapeLength] = 2;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.FLOOR)) {
      int ax = 1;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprFloor;
      iOper[tapeLength] = 1;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.CEIL)) {
      int ax = 1;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprCeil;
      iOper[tapeLength] = 1;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.GAMMA)) {
      int ax = 2;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprGamma;
      iOper[tapeLength] = 2;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.GAIN)) {
      int ax = 2;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprGain;
      iOper[tapeLength] = 2;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.BIAS)) {
      int ax = 2;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprBias;
      iOper[tapeLength] = 2;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.EUCLIDE)) {
      int ax = 4;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprEuclide;
      iOper[tapeLength] = 4;
      ++tapeLength;
    } else if (opr.getScalarOpr().equals(ExprScalarOprBase.ABSOLUTE)) {
      int ax = 4;
      while (ax > 0) {
        --ax;
        compileElement(argsList.get(ax % argsLen));
      }
      codeTape[tapeLength] = oprAbsolute;
      iOper[tapeLength] = 4;
      ++tapeLength;
    } else {
      assert false : "invalid operator " + opr.getScalarOpr();
    }
  }

  /**
   * @param obj
   */
  private void compileElement(Object obj) {
    if (obj instanceof ExprScalarVarGene) {
      ExprScalarVarGene var = (ExprScalarVarGene) obj;
      if (var.getScalarVar().equals(ExprScalarVarBase.X)) {
        codeTape[tapeLength++] = oprPushX;
      } else if (var.getScalarVar().equals(ExprScalarVarBase.Y)) {
        codeTape[tapeLength++] = oprPushY;
      } else if (var.getScalarVar().equals(ExprScalarVarBase.XI)) {
        codeTape[tapeLength++] = oprPushXI;
      } else if (var.getScalarVar().equals(ExprScalarVarBase.YI)) {
        codeTape[tapeLength++] = oprPushYI;
      } else if (var.getScalarVar().equals(ExprScalarVarBase.R)) {
        codeTape[tapeLength++] = oprPushR;
      } else if (var.getScalarVar().equals(ExprScalarVarBase.RI)) {
        codeTape[tapeLength++] = oprPushRI;
      } else if (var.getScalarVar().equals(ExprScalarVarBase.T)) {
        codeTape[tapeLength++] = oprPushT;
      } else if (var.getScalarVar().equals(ExprScalarVarBase.TI)) {
        codeTape[tapeLength++] = oprPushTI;
      } else {
        assert false : "invalid var compiling scalar expression" + var.getScalarVar();
      }
    } else if (obj instanceof ExprScalarConstGene) {
      ExprScalarConstGene aConst = (ExprScalarConstGene) obj;
      codeTape[tapeLength] = oprPushConst;
      dOper[tapeLength] = aConst.getScalarConst().getValue();
      ++tapeLength;
    } else if (obj instanceof ScalarExprGene) {
      ScalarExprGene scalarExpressionArg = (ScalarExprGene) obj;
      compile0(scalarExpressionArg);
      codeTape[tapeLength++] = oprPushAccu;
    } else {
      assert false : "invalid object compiling scalar expression" + obj.getClass().getName();
    }
  }

  /**
   * Executes code tape and returns the result from accumulator.
   * 
   * @param x
   * @param y
   * @return accumulator
   */
  public double execute(double x, double y, double t) {
    double xi = -x;
    double yi = -y;
    double r = Math.sqrt(x * x + y * y);
    double ri = 1.0 - r;
    double ti = -t;
    double accu = 0.0;
    int dSp = 0;
    int ip = 0;
    int argLength = 0;
    while (ip < tapeLength) {
      switch (codeTape[ip]) {
      case oprStop:
        return accu;
      case oprPop:
        accu = dStack[--dSp];
        break;
      case oprPushConst:
        dStack[dSp++] = dOper[ip];
        break;
      case oprPushAccu:
        dStack[dSp++] = accu;
        break;
      case oprPushX:
        dStack[dSp++] = x;
        break;
      case oprPushY:
        dStack[dSp++] = y;
        break;
      case oprPushXI:
        dStack[dSp++] = xi;
        break;
      case oprPushYI:
        dStack[dSp++] = yi;
        break;
      case oprPushR:
        dStack[dSp++] = r;
        break;
      case oprPushRI:
        dStack[dSp++] = ri;
        break;
      case oprPushT:
        dStack[dSp++] = t;
        break;
      case oprPushTI:
        dStack[dSp++] = ti;
        break;
      case oprIf:
        accu = dStack[--dSp];
        if (accu < 0.0) {
          ip = iOper[ip] - 1;
        }
        break;
      case oprJmp:
        ip = iOper[ip] - 1;
        break;
      case oprAdd:
        argLength = iOper[ip]; {
        accu = dStack[--dSp];
        while (argLength > 1) {
          accu += dStack[--dSp];
          --argLength;
        }
      }
        break;
      case oprMult:
        argLength = iOper[ip]; {
        accu = dStack[--dSp];
        while (argLength > 1) {
          accu *= dStack[--dSp];
          --argLength;
        }
      }
        break;
      case oprSub:
        argLength = iOper[ip]; {
        accu = dStack[--dSp];
        while (argLength > 1) {
          accu -= dStack[--dSp];
          --argLength;
        }
      }
        break;
      case oprDiv:
        argLength = iOper[ip]; {
        accu = dStack[--dSp];
        while (argLength > 1) {
          double divisor = dStack[--dSp];
          try {
            accu /= divisor;
          } catch (ArithmeticException ae) {
            if (Math.abs(accu) != accu) // it's either infinity or negative infinity
            {
              accu = Double.NEGATIVE_INFINITY;
            } else {
              accu = Double.POSITIVE_INFINITY;
            }
          }
          --argLength;
        }
      }
        break;
      case oprNoise:
        argLength = iOper[ip];
        assert argLength == 3 : "argument length of operator 'noise' should be 3"; {
        double nx = dStack[--dSp];
        double ny = dStack[--dSp];
        double nz = dStack[--dSp];
        accu = povNoise.getNoise(nx, ny, nz);
      }
        break;
      case oprTurbulence:
        argLength = iOper[ip];
        assert argLength == 4 : "argument length of operator 'turbulence' should be 4"; {
        double nx = dStack[--dSp];
        double ny = dStack[--dSp];
        double nz = dStack[--dSp];
        int octaves = (int) Math.log(Math.abs(1.0 + dStack[--dSp]));
        octaves = octaves > 7 ? 8 : octaves + 1;
        accu = povNoise.getTurbulence(nx, ny, nz, octaves);
      }
        break;
      case oprSnoise:
        argLength = iOper[ip];
        assert argLength == 4 : "argument length of operator 'snoise' should be 4"; {
        double nx = dStack[--dSp];
        double ny = dStack[--dSp];
        double nz = dStack[--dSp];
        double scale = dStack[--dSp];
        accu = povNoise.getNoise(scale * nx, scale * ny, scale * nz);
      }
        break;
      case oprSturbulence:
        argLength = iOper[ip];
        assert argLength == 5 : "argument length of operator 'sturbulence' should be 5"; {
        double nx = dStack[--dSp];
        double ny = dStack[--dSp];
        double nz = dStack[--dSp];
        int octaves = (int) Math.log(Math.abs(1.0 + dStack[--dSp]));
        octaves = octaves > 7 ? 8 : octaves + 1;
        double scale = dStack[--dSp];
        accu = povNoise.getTurbulence(scale * nx, scale * ny, scale * nz, octaves);
      }
        break;
      case oprPow:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'pow' should be 2"; {
        double n1 = dStack[--dSp];
        double n2 = dStack[--dSp];
        accu = Math.pow(Math.abs(n1), n2);
      }
        break;
      case oprSqrt:
        argLength = iOper[ip];
        assert argLength == 1 : "argument length of operator 'sqrt' should be 1"; {
        double n1 = dStack[--dSp];
        accu = Math.sqrt(Math.abs(n1));
      }
        break;
      case oprTan:
        argLength = iOper[ip];
        assert argLength == 1 : "argument length of operator 'tan' should be 1"; {
        double n1 = dStack[--dSp];
        accu = Math.tan(n1);
      }
        break;
      case oprSin:
        argLength = iOper[ip];
        assert argLength == 1 : "argument length of operator 'sin' should be 1"; {
        double n1 = dStack[--dSp];
        accu = Math.sin(n1);
      }
        break;
      case oprCos:
        argLength = iOper[ip];
        assert argLength == 1 : "argument length of operator 'cos' should be 1"; {
        double n1 = dStack[--dSp];
        accu = Math.cos(n1);
      }
        break;
      case oprAtanq:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'atanq' should be 2"; {
        double n1 = dStack[--dSp];
        double n2 = dStack[--dSp];
        if ((Math.abs(n1) < ScalarVM.epsilon) && (Math.abs(n2) < ScalarVM.epsilon))
          accu = 0.0;
        else
          accu = Math.atan2(n1, n2);
      }
        break;
      case oprAtan:
        argLength = iOper[ip];
        assert argLength == 1 : "argument length of operator 'atan' should be 1"; {
        double n1 = dStack[--dSp];
        accu = Math.atan(n1);
      }
        break;
      case oprLog:
        argLength = iOper[ip];
        assert argLength == 1 : "argument length of operator 'log' should be 1"; {
        double n1 = dStack[--dSp];
        if (n1 > ScalarVM.epsilon)
          accu = Math.log(n1);
        else if (n1 < -ScalarVM.epsilon)
          accu = Math.log(-n1);
        else
          accu = Double.NEGATIVE_INFINITY;
      }
        break;
      case oprMix:
        argLength = iOper[ip];
        assert argLength == 3 : "argument length of operator 'mix' should be 3"; {
        double n1 = dStack[--dSp];
        double n2 = dStack[--dSp];
        double n3 = dStack[--dSp];
        if (n3 < 0.0)
          n3 = 0.0;
        else if (n3 > 1.0)
          n3 = 1.0;
        accu = (1.0 - n3) * n1 + n3 * n2;
      }
        break;
      case oprMixx:
        argLength = iOper[ip];
        assert argLength == 5 : "argument length of operator 'mixx' should be 5"; {
        double n1 = dStack[--dSp];
        double n2 = dStack[--dSp];
        double n3 = dStack[--dSp];
        double n4 = dStack[--dSp];
        double n5 = dStack[--dSp];
        if (n4 < 0.0)
          n4 = 0.0;
        else if (n4 > 1.0)
          n4 = 1.0;
        accu = (1.0 - n4) * n1 + n4 * n2;
        if (n5 < 0.0)
          n5 = 0.0;
        else if (n5 > 1.0)
          n5 = 1.0;
        accu = (1.0 - n5) * accu + n5 * n2;
      }
        break;
      case oprStep:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'step' should be 2"; {
        double n1 = dStack[--dSp];
        double n2 = dStack[--dSp];
        accu = kandid.util.Util.step(n1, n2);
      }
        break;
      case oprPuls:
        argLength = iOper[ip];
        assert argLength == 3 : "argument length of operator 'puls' should be 3"; {
        double n1 = dStack[--dSp];
        double n2 = dStack[--dSp];
        double n3 = dStack[--dSp];
        accu = kandid.util.Util.step(n1, n3) - kandid.util.Util.step(n2, n3);
      }
        break;
      case oprClamp:
        argLength = iOper[ip];
        assert argLength == 3 : "argument length of operator 'clamp' should be 3"; {
        double n1 = dStack[--dSp];
        double n2 = dStack[--dSp];
        double n3 = dStack[--dSp];
        if (n2 > n3) {
          double temp = n2;
          n2 = n3;
          n3 = temp;
        }
        if (n1 < n2)
          accu = n2;
        else if (n1 > n3)
          accu = n3;
        else
          accu = n1;
      }
        break;
      case oprMax:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'max' should be 2"; {
        double n1 = dStack[--dSp];
        double n2 = dStack[--dSp];
        if (n1 > n2)
          accu = n1;
        else
          accu = n2;
      }
        break;
      case oprMin:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'min' should be 2"; {
        double n1 = dStack[--dSp];
        double n2 = dStack[--dSp];
        if (n1 < n2)
          accu = n1;
        else
          accu = n2;
      }
        break;
      case oprAbs:
        argLength = iOper[ip];
        assert argLength == 1 : "argument length of operator 'abs' should be 1"; {
        double n1 = dStack[--dSp];
        if (n1 < 0.0)
          accu = -n1;
        else
          accu = n1;
      }
        break;
      case oprSmoothstep:
        argLength = iOper[ip];
        assert argLength == 3 : "argument length of operator 'smoothstep' should be 3"; {
        double n1 = dStack[--dSp];
        double n2 = dStack[--dSp];
        double n3 = dStack[--dSp];
        if (n3 < n1) {
          accu = 0.0;
        } else if (n3 >= n2) {
          accu = 1.0;
        } else if (Math.abs(n2 - n1) > ScalarVM.epsilon) {
          n3 = (n3 - n1) / (n2 - n1);
          accu = n3 * n3 * (3.0 - 2.0 * n3);
        } else {
          accu = 1.0;
        }
      }
        break;
      case oprBoxstep:
        argLength = iOper[ip];
        assert argLength == 3 : "argument length of operator 'boxstep' should be 3"; {
        double n1 = dStack[--dSp];
        double n2 = dStack[--dSp];
        double n3 = dStack[--dSp];
        accu = kandid.util.Util.clamp((n3 - n1) / (n2 - n1));
      }
        break;
      case oprMod:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'mod' should be 2"; {
        double n1 = dStack[--dSp];
        double n2 = dStack[--dSp];
        if (Math.abs(n2) > ScalarVM.epsilon) {
          int n = (int) (n1 / n2);
          n1 -= n * n2;
          if (n1 < 0.0)
            n1 += n2;
          accu = n1;
        } else
          accu = 0.0;
      }
        break;
      case oprFloor:
        argLength = iOper[ip];
        assert argLength == 1 : "argument length of operator 'floor' should be 1"; {
        double n1 = dStack[--dSp];
        accu = Math.floor(n1);
      }
        break;
      case oprCeil:
        argLength = iOper[ip];
        assert argLength == 1 : "argument length of operator 'ceil' should be 1"; {
        double n1 = dStack[--dSp];
        accu = Math.ceil(n1);
      }
        break;
      case oprGamma:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'gamma' should be 2"; {
        double n1 = dStack[--dSp];
        double n2 = dStack[--dSp];
        if (Math.abs(n1) > ScalarVM.epsilon)
          accu = Math.pow(Math.abs(n2), 1 / n1);
        else
          accu = Double.POSITIVE_INFINITY;
      }
        break;
      case oprGain:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'gain' should be 2"; {
        double n1 = dStack[--dSp];
        double n2 = dStack[--dSp];
        if (n2 < 0.5)
          accu = kandid.util.Util.bias(1.0 - n1, 2.0 * n2) / 2.0;
        else
          accu = 1.0 - kandid.util.Util.bias(1.0 - n1, 2.0 - 2.0 * n2) / 2.0;
      }
        break;
      case oprBias:
        argLength = iOper[ip];
        assert argLength == 2 : "argument length of operator 'bias' should be 2"; {
        double n1 = dStack[--dSp];
        double n2 = dStack[--dSp];
        accu = kandid.util.Util.bias(n1, n2);
      }
        break;
      case oprEuclide:
        argLength = iOper[ip];
        assert argLength == 4 : "argument length of operator 'euclide' should be 4"; {
        double n1 = dStack[--dSp];
        double n2 = dStack[--dSp];
        double n3 = dStack[--dSp];
        double n4 = dStack[--dSp];
        n1 = n3 - n1;
        n2 = n4 - n2;
        accu = Math.sqrt(n1 * n1 + n2 * n2);
      }
        break;
      case oprAbsolute:
        argLength = iOper[ip];
        assert argLength == 4 : "argument length of operator 'absolute' should be 4"; {
        double n1 = dStack[--dSp];
        double n2 = dStack[--dSp];
        double n3 = dStack[--dSp];
        double n4 = dStack[--dSp];
        accu = Math.abs(n3 - n1) + Math.abs(n4 - n2);
      }
        break;
      default:
        assert false : "invalid code " + codeTape[ip] + " on tape position " + ip;
        break;
      }
      ++ip;
    }
    return accu;
  }

  /**
   * @see java.lang.Object#toString()
   */
  public String toString() {
    StringBuffer asm = new StringBuffer();
    int argLength = 0;
    int ip = 0;
    while (ip < tapeLength) {
      asm.append(ip + "\t");
      switch (codeTape[ip]) {
      case oprStop:
        asm.append("stop");
        break;
      case oprPop:
        asm.append("pop");
        break;
      case oprPushConst:
        asm.append("pushConst  ");
        asm.append(dOper[ip]);
        break;
      case oprPushAccu:
        asm.append("pushAccu");
        break;
      case oprPushX:
        asm.append("pushX");
        break;
      case oprPushY:
        asm.append("pushY");
        break;
      case oprPushXI:
        asm.append("pushXI");
        break;
      case oprPushYI:
        asm.append("pushYI");
        break;
      case oprPushR:
        asm.append("pushR");
        break;
      case oprPushRI:
        asm.append("pushRI");
        break;
      case oprPushT:
        asm.append("pushT");
        break;
      case oprPushTI:
        asm.append("pushTI");
        break;
      case oprIf:
        asm.append("if\t");
        asm.append(iOper[ip]);
        break;
      case oprJmp:
        asm.append("jmp\t");
        asm.append(iOper[ip]);
        break;
      case oprAdd:
        asm.append("add\t");
        asm.append(iOper[ip]);
        break;
      case oprMult:
        asm.append("mult\t");
        asm.append(iOper[ip]);
        break;
      case oprSub:
        asm.append("sub\t");
        asm.append(iOper[ip]);
        break;
      case oprDiv:
        asm.append("div\t");
        asm.append(iOper[ip]);
        break;
      case oprNoise:
        asm.append("noise\t");
        asm.append(iOper[ip]);
        break;
      case oprTurbulence:
        asm.append("turbulence\t");
        asm.append(iOper[ip]);
        break;
      case oprSnoise:
        asm.append("snoise\t");
        asm.append(iOper[ip]);
        break;
      case oprSturbulence:
        asm.append("sturbulence\t");
        asm.append(iOper[ip]);
        break;
      case oprPow:
        asm.append("pow\t");
        asm.append(iOper[ip]);
        break;
      case oprSqrt:
        asm.append("sqrt\t");
        asm.append(iOper[ip]);
        break;
      case oprTan:
        asm.append("tan\t");
        asm.append(iOper[ip]);
        break;
      case oprSin:
        asm.append("sin\t");
        asm.append(iOper[ip]);
        break;
      case oprCos:
        asm.append("cos\t");
        asm.append(iOper[ip]);
        break;
      case oprAtanq:
        asm.append("atanq\t");
        asm.append(iOper[ip]);
        break;
      case oprAtan:
        asm.append("atan\t");
        asm.append(iOper[ip]);
        break;
      case oprLog:
        asm.append("log\t");
        asm.append(iOper[ip]);
        break;
      case oprMix:
        asm.append("mix\t");
        asm.append(iOper[ip]);
        break;
      case oprMixx:
        asm.append("mixx\t");
        asm.append(iOper[ip]);
        break;
      case oprStep:
        asm.append("step\t");
        asm.append(iOper[ip]);
        break;
      case oprPuls:
        asm.append("puls\t");
        asm.append(iOper[ip]);
        break;
      case oprClamp:
        asm.append("clamp\t");
        asm.append(iOper[ip]);
        break;
      case oprMax:
        asm.append("max\t");
        asm.append(iOper[ip]);
        break;
      case oprMin:
        asm.append("min\t");
        asm.append(iOper[ip]);
        break;
      case oprAbs:
        asm.append("abs\t");
        asm.append(iOper[ip]);
        break;
      case oprSmoothstep:
        asm.append("smoothstep\t");
        asm.append(iOper[ip]);
        break;
      case oprBoxstep:
        asm.append("boxstep\t");
        asm.append(iOper[ip]);
        break;
      case oprMod:
        asm.append("mod\t");
        asm.append(iOper[ip]);
        break;
      case oprFloor:
        asm.append("floor\t");
        asm.append(iOper[ip]);
        break;
      case oprCeil:
        asm.append("ceil\t");
        asm.append(iOper[ip]);
        break;
      case oprGamma:
        asm.append("gamma\t");
        asm.append(iOper[ip]);
        break;
      case oprGain:
        asm.append("gain\t");
        asm.append(iOper[ip]);
        break;
      case oprBias:
        asm.append("bias\t");
        asm.append(iOper[ip]);
        break;
      case oprEuclide:
        asm.append("euclide\t");
        asm.append(iOper[ip]);
        break;
      case oprAbsolute:
        asm.append("absolute\t");
        asm.append(iOper[ip]);
        break;
      default:
        asm.append("invalid code\t");
        asm.append(iOper[ip]);
        assert false : "invalid code " + codeTape[ip] + " on tape position " + ip;
        break;
      }
      asm.append('\n');
      ++ip;
    }
    return asm.toString();
  }
}
